\name{ZeroFluxNeumannPadImageFilter}
\alias{ZeroFluxNeumannPadImageFilter}
\title{ZeroFluxNeumannPadImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Increase the image size by padding according to the zero-flux Neumann
boundary condition.
ZeroFluxNeumannPadImageFilter}
\details{
A filter which extends the image size and fill the missing pixels
according to a Neumann boundary condition where first, upwind
derivatives on the boundary are zero. This is a useful condition in
solving some classes of differential equations.
For example, invoking this filter on an image with a corner like: returns the following padded image:
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
See:
WrapPadImageFilter , MirrorPadImageFilter , ConstantPadImageFilter , ZeroFluxNeumannBoundaryCondition
ZeroFluxNeumannPad for the procedural interface
itk::ZeroFluxNeumannPadImageFilter for the Doxygen on the original ITK class.
ZeroFluxNeumannPadImageFilter}
%C++ includes: sitkZeroFluxNeumannPadImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< unsigned int > GetPadLowerBound() const:}{}
\item{std::vector< unsigned int > GetPadUpperBound() const:}{}
\item{Self SetPadLowerBound(std::vector< unsigned int > PadLowerBound):}{}
\item{Self SetPadUpperBound(std::vector< unsigned int > PadUpperBound):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ZeroFluxNeumannPadImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{ ~ZeroFluxNeumannPadImageFilter():}{
Destructor
}
}
}
