\name{SimpleContourExtractorImageFilter}
\alias{SimpleContourExtractorImageFilter}
\title{SimpleContourExtractorImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Computes an image of contours which will be the contour of the first
image.
SimpleContourExtractorImageFilter}
\details{
A pixel of the source image is considered to belong to the contour if
its pixel value is equal to the input foreground value and it has in
its neighborhood at least one pixel which its pixel value is equal to
the input background value. The output image will have pixels which
will be set to the output foreground value if they belong to the
contour, otherwise they will be set to the output background value.
The neighborhood "radius" is set thanks to the radius params.
See:
Image
Neighborhood
NeighborhoodOperator
NeighborhoodIterator
SimpleContourExtractor for the procedural interface
itk::SimpleContourExtractorImageFilter for the Doxygen on the original ITK class.
SimpleContourExtractorImageFilter}
%C++ includes: sitkSimpleContourExtractorImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetInputBackgroundValue() const:}{
Get the background value used in order to identify a background pixel
in the input image.
}
\item{double GetInputForegroundValue() const:}{
Get the foreground value used in order to identify a foreground pixel
in the input image.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetOutputBackgroundValue() const:}{
Get the background value used in order to identify a background pixel
in the output image.
}
\item{double GetOutputForegroundValue() const:}{
Get the foreground value used in order to identify a foreground pixel
in the output image.
}
\item{std::vector< unsigned int > GetRadius() const:}{}
\item{Self SetInputBackgroundValue(double InputBackgroundValue):}{
Set the background value used in order to identify a background pixel
in the input image.
}
\item{Self SetInputForegroundValue(double InputForegroundValue):}{
Set the foreground value used in order to identify a foreground pixel
in the input image.
}
\item{Self SetOutputBackgroundValue(double OutputBackgroundValue):}{
Set the background value used in order to identify a background pixel
in the output image.
}
\item{Self SetOutputForegroundValue(double OutputForegroundValue):}{
Set the foreground value used in order to identify a foreground pixel
in the output image.
}
\item{Self SetRadius(std::vector< unsigned int > Radius):}{}
\item{Self SetRadius(unsigned int value):}{
Set the values of the Radius vector all to value
}
\item{ SimpleContourExtractorImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~SimpleContourExtractorImageFilter():}{
Destructor
}
}
}
