\name{ResampleImageFilter}
\alias{ResampleImageFilter}
\title{ResampleImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Resample an image via a coordinate transform.
ResampleImageFilter}
\details{
ResampleImageFilter resamples an existing image through some coordinate transform,
interpolating via some image function. The class is templated over the
types of the input and output images.
Note that the choice of interpolator function can be important. This
function is set via SetInterpolator() . The default is LinearInterpolateImageFunction <InputImageType, TInterpolatorPrecisionType>, which is reasonable for
ordinary medical images. However, some synthetic images have pixels
drawn from a finite prescribed set. An example would be a mask
indicating the segmentation of a brain into a small number of tissue
types. For such an image, one does not want to interpolate between
different pixel values, and so NearestNeighborInterpolateImageFunction < InputImageType, TCoordRep > would be a better choice.
If an sample is taken from outside the image domain, the default
behavior is to use a default pixel value. If different behavior is
desired, an extrapolator function can be set with SetExtrapolator() .
Output information (spacing, size and direction) for the output image
should be set. This information has the normal defaults of unit
spacing, zero origin and identity direction. Optionally, the output
information can be obtained from a reference image. If the reference
image is provided and UseReferenceImage is On, then the spacing,
origin and direction of the reference image will be used.
Since this filter produces an image which is a different size than its
input, it needs to override several of the methods defined in ProcessObject in order to properly manage the pipeline execution model. In
particular, this filter overrides ProcessObject::GenerateInputRequestedRegion() and ProcessObject::GenerateOutputInformation() .
This filter is implemented as a multithreaded filter. It provides a
DynamicThreadedGenerateData() method for its implementation.
WARNING:
For multithreading, the TransformPoint method of the user-designated
coordinate transform must be threadsafe.
See:
itk::ResampleImageFilter for the Doxygen on the original ITK class.
ResampleImageFilter}
%C++ includes: sitkResampleImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetDefaultPixelValue() const:}{
Get/Set the pixel value when a transformed pixel is outside of the
image. The default default pixel value is 0.
}
\item{InterpolatorEnum GetInterpolator() const:}{
Get/Set the interpolator function. The default is LinearInterpolateImageFunction <InputImageType, TInterpolatorPrecisionType>. Some other options are NearestNeighborInterpolateImageFunction (useful for binary masks and other images with a small number of
possible pixel values), and BSplineInterpolateImageFunction (which provides a higher order of interpolation).
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< double > GetOutputDirection() const:}{
Set the output direction cosine matrix.
}
\item{std::vector< double > GetOutputOrigin() const:}{
Get the output image origin.
}
\item{PixelIDValueEnum GetOutputPixelType() const:}{
Get the ouput pixel type.
}
\item{std::vector< double > GetOutputSpacing() const:}{
Get the output image spacing.
}
\item{std::vector< uint32_t > GetSize() const:}{
Get/Set the size of the output image.
}
\item{Transform GetTransform() const:}{}
\item{bool GetUseNearestNeighborExtrapolator() const:}{}
\item{ ResampleImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetDefaultPixelValue(double DefaultPixelValue):}{
Get/Set the pixel value when a transformed pixel is outside of the
image. The default default pixel value is 0.
}
\item{Self SetInterpolator(InterpolatorEnum Interpolator):}{
Get/Set the interpolator function. The default is LinearInterpolateImageFunction <InputImageType, TInterpolatorPrecisionType>. Some other options are NearestNeighborInterpolateImageFunction (useful for binary masks and other images with a small number of
possible pixel values), and BSplineInterpolateImageFunction (which provides a higher order of interpolation).
}
\item{Self SetOutputDirection(std::vector< double > OutputDirection):}{
Set the output direction cosine matrix.
}
\item{Self SetOutputOrigin(std::vector< double > OutputOrigin):}{
Set the output image origin.
}
\item{Self SetOutputPixelType(PixelIDValueEnum OutputPixelType):}{
Set the output pixel type, if sitkUnknown then the input type is used.
}
\item{Self SetOutputSpacing(std::vector< double > OutputSpacing):}{
Set the output image spacing.
}
\item{void SetReferenceImage(const Image &refImage):}{
This methods sets the output size, origin, spacing and direction to
that of the provided image
}
\item{Self SetSize(std::vector< uint32_t > Size):}{
Get/Set the size of the output image.
}
\item{Self SetTransform(Transform Transform):}{}
\item{Self SetUseNearestNeighborExtrapolator(bool UseNearestNeighborExtrapolator):}{
Enables the nearest neighbor extrapolator as opposed to the constant
pixel value.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{Self UseNearestNeighborExtrapolatorOff():}{}
\item{Self UseNearestNeighborExtrapolatorOn():}{
Set the value of UseNearestNeighborExtrapolator to true or false
respectfully.
}
\item{ ~ResampleImageFilter():}{
Destructor
}
}
}
