\name{InvertIntensityImageFilter}
\alias{InvertIntensityImageFilter}
\title{InvertIntensityImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Invert the intensity of an image.
InvertIntensityImageFilter}
\details{
InvertIntensityImageFilter inverts intensity of pixels by subtracting pixel value to a maximum
value. The maximum value can be set with SetMaximum and defaults the
maximum of input pixel type. This filter can be used to invert, for
example, a binary image, a distance map, etc.
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
See:
IntensityWindowingImageFilter ShiftScaleImageFilter
InvertIntensity for the procedural interface
itk::InvertIntensityImageFilter for the Doxygen on the original ITK class.
InvertIntensityImageFilter}
%C++ includes: sitkInvertIntensityImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{double GetMaximum() const:}{
Set/Get the maximum intensity value for the inversion.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ InvertIntensityImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetMaximum(double Maximum):}{
Set/Get the maximum intensity value for the inversion.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~InvertIntensityImageFilter():}{
Destructor
}
}
}
