\name{FastMarchingImageFilter}
\alias{FastMarchingImageFilter}
\title{FastMarchingImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Solve an Eikonal equation using Fast Marching.
FastMarchingImageFilter}
\details{
Fast marching solves an Eikonal equation where the speed is always
non-negative and depends on the position only. Starting from an
initial position on the front, fast marching systematically moves the
front forward one grid point at a time.
Updates are performed using an entropy satisfy scheme where only
"upwind" neighborhoods are used. This implementation of Fast
Marching uses a std::priority_queue to locate the next proper grid
position to update.
Fast Marching sweeps through N grid points in (N log N) steps to
obtain the arrival time value as the front propagates through the
grid.
Implementation of this class is based on Chapter 8 of "Level Set
Methods and Fast Marching Methods", J.A. Sethian, Cambridge Press,
Second edition, 1999.
This class is templated over the level set image type and the speed
image type. The initial front is specified by two containers: one
containing the known points and one containing the trial points. Alive
points are those that are already part of the object, and trial points
are considered for inclusion. In order for the filter to evolve, at
least some trial points must be specified. These can for instance be
specified as the layer of pixels around the alive points.
The speed function can be specified as a speed image or a speed
constant. The speed image is set using the method SetInput() . If the
speed image is nullptr, a constant speed function is used and is
specified using method the SetSpeedConstant() .
If the speed function is constant and of value one, fast marching
results in an approximate distance function from the initial alive
points. FastMarchingImageFilter is used in the ReinitializeLevelSetImageFilter object to create a signed distance function from the zero level set.
The algorithm can be terminated early by setting an appropriate
stopping value. The algorithm terminates when the current arrival time
being processed is greater than the stopping value.
There are two ways to specify the output image information (
LargestPossibleRegion, Spacing, Origin): (a) it is copied directly
from the input speed image or (b) it is specified by the user. Default
values are used if the user does not specify all the information.
The output information is computed as follows. If the speed image is
nullptr or if the OverrideOutputInformation is set to true, the output
information is set from user specified parameters. These parameters
can be specified using methods SetOutputRegion() , SetOutputSpacing()
, SetOutputDirection() , and SetOutputOrigin() . Else if the speed
image is not nullptr, the output information is copied from the input
speed image.
For an alternative implementation, see itk::FastMarchingImageFilter .
Possible Improvements: In the current implementation,
std::priority_queue only allows taking nodes out from the front and
putting nodes in from the back. To update a value already on the heap,
a new node is added to the heap. The defunct old node is left on the
heap. When it is removed from the top, it will be recognized as
invalid and not used. Future implementations can implement the heap in
a different way allowing the values to be updated. This will generally
require some sift-up and sift-down functions and an image of back-
pointers going from the image to heap in order to locate the node
which is to be updated.
See:
FastMarchingImageFilterBase
LevelSetTypeDefault
FastMarching for the procedural interface
itk::FastMarchingImageFilter for the Doxygen on the original ITK class.
FastMarchingImageFilter}
%C++ includes: sitkFastMarchingImageFilter.h
\section{Methods}{
\describe{
\item{Self AddTrialPoint(std::vector< unsigned int > point):}{
Add TrialPoints point.
}
\item{Self ClearTrialPoints():}{
Remove all TrialPoints points.
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{ FastMarchingImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::vector< double > GetInitialTrialValues() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetNormalizationFactor() const:}{
Set/Get the Normalization Factor for the Speed Image . The values in the Speed Image is divided by this factor. This allows the use of images with integer
pixel types to represent the speed.
}
\item{double GetStoppingValue() const:}{
Get the Fast Marching algorithm Stopping Value.
}
\item{std::vector< std::vector< unsigned int > > GetTrialPoints() const:}{
Get the container of Trial Points representing the initial front.
}
\item{Self SetInitialTrialValues(std::vector< double > InitialTrialValues):}{
Set the initial seed values for corresponding trial points.
}
\item{Self SetNormalizationFactor(double NormalizationFactor):}{
Set/Get the Normalization Factor for the Speed Image . The values in the Speed Image is divided by this factor. This allows the use of images with integer
pixel types to represent the speed.
}
\item{Self SetStoppingValue(double StoppingValue):}{
Set the Fast Marching algorithm Stopping Value. The Fast Marching
algorithm is terminated when the value of the smallest trial point is
greater than the stopping value.
}
\item{Self SetTrialPoints(std::vector< std::vector< unsigned int > > TrialPoints):}{
Set the container of Trial Points representing the initial front.
Trial points are represented as a VectorContainer of LevelSetNodes.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~FastMarchingImageFilter():}{
Destructor
}
}
}
