\name{RegionOfInterestImageFilter}
\alias{RegionOfInterestImageFilter}
\title{RegionOfInterestImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Extract a region of interest from the input image.
RegionOfInterestImageFilter}
\details{
This filter produces an output image of the same dimension as the
input image. The user specifies the region of the input image that
will be contained in the output image. The origin coordinates of the
output images will be computed in such a way that if mapped to
physical space, the output image will overlay the input image with
perfect registration. In other words, a registration process between
the output image and the input image will return an identity
transform.
If you are interested in changing the dimension of the image, you may
want to consider the ExtractImageFilter . For example for extracting a 2D image from a slice of a 3D image.
The region to extract is set using the method SetRegionOfInterest.
See:
ExtractImageFilter
RegionOfInterest for the procedural interface
itk::RegionOfInterestImageFilter for the Doxygen on the original ITK class.
RegionOfInterestImageFilter}
%C++ includes: sitkRegionOfInterestImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::vector< int > GetIndex() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< unsigned int > GetSize() const:}{}
\item{ RegionOfInterestImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetIndex(std::vector< int > Index):}{
Set the inclusive starting index of the region extracted.
}
\item{void SetRegionOfInterest(const std::vector< unsigned int > &Region):}{
Sets the region extracted by a single array of the starting indexes
followed by the sizes in pixels.
}
\item{Self SetSize(std::vector< unsigned int > Size):}{
Size in pixels of the region extracted.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~RegionOfInterestImageFilter():}{
Destructor
}
}
}
