#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-FBVN7XgtVW91Dz4mPGkDeZ
key:                  postgrest-10.0.0-FBVN7XgtVW91Dz4mPGkDeZ
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  51124ffc1c4df42a5ed61d78697f699c
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-FBVN7XgtVW91Dz4mPGkDeZ
depends:
    HTTP-4000.4.1-LXcOO85bKTdH5DnkDtc68v
    Ranged-sets-0.5.0-8OsitJ6SVXE3Keqq6hvOl5
    aeson-2.1.2.1-3LOl3stht3x9JybSpHkoQT
    auto-update-0.1.6-1T9hY7rWbILKWtQfPwkC4S base-4.17.2.1
    base64-bytestring-1.2.1.0-7CU13IWnWdcDMU9nDc25iT
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-DLRBsz9VfqUNwIWg4HsHR
    cassava-0.5.4.1-2iJ7OCM9UuS5rwlnOZspru
    configurator-pg-0.2.10-7gpSbjWUWCECh14gGQHEk3 containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.5.0-Khxmud11aHE2bTuo1AKBzI directory-1.3.7.1
    either-5.0.3-KRh3CxEyBRZB9W8w5Krbv4
    gitrev-1.3.1-EAQEu0I0MYZ3NOvBCjPIAO
    hasql-1.5.0.5-9NuhBZt65PRp6iQsbVMog
    hasql-dynamic-statements-0.3.1.1-Gbl4bHo7gLPGObfh8lwpA6
    hasql-notifications-0.2.0.5-Bk46eTTbQQJJSX1LeyxjzJ
    hasql-pool-0.5.2.2-H3zW3AVIuXMhi4R9Lx2Bl
    hasql-transaction-1.0.1.1-KNR8GA8fwpB8yaspjpqONZ
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-6ojMayzAfwB91OTgOklzJ2
    insert-ordered-containers-0.2.5.3-GhRoCGkSv6S83TE0sczSkv
    interpolatedstring-perl6-1.0.2-JU6gRWGTpuTIvT0KSztT5v
    jose-0.10-5puVtcGnxr12lx90T32DyL lens-5.3.3-26VlyqkFVMA2DXZQVmsUyD
    lens-aeson-1.2.3-84kdafG8UFxJXWg8yVqAHG mtl-2.2.2
    network-3.1.4.0-1n8WDlzhAQUHYfqI16mYdv
    network-uri-2.6.4.2-KmmPt5MfJi07BPtstNPoD0
    optparse-applicative-0.18.1.0-7AikOdbhtzBKh97m9q2q6o
    parsec-3.1.16.1 protolude-0.3.5-Leo14nPeoI1IM86HhfRx8m
    regex-tdfa-1.3.2.5-Gv6LsF4EJj23ouLVTe9nXQ
    retry-0.9.3.1-CqX3MTHdhrV574fD4YHnQd
    scientific-0.3.8.0-APNnjCxblnoKMeXmBXkKkr
    swagger2-2.8.10-9P4fjWMC2DdJxWFglyXMGl text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20.1-98Hg6PuNW0XDqLHXL1727Z
    vault-0.3.1.5-4gF0EmVSiou5kWjNJoHeCR
    vector-0.13.2.0-24VaMY7coOLw3wI0c1W3K
    wai-3.2.4-HXL0p0WqRSGJXNDZnyl0Hj
    wai-cors-0.2.7-3oTB00UGbeXAqA7rjIdvDo
    wai-extra-3.1.18-a3N8VoGXAg5KBaSqy8NBc
    wai-logger-2.5.0-3sjzPPpr4xE1eGDPLbaw9v
    warp-3.4.0-9odkFZsHMyT9nAjq8C8gI1

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

