/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.persist.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLRuntimeException;
import org.slf4j.Logger;

public class SegmentingIntermediateDirectoryStrategy
implements Function<String, List<String>> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SegmentingIntermediateDirectoryStrategy.class);
    @Nonnull
    private Function<String, String> sourceStrategy;
    private int segmentNumber;
    private int segmentLength;

    public SegmentingIntermediateDirectoryStrategy(@ParameterName(name="segmentNumber") int number, @ParameterName(name="segmentLength") int length, @ParameterName(name="sourceStrategy") @Nonnull Function<String, String> source) {
        this.segmentNumber = Constraint.isGreaterThan(0, number, "Number of segments was zero");
        this.segmentLength = Constraint.isGreaterThan(0, length, "Length of segments was zero");
        this.sourceStrategy = Constraint.isNotNull(source, "Source strategy was null");
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    public List<String> apply(String key) {
        String source = this.sourceStrategy.apply(key);
        if (source == null || source.length() == 0) {
            this.log.trace("Source strategy returned null or empty, returning null");
            return null;
        }
        this.log.trace("Resolved source: {}", (Object)source);
        if (source.length() < this.segmentNumber * this.segmentLength) {
            String msg = String.format("Source length %d is less than number (%d) * length (%d) of segments: %s", source.length(), this.segmentNumber, this.segmentLength, source);
            this.log.warn(msg);
            throw new XMLRuntimeException(msg);
        }
        ArrayList<String> segments = new ArrayList<String>();
        for (int i = 0; i < this.segmentNumber; ++i) {
            int startIndex = i * this.segmentLength;
            int endIndex = startIndex + this.segmentLength;
            String segment = key.substring(startIndex, endIndex);
            this.log.trace("Produced directory segment: {}", (Object)segment);
            segments.add(segment);
        }
        return segments;
    }
}

