/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.get_mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.mapping.TypeMapping;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IndexMappingRecord
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, IndexMappingRecord> {
    @Nullable
    private final TypeMapping item;
    @Nonnull
    private final TypeMapping mappings;
    public static final JsonpDeserializer<IndexMappingRecord> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexMappingRecord::setupIndexMappingRecordDeserializer);

    private IndexMappingRecord(Builder builder) {
        this.item = builder.item;
        this.mappings = ApiTypeHelper.requireNonNull(builder.mappings, this, "mappings");
    }

    public static IndexMappingRecord of(Function<Builder, ObjectBuilder<IndexMappingRecord>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final TypeMapping item() {
        return this.item;
    }

    @Nonnull
    public final TypeMapping mappings() {
        return this.mappings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.item != null) {
            generator.writeKey("item");
            this.item.serialize(generator, mapper);
        }
        generator.writeKey("mappings");
        this.mappings.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIndexMappingRecordDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::item, TypeMapping._DESERIALIZER, "item");
        op.add(Builder::mappings, TypeMapping._DESERIALIZER, "mappings");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.item);
        result = 31 * result + this.mappings.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexMappingRecord other = (IndexMappingRecord)o;
        return Objects.equals(this.item, other.item) && this.mappings.equals(other.mappings);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, IndexMappingRecord> {
        @Nullable
        private TypeMapping item;
        private TypeMapping mappings;

        public Builder() {
        }

        private Builder(IndexMappingRecord o) {
            this.item = o.item;
            this.mappings = o.mappings;
        }

        private Builder(Builder o) {
            this.item = o.item;
            this.mappings = o.mappings;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder item(@Nullable TypeMapping value) {
            this.item = value;
            return this;
        }

        @Nonnull
        public final Builder item(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.item(fn.apply(new TypeMapping.Builder()).build());
        }

        @Nonnull
        public final Builder mappings(TypeMapping value) {
            this.mappings = value;
            return this;
        }

        @Nonnull
        public final Builder mappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappings(fn.apply(new TypeMapping.Builder()).build());
        }

        @Override
        @Nonnull
        public IndexMappingRecord build() {
            this._checkSingleUse();
            return new IndexMappingRecord(this);
        }
    }
}

