"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupBy = void 0;
var _lodash = require("lodash");
var _node = require("../node");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class GroupBy extends _node.PPLNode {
  constructor(name, children, fields, span) {
    super(name, children);
    this.fields = fields;
    this.span = span;
  }
  getTokens() {
    var _this$span;
    return {
      group_fields: this.fields.map(field => field.getTokens()),
      span: (_this$span = this.span) === null || _this$span === void 0 ? void 0 : _this$span.getTokens()
    };
  }
  toString() {
    return `${!(0, _lodash.isEmpty)(this.fields) || !(0, _lodash.isEmpty)(this.span) ? 'by ' : ''}` + `${!(0, _lodash.isEmpty)(this.span) ? `${this.span.toString()}${this.fields.length > 0 ? ', ' : ''}` : ''}${this.fields.map(field => field.toString()).join(', ')}`;
  }
}
exports.GroupBy = GroupBy;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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