/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy.other;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.jdbc.proxy.other.ConnectionProxy;
import oracle.ucp.proxy.annotation.GetCreator;
import oracle.ucp.proxy.annotation.GetDelegate;
import oracle.ucp.proxy.annotation.Methods;
import oracle.ucp.proxy.annotation.OnError;
import oracle.ucp.proxy.annotation.Post;
import oracle.ucp.proxy.annotation.Pre;
import oracle.ucp.proxy.annotation.ProxyFor;
import oracle.ucp.proxy.annotation.ProxyResult;
import oracle.ucp.proxy.annotation.ProxyResultPolicy;
import oracle.ucp.proxy.annotation.Signature;
import oracle.ucp.util.Chain;
import oracle.ucp.util.UCPErrorHandler;

@ProxyFor(value={CallableStatement.class, PreparedStatement.class, Statement.class, LogicalObject.class})
@ProxyResult(value=ProxyResultPolicy.CREATE)
public abstract class StatementProxy
implements LogicalObject,
Diagnosable {
    private static final String CLASS_NAME = StatementProxy.class.getName();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile Chain.Atom<StatementProxy> statementChainAtom = null;
    private volatile UniversalPooledConnection proxiedPooledConnection = null;
    private volatile UniversalConnectionPool proxiedPool = null;
    private boolean sqlWithQueryTimeoutInProgress = false;

    void setStatementChainAtom(Chain.Atom<StatementProxy> atom) {
        this.statementChainAtom = atom;
    }

    @GetDelegate
    protected abstract Statement getDelegate();

    @GetCreator
    protected abstract Object getCreator();

    UniversalPooledConnection getUPC() {
        ConnectionProxy c;
        UniversalPooledConnection upc = this.proxiedPooledConnection;
        if (null == upc && null != (c = (ConnectionProxy)this.getCreator())) {
            upc = this.proxiedPooledConnection = c.getUPC();
        }
        return upc;
    }

    UniversalConnectionPool getUCP() {
        ConnectionProxy c;
        UniversalConnectionPool ucp = this.proxiedPool;
        if (null == ucp && null != (c = (ConnectionProxy)this.getCreator())) {
            ucp = this.proxiedPool = c.getUCP();
        }
        return ucp;
    }

    @Override
    public boolean isLogicallyClosed() {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        return this.closed.get();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Connection getConnection() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        if (this.isClosed()) {
            throw UCPErrorHandler.newSQLException(44);
        }
        return (Connection)this.getCreator();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.sqlWithQueryTimeoutInProgress = seconds > 0;
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.getDelegate().setQueryTimeout(seconds);
        this.getUPC().heartbeat();
    }

    public void closeOnCompletion() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.getDelegate().closeOnCompletion();
        this.getUPC().heartbeat();
    }

    public boolean isClosed() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        return this.closed.get() || this.getDelegate().isClosed() || ((ConnectionProxy)this.getCreator()).closed.get();
    }

    public void close() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.statementChainAtom.remove();
        this.getDelegate().close();
        upc.heartbeat();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> iface) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        if (iface.isInterface()) {
            if (iface.isInstance(this.getDelegate())) {
                Statement t = this.getDelegate();
                return (T)t;
            }
            return this.getDelegate().unwrap(iface);
        }
        throw new SQLException("unable to unwrap interface " + iface.toString());
    }

    @Pre
    protected void pre(Method m, Object receiver, Object ... args) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(44);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        upc.setSqlWithQueryTimeoutInProgress(this.sqlWithQueryTimeoutInProgress);
        ConnectionProxy connProxy = (ConnectionProxy)this.getCreator();
        if (connProxy.isLogicallyClosed()) {
            throw UCPErrorHandler.newSQLException(31);
        }
    }

    @Post
    @Methods(signatures={@Signature(name="executeQuery", args={}), @Signature(name="executeQuery", args={String.class}), @Signature(name="getResultSet", args={}), @Signature(name="getGeneratedKeys", args={})})
    protected ResultSet post(Method m, ResultSet result) {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.sqlWithQueryTimeoutInProgress = false;
        upc.setSqlWithQueryTimeoutInProgress(false);
        return result;
    }

    @Post
    protected Object postRest(Method m, Object result) {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        return result;
    }

    @Post
    protected void postRestVoid(Method m) {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
    }

    @OnError(value=SQLException.class)
    protected void onSQLExceptionErrorVoid(Method m, SQLException e) throws SQLException {
        this.onSQLExceptionError(m, e);
    }

    @OnError(value=SQLException.class)
    protected Object onSQLExceptionError(Method m, SQLException e) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        ((ConnectionProxy)this.getCreator()).handleSQLRecoverableException(e);
        throw e;
    }

    @OnError(value=RuntimeException.class)
    protected void onRuntimeExceptionErrorVoid(Method m, RuntimeException e) throws RuntimeException {
        this.onRuntimeExceptionError(m, e);
    }

    @OnError(value=RuntimeException.class)
    protected Object onRuntimeExceptionError(Method m, RuntimeException e) throws RuntimeException {
        this.getUPC().heartbeat();
        ((ConnectionProxy)this.getCreator()).handleRuntimeException(e);
        throw e;
    }

    public boolean equals(Object thatObj) {
        if (null == thatObj) {
            return false;
        }
        if (this == thatObj) {
            return true;
        }
        return this.getDelegate().equals(thatObj instanceof StatementProxy ? ((StatementProxy)thatObj).getDelegate() : thatObj);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    @Override
    public Diagnosable getDiagnosable() {
        UniversalConnectionPool ucp = this.getUCP();
        assert (Objects.nonNull(ucp));
        return ucp.getDiagnosable();
    }
}

