/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mainwindow;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.extras.FlatAnimatedLafChange;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.UIManager;
import javax.swing.text.StyleContext;
import mediathek.mainwindow.MediathekGui;
import org.jetbrains.annotations.NotNull;

public class FontManager {
    private final MediathekGui mediathekGui;
    private final String[] availableFontFamilyNames;
    private int initialFontMenuItemCount = -1;

    public FontManager(@NotNull MediathekGui mediathekGui) {
        this.mediathekGui = mediathekGui;
        this.availableFontFamilyNames = (String[])GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames().clone();
        Arrays.sort(this.availableFontFamilyNames);
    }

    public void resetFont() {
        UIManager.put("defaultFont", null);
        this.updateFontMenuItems();
        FlatLaf.updateUI();
    }

    public void increaseFontSize() {
        Font font = UIManager.getFont("defaultFont");
        Font newFont = font.deriveFont((float)(font.getSize() + 1));
        UIManager.put("defaultFont", newFont);
        this.updateFontMenuItems();
        FlatLaf.updateUI();
    }

    public void decreaseFontSize() {
        Font font = UIManager.getFont("defaultFont");
        Font newFont = font.deriveFont((float)Math.max(font.getSize() - 1, 10));
        UIManager.put("defaultFont", newFont);
        this.updateFontMenuItems();
        FlatLaf.updateUI();
    }

    public void updateFontMenuItems() {
        if (this.initialFontMenuItemCount < 0) {
            this.initialFontMenuItemCount = this.mediathekGui.fontMenu.getItemCount();
        } else {
            for (int i = this.mediathekGui.fontMenu.getItemCount() - 1; i >= this.initialFontMenuItemCount; --i) {
                this.mediathekGui.fontMenu.remove(i);
            }
        }
        Font currentFont = UIManager.getFont("Label.font");
        String currentFamily = currentFont.getFamily();
        String currentSize = Integer.toString(currentFont.getSize());
        this.mediathekGui.fontMenu.addSeparator();
        ArrayList<String> families = new ArrayList<String>(Arrays.asList("Arial", "Cantarell", "Comic Sans MS", "DejaVu Sans", "Dialog", "Liberation Sans", "Noto Sans", "Roboto", "SansSerif", "Segoe UI", "Serif", "Tahoma", "Ubuntu", "Verdana"));
        if (!families.contains(currentFamily)) {
            families.add(currentFamily);
        }
        families.sort(String.CASE_INSENSITIVE_ORDER);
        ButtonGroup familiesGroup = new ButtonGroup();
        for (String family : families) {
            if (Arrays.binarySearch(this.availableFontFamilyNames, family) < 0) continue;
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(family);
            item.setSelected(family.equals(currentFamily));
            item.addActionListener(this::fontFamilyChanged);
            this.mediathekGui.fontMenu.add(item);
            familiesGroup.add(item);
        }
        this.mediathekGui.fontMenu.addSeparator();
        ArrayList<String> sizes = new ArrayList<String>(Arrays.asList("10", "11", "12", "14", "16", "18", "20", "24", "28"));
        if (!sizes.contains(currentSize)) {
            sizes.add(currentSize);
        }
        sizes.sort(String.CASE_INSENSITIVE_ORDER);
        ButtonGroup sizesGroup = new ButtonGroup();
        for (String size : sizes) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(size);
            item.setSelected(size.equals(currentSize));
            item.addActionListener(this::fontSizeChanged);
            this.mediathekGui.fontMenu.add(item);
            sizesGroup.add(item);
        }
        boolean enabled = UIManager.getLookAndFeel() instanceof FlatLaf;
        for (Component item : this.mediathekGui.fontMenu.getMenuComponents()) {
            item.setEnabled(enabled);
        }
    }

    private void fontFamilyChanged(ActionEvent e) {
        String fontFamily = e.getActionCommand();
        FlatAnimatedLafChange.showSnapshot();
        Font font = UIManager.getFont("defaultFont");
        Font newFont = StyleContext.getDefaultStyleContext().getFont(fontFamily, font.getStyle(), font.getSize());
        newFont = FlatUIUtils.nonUIResource(newFont);
        UIManager.put("defaultFont", newFont);
        FlatLaf.updateUI();
        FlatAnimatedLafChange.hideSnapshotWithAnimation();
    }

    private void fontSizeChanged(ActionEvent e) {
        String fontSizeStr = e.getActionCommand();
        Font font = UIManager.getFont("defaultFont");
        Font newFont = font.deriveFont((float)Integer.parseInt(fontSizeStr));
        UIManager.put("defaultFont", newFont);
        FlatLaf.updateUI();
    }
}

