/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.util.logging.ErrorManager;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;

public abstract class ExtErrorManager
extends ErrorManager {
    protected String nameForCode(int code) {
        switch (code) {
            case 3: {
                return "CLOSE_FAILURE";
            }
            case 2: {
                return "FLUSH_FAILURE";
            }
            case 5: {
                return "FORMAT_FAILURE";
            }
            case 0: {
                return "GENERIC_FAILURE";
            }
            case 4: {
                return "OPEN_FAILURE";
            }
            case 1: {
                return "WRITE_FAILURE";
            }
        }
        return "INVALID (" + code + ")";
    }

    @Override
    public void error(String msg, Exception ex, int code) {
        super.error(msg, ex, code);
    }

    protected ExtLogRecord errorToLogRecord(String msg, Exception ex, int code) {
        ExtLogRecord record = new ExtLogRecord(Level.ERROR, "Failed to publish log record (%s[%d]): %s", ExtLogRecord.FormatStyle.PRINTF, this.getClass().getName());
        String codeStr = this.nameForCode(code);
        record.setParameters(new Object[]{codeStr, code, msg});
        record.setThrown(ex);
        record.setLoggerName("");
        return record;
    }
}

