/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.metrics;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;

public interface MetricsFactory {
    public static final String MP_METRICS = "smallrye-metrics";
    public static final String MICROMETER = "micrometer";

    public boolean metricsSystemSupported(String var1);

    default public MetricBuilder builder(String name) {
        return this.builder(name, Type.VENDOR);
    }

    public MetricBuilder builder(String var1, Type var2);

    public static enum Type {
        APPLICATION,
        BASE,
        VENDOR;

    }

    public static interface MetricBuilder {
        public MetricBuilder description(String var1);

        public MetricBuilder tag(String var1, String var2);

        public MetricBuilder unit(String var1);

        public void buildCounter(Supplier<Number> var1);

        public <T, R extends Number> void buildCounter(T var1, Function<T, R> var2);

        public void buildGauge(Supplier<Number> var1);

        public <T, R extends Number> void buildGauge(T var1, Function<T, R> var2);

        public TimeRecorder buildTimer();

        public Runnable buildTimer(Runnable var1);

        public <T> Callable<T> buildTimer(Callable<T> var1);

        public <T> Supplier<T> buildTimer(Supplier<T> var1);
    }

    public static interface TimeRecorder {
        public void update(long var1, TimeUnit var3);

        default public void update(Duration duration) {
            this.update(duration.toNanos(), TimeUnit.NANOSECONDS);
        }
    }
}

