/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.rendering.spi;

import java.util.Locale;
import org.hibernate.models.rendering.spi.RenderingTarget;

public abstract class AbstractRenderingTarget
implements RenderingTarget {
    public static final int DEFAULT_INDENT_DEPTH = 2;
    private final int indentationDepth;
    private int currentIndentation = 0;

    public AbstractRenderingTarget() {
        this(2);
    }

    public AbstractRenderingTarget(int indentationDepth) {
        this.indentationDepth = indentationDepth;
    }

    protected abstract void write(String var1);

    @Override
    public void addLine(String line) {
        this.write(" ".repeat(this.currentIndentation));
        this.write(line);
        this.write("\n");
    }

    @Override
    public void addLine(String pattern, Object ... args) {
        this.write(" ".repeat(this.currentIndentation));
        this.write(String.format(Locale.ROOT, pattern, args));
        this.write("\n");
    }

    @Override
    public void addLine() {
        this.write("\n");
    }

    @Override
    public void indent(int depth) {
        this.currentIndentation += depth * this.indentationDepth;
    }

    @Override
    public void unindent(int depth) {
        this.currentIndentation -= depth * this.indentationDepth;
        assert (this.currentIndentation >= 0);
    }
}

