#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-4o2LwDSQO5RAgZTlVU1G1G
key:                  trifecta-2.1.4-4o2LwDSQO5RAgZTlVU1G1G
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  f2f3108d781b19cfcfd35db016bdb3b1
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-4o2LwDSQO5RAgZTlVU1G1G
depends:
    ansi-terminal-1.0.2-2gkFCvfn2OGG2Y2ycr9zsg array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4.1-HxVSWkAf6gu1L6Fw7VU2pX
    blaze-html-0.9.2.0-HlrZxLZUUWY3inTlediNEQ
    blaze-markup-0.8.3.0-6AYgqQnfYPABrBcyzVLRLw bytestring-0.11.5.3
    charset-0.3.12-8jpbyLvpzkx4IWIqXfpBS3
    comonad-5.0.9-3aq0u3t6RBJGJyhZgaIHRD containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-LUhqOE57WucLbmmg0B1tPV
    ghc-prim-0.9.1 hashable-1.4.7.0-bh6X3bZPF56LQTYQ27khw
    indexed-traversable-0.1.4-2jca0tWP54e6sSfMY1ZadX
    lens-5.3.3-26VlyqkFVMA2DXZQVmsUyD mtl-2.2.2
    parsers-0.12.12-9Z8RyRYYd1ErrYjYlkxDN
    prettyprinter-1.7.1-CmgwT0JRRi5IrbNzmhPK5a
    prettyprinter-ansi-terminal-1.1.3-BlrsJM3468zE3dcFj0Rj2y
    profunctors-5.6.3-GRsVoSCTlSLLjgRMfekVCV
    reducers-3.12.5-DuE2MsGKRF8HnGhiLd9IU transformers-0.5.6.2
    unordered-containers-0.2.20.1-98Hg6PuNW0XDqLHXL1727Z
    utf8-string-1.0.2-4OrQf1vZkgOAJqnDO7nv41

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

