/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.hub;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.remote.internal.hub.protocol.ChannelIdentifier;
import org.gradle.internal.remote.internal.hub.protocol.ChannelMessage;
import org.gradle.internal.remote.internal.hub.protocol.EndOfStream;
import org.gradle.internal.remote.internal.hub.protocol.InterHubMessage;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ObjectReader;
import org.gradle.internal.serialize.ObjectWriter;
import org.gradle.internal.serialize.StatefulSerializer;

public class InterHubMessageSerializer
implements StatefulSerializer<InterHubMessage> {
    private static final byte CHANNEL_MESSAGE = 1;
    private static final byte END_STREAM_MESSAGE = 2;
    private final StatefulSerializer<Object> payloadSerializer;

    public InterHubMessageSerializer(StatefulSerializer<Object> payloadSerializer) {
        this.payloadSerializer = payloadSerializer;
    }

    public ObjectReader<InterHubMessage> newReader(Decoder decoder) {
        return new MessageReader(decoder, this.payloadSerializer.newReader(decoder));
    }

    public ObjectWriter<InterHubMessage> newWriter(Encoder encoder) {
        return new MessageWriter(encoder, (ObjectWriter<Object>)this.payloadSerializer.newWriter(encoder));
    }

    private static class MessageReader
    implements ObjectReader<InterHubMessage> {
        private final Map<Integer, ChannelIdentifier> channels = new HashMap<Integer, ChannelIdentifier>();
        private final Decoder decoder;
        private final ObjectReader<?> payloadReader;

        public MessageReader(Decoder decoder, ObjectReader<?> payloadReader) {
            this.decoder = decoder;
            this.payloadReader = payloadReader;
        }

        public InterHubMessage read() throws Exception {
            switch (this.decoder.readByte()) {
                case 1: {
                    ChannelIdentifier channelId = this.readChannelId();
                    Object payload = this.payloadReader.read();
                    return new ChannelMessage(channelId, payload);
                }
                case 2: {
                    return new EndOfStream();
                }
            }
            throw new IllegalArgumentException();
        }

        private ChannelIdentifier readChannelId() throws IOException {
            int channelNum = this.decoder.readSmallInt();
            ChannelIdentifier channelId = this.channels.get(channelNum);
            if (channelId == null) {
                String channel = this.decoder.readString();
                channelId = new ChannelIdentifier(channel);
                this.channels.put(channelNum, channelId);
            }
            return channelId;
        }
    }

    private static class MessageWriter
    implements ObjectWriter<InterHubMessage> {
        private final Map<ChannelIdentifier, Integer> channels = new HashMap<ChannelIdentifier, Integer>();
        private final Encoder encoder;
        private final ObjectWriter<Object> payloadWriter;

        public MessageWriter(Encoder encoder, ObjectWriter<Object> payloadWriter) {
            this.encoder = encoder;
            this.payloadWriter = payloadWriter;
        }

        public void write(InterHubMessage message) throws Exception {
            if (message instanceof ChannelMessage) {
                ChannelMessage channelMessage = (ChannelMessage)message;
                this.encoder.writeByte((byte)1);
                this.writeChannelId(channelMessage);
                this.payloadWriter.write(channelMessage.getPayload());
            } else if (message instanceof EndOfStream) {
                this.encoder.writeByte((byte)2);
            } else {
                throw new IllegalArgumentException();
            }
        }

        private void writeChannelId(ChannelMessage channelMessage) throws IOException {
            Integer channelNum = this.channels.get(channelMessage.getChannel());
            if (channelNum == null) {
                channelNum = this.channels.size();
                this.channels.put(channelMessage.getChannel(), channelNum);
                this.encoder.writeSmallInt(channelNum.intValue());
                this.encoder.writeString((CharSequence)channelMessage.getChannel().getName());
            } else {
                this.encoder.writeSmallInt(channelNum.intValue());
            }
        }
    }
}

