/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import java.io.File;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.connection.BuildControllerWithoutParameterSupport;
import org.gradle.tooling.internal.consumer.connection.NestedActionAwareBuildControllerAdapter;
import org.gradle.tooling.internal.consumer.connection.ParameterAwareBuildControllerAdapter;
import org.gradle.tooling.internal.consumer.connection.StreamingAwareBuildControllerAdapter;
import org.gradle.tooling.internal.consumer.converters.ConsumerTargetTypeProvider;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.InternalActionAwareBuildController;
import org.gradle.tooling.internal.protocol.InternalBuildAction;
import org.gradle.tooling.internal.protocol.InternalBuildActionVersion2;
import org.gradle.tooling.internal.protocol.InternalBuildController;
import org.gradle.tooling.internal.protocol.InternalBuildControllerVersion2;
import org.gradle.tooling.internal.protocol.InternalStreamedValueRelay;

public class InternalBuildActionAdapter<T>
implements InternalBuildAction<T>,
InternalBuildActionVersion2<T> {
    private final BuildAction<? extends T> action;
    private final File rootDir;
    private final VersionDetails versionDetails;

    public InternalBuildActionAdapter(BuildAction<? extends T> action, File rootDir, VersionDetails versionDetails) {
        this.action = action;
        this.rootDir = rootDir;
        this.versionDetails = versionDetails;
    }

    @Override
    public T execute(InternalBuildController buildController) {
        ProtocolToModelAdapter protocolToModelAdapter = new ProtocolToModelAdapter(new ConsumerTargetTypeProvider());
        BuildControllerWithoutParameterSupport buildControllerAdapter = new BuildControllerWithoutParameterSupport(buildController, protocolToModelAdapter, new ModelMapping(), this.rootDir, this.versionDetails);
        return this.action.execute(buildControllerAdapter);
    }

    @Override
    public T execute(InternalBuildControllerVersion2 buildController) {
        BuildController buildControllerAdapter = this.wrapBuildController(buildController);
        return this.action.execute(buildControllerAdapter);
    }

    private BuildController wrapBuildController(InternalBuildControllerVersion2 buildController) {
        ProtocolToModelAdapter protocolToModelAdapter = new ProtocolToModelAdapter(new ConsumerTargetTypeProvider());
        if (buildController instanceof InternalStreamedValueRelay) {
            return new StreamingAwareBuildControllerAdapter(buildController, protocolToModelAdapter, new ModelMapping(), this.versionDetails, this.rootDir);
        }
        if (buildController instanceof InternalActionAwareBuildController) {
            return new NestedActionAwareBuildControllerAdapter(buildController, protocolToModelAdapter, new ModelMapping(), this.versionDetails, this.rootDir);
        }
        return new ParameterAwareBuildControllerAdapter(buildController, protocolToModelAdapter, new ModelMapping(), this.versionDetails, this.rootDir);
    }
}

