/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.jspecify.annotations.Nullable;

public class MergeProvider<R>
extends AbstractMinimalProvider<List<R>> {
    private final List<? extends Provider<R>> items;

    public MergeProvider(List<? extends Provider<R>> items) {
        this.items = ImmutableList.copyOf(items);
    }

    @Override
    protected String toStringNoReentrance() {
        return String.format("merge([%s])", Joiner.on((String)", ").join(this.items));
    }

    @Override
    public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
        for (Provider<R> provider : this.items) {
            if (Providers.internal(provider).calculatePresence(consumer)) continue;
            return false;
        }
        return super.calculatePresence(consumer);
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends List<R>> calculateExecutionTimeValue() {
        for (Provider<R> provider : this.items) {
            if (!this.isChangingValue(Providers.internal(provider))) continue;
            return ValueSupplier.ExecutionTimeValue.changingValue(this);
        }
        return super.calculateExecutionTimeValue();
    }

    private boolean isChangingValue(ProviderInternal<?> provider) {
        return provider.calculateExecutionTimeValue().isChangingValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected ValueSupplier.Value<List<R>> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        void var4_7;
        ArrayList<ValueSupplier.Value> values = new ArrayList<ValueSupplier.Value>(this.items.size());
        for (Provider<R> provider : this.items) {
            ValueSupplier.Value value = Providers.internal(provider).calculateValue(consumer);
            if (value.isMissing()) {
                return value.asType();
            }
            values.add(value);
        }
        ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)values.size());
        for (ValueSupplier.Value value : values) {
            result.add(value.getWithoutSideEffect());
        }
        ValueSupplier.Value<ImmutableList> value = ValueSupplier.Value.ofNullable(result.build());
        for (ValueSupplier.Value value2 : values) {
            ValueSupplier.Value value3 = var4_7.withSideEffect(ValueSupplier.SideEffect.fixedFrom(value2));
        }
        return var4_7;
    }

    @Override
    public @Nullable Class<List<R>> getType() {
        return (Class)Cast.uncheckedCast(List.class);
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        ImmutableList.Builder producers = ImmutableList.builderWithExpectedSize((int)this.items.size());
        for (Provider<R> item : this.items) {
            producers.add((Object)Providers.internal(item).getProducer());
        }
        return new MergeValueProducer((List<ValueSupplier.ValueProducer>)producers.build());
    }

    private static class MergeValueProducer
    implements ValueSupplier.ValueProducer {
        private final List<ValueSupplier.ValueProducer> items;

        public MergeValueProducer(List<ValueSupplier.ValueProducer> items) {
            this.items = items;
        }

        @Override
        public boolean isKnown() {
            for (ValueSupplier.ValueProducer item : this.items) {
                if (!item.isKnown()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
            for (ValueSupplier.ValueProducer item : this.items) {
                item.visitProducerTasks(visitor);
            }
        }
    }
}

