/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.utils;

import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.core.network.utils.HostnameUtils;
import org.netbeans.core.network.utils.IpAddressUtils;
import org.netbeans.core.network.utils.IpAddressUtilsFilter;
import org.netbeans.core.network.utils.NativeException;
import org.openide.util.RequestProcessor;

public class LocalAddressUtils {
    private static final Logger LOG = Logger.getLogger(LocalAddressUtils.class.getName());
    private static final RequestProcessor RP = new RequestProcessor("LocalNetworkAddressFinder", 4);
    private static final byte[] LOOPBACK_IPV4_RAW = new byte[]{127, 0, 0, 1};
    private static final byte[] LOOPBACK_IPV6_RAW = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
    private static final byte[] SOMEADDR_IPV4_RAW = new byte[]{8, 8, 8, 8};
    private static final byte[] SOMEADDR_IPV6_RAW = new byte[]{32, 1, 72, 96, 72, 96, 0, 0, 0, 0, 0, 0, 0, 0, -120, -120};
    private static final InetAddress LOOPBACK_IPV4;
    private static final InetAddress LOOPBACK_IPV6;
    private static final InetAddress SOMEADDR_IPV4;
    private static final InetAddress SOMEADDR_IPV6;
    private static final Object LOCK;
    private static Future<InetAddress> fut1;
    private static Future<InetAddress[]> fut2;
    private static Future<List<InetAddress>> fut3;
    private static Future<List<InetAddress>> fut4;
    private static final Callable<InetAddress> C1;
    private static final Callable<InetAddress[]> C2;
    private static final Callable<List<InetAddress>> C3;
    private static final Callable<List<InetAddress>> C4;

    private LocalAddressUtils() {
    }

    public static void warmUp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshNetworkInfo(boolean await) {
        Object object = LOCK;
        synchronized (object) {
            fut1 = RP.submit(C1);
            fut2 = RP.submit(C2);
            fut3 = RP.submit(C3);
            fut4 = RP.submit(C4);
            if (await) {
                try {
                    fut1.get();
                    fut2.get();
                    fut3.get();
                    fut4.get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            }
        }
    }

    @NonNull
    public static InetAddress getLocalHost() throws UnknownHostException {
        Object object = LOCK;
        synchronized (object) {
            if (fut1 == null) {
                LocalAddressUtils.refreshNetworkInfo(false);
            }
            try {
                return fut1.get();
            }
            catch (ExecutionException ex) {
                if (ex.getCause() instanceof UnknownHostException) {
                    throw (UnknownHostException)ex.getCause();
                }
                throw new RuntimeException(ex.getCause());
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @NonNull
    public static InetAddress[] getLocalHostAddresses(IpAddressUtils.IpTypePreference ipTypePref) throws UnknownHostException {
        Object object = LOCK;
        synchronized (object) {
            if (fut2 == null) {
                LocalAddressUtils.refreshNetworkInfo(false);
            }
            try {
                InetAddress[] arr = fut2.get();
                if (arr == null || arr.length == 0) {
                    return new InetAddress[0];
                }
                List<InetAddress> list = Arrays.asList(arr);
                List<InetAddress> filteredList = IpAddressUtilsFilter.filterInetAddresses(list, ipTypePref);
                return filteredList.toArray(new InetAddress[filteredList.size()]);
            }
            catch (ExecutionException ex) {
                if (ex.getCause() instanceof UnknownHostException) {
                    throw (UnknownHostException)ex.getCause();
                }
                if (ex.getCause() instanceof SecurityException) {
                    throw (SecurityException)ex.getCause();
                }
                throw new RuntimeException(ex.getCause());
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @NonNull
    public static List<InetAddress> getPrioritizedLocalHostAddresses(IpAddressUtils.IpTypePreference ipTypePref) {
        Object object = LOCK;
        synchronized (object) {
            if (fut3 == null) {
                LocalAddressUtils.refreshNetworkInfo(false);
            }
            try {
                return IpAddressUtilsFilter.filterInetAddresses((Iterable<InetAddress>)fut3.get(), ipTypePref);
            }
            catch (ExecutionException ex) {
                throw new RuntimeException(ex.getCause());
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @NonNull
    public static List<InetAddress> getDatagramLocalInetAddress(IpAddressUtils.IpTypePreference ipTypePref) {
        Object object = LOCK;
        synchronized (object) {
            if (fut4 == null) {
                LocalAddressUtils.refreshNetworkInfo(false);
            }
            try {
                return IpAddressUtilsFilter.filterInetAddresses((Iterable<InetAddress>)fut4.get(), ipTypePref);
            }
            catch (ExecutionException ex) {
                throw new RuntimeException(ex.getCause());
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @NonNull
    public static InetAddress[] getMostLikelyLocalInetAddresses(IpAddressUtils.IpTypePreference ipTypePref) {
        List<InetAddress> filteredList = LocalAddressUtils.getPrioritizedLocalHostAddresses(ipTypePref);
        IpAddressUtils.removeLoopback(filteredList);
        try {
            ArrayList<InetAddress> localHostAddresses = new ArrayList<InetAddress>(Arrays.asList(LocalAddressUtils.getLocalHostAddresses(ipTypePref)));
            IpAddressUtils.removeLoopback(localHostAddresses);
            if (!localHostAddresses.isEmpty()) {
                ArrayList<InetAddress> tmpList = new ArrayList<InetAddress>(5);
                for (InetAddress addr : filteredList) {
                    if (!localHostAddresses.contains(addr)) continue;
                    tmpList.add(addr);
                }
                if (!tmpList.isEmpty()) {
                    return tmpList.toArray(new InetAddress[tmpList.size()]);
                }
                if (!localHostAddresses.isEmpty()) {
                    return localHostAddresses.toArray(new InetAddress[localHostAddresses.size()]);
                }
            }
        }
        catch (UnknownHostException localHostAddresses) {
            // empty catch block
        }
        if (!filteredList.isEmpty()) {
            return filteredList.toArray(new InetAddress[filteredList.size()]);
        }
        try {
            InetAddress addr = IpAddressUtilsFilter.pickInetAddress(Collections.singletonList(LocalAddressUtils.getLocalHost()), ipTypePref);
            if (addr != null && !addr.isAnyLocalAddress() && !addr.isLoopbackAddress()) {
                return new InetAddress[]{addr};
            }
        }
        catch (UnknownHostException addr) {
            // empty catch block
        }
        List<InetAddress> datagramLocalInetAddress = LocalAddressUtils.getDatagramLocalInetAddress(ipTypePref);
        if (datagramLocalInetAddress != null && !datagramLocalInetAddress.isEmpty()) {
            return datagramLocalInetAddress.toArray(new InetAddress[datagramLocalInetAddress.size()]);
        }
        return new InetAddress[]{LocalAddressUtils.getLoopbackAddress(ipTypePref)};
    }

    @NonNull
    public static InetAddress getMostLikelyLocalInetAddress(IpAddressUtils.IpTypePreference ipTypePref) {
        InetAddress[] ipAddresses = LocalAddressUtils.getMostLikelyLocalInetAddresses(ipTypePref);
        return ipAddresses[0];
    }

    @NonNull
    public static InetAddress getLoopbackAddress(IpAddressUtils.IpTypePreference ipTypePref) {
        switch (ipTypePref) {
            case IPV4_ONLY: 
            case ANY_IPV4_PREF: {
                return LOOPBACK_IPV4;
            }
            case IPV6_ONLY: 
            case ANY_IPV6_PREF: {
                return LOOPBACK_IPV6;
            }
        }
        return LOOPBACK_IPV4;
    }

    @NonNull
    private static List<InetAddress> getLocalNetworkInterfaceAddr() {
        Enumeration<NetworkInterface> interfaces;
        final HashMap<InetAddress, Integer> mapWithScores = new HashMap<InetAddress, Integer>();
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            LOG.log(Level.WARNING, "Cannot get host's network interfaces", ex);
            return Collections.emptyList();
        }
        while (interfaces.hasMoreElements()) {
            NetworkInterface netIf;
            int ifScore;
            block10: {
                ifScore = 0;
                netIf = interfaces.nextElement();
                try {
                    if (!netIf.isUp() || netIf.isLoopback()) continue;
                    if (netIf.isVirtual()) {
                        --ifScore;
                    }
                    if (!netIf.supportsMulticast()) {
                        --ifScore;
                    }
                    if (!LocalAddressUtils.isSoftwareVirtualAdapter(netIf)) break block10;
                    --ifScore;
                }
                catch (SocketException ex) {
                    continue;
                }
            }
            List<InterfaceAddress> interfaceAddresses = netIf.getInterfaceAddresses();
            for (InterfaceAddress ifAddr : interfaceAddresses) {
                int addrScore = 0;
                InetAddress address = ifAddr.getAddress();
                if (ifAddr.getBroadcast() == null) {
                    --addrScore;
                }
                if (address instanceof Inet6Address) {
                    --addrScore;
                }
                mapWithScores.put(address, ifScore + addrScore);
            }
        }
        ArrayList<InetAddress> list = new ArrayList<InetAddress>(mapWithScores.keySet());
        Collections.sort(list, new Comparator<InetAddress>(){

            @Override
            public int compare(InetAddress o1, InetAddress o2) {
                return ((Integer)mapWithScores.get(o2)).compareTo((Integer)mapWithScores.get(o1));
            }
        });
        return list;
    }

    public static boolean isSoftwareVirtualAdapter(NetworkInterface nif) {
        try {
            byte[] macAddress = nif.getHardwareAddress();
            return macAddress != null && macAddress.length >= 3 && (macAddress[0] == 10 || macAddress[0] == 8) && macAddress[1] == 0 && macAddress[2] == 39;
        }
        catch (SocketException ex) {
            return false;
        }
    }

    static {
        try {
            LOOPBACK_IPV4 = InetAddress.getByAddress("local-ipv4-dummy", LOOPBACK_IPV4_RAW);
            LOOPBACK_IPV6 = InetAddress.getByAddress("local-ipv6-dummy", LOOPBACK_IPV6_RAW);
            SOMEADDR_IPV4 = InetAddress.getByAddress("some-ipv4-dummy", SOMEADDR_IPV4_RAW);
            SOMEADDR_IPV6 = InetAddress.getByAddress("some-ipv6-dummy", SOMEADDR_IPV6_RAW);
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException(ex);
        }
        LOCK = new Object();
        C1 = () -> InetAddress.getLocalHost();
        C2 = () -> {
            try {
                String hostname = HostnameUtils.getNetworkHostname();
                return InetAddress.getAllByName(hostname);
            }
            catch (NativeException ex) {
                throw new UnknownHostException(ex.getMessage() + ", error code : " + ex.getErrorCode());
            }
        };
        C3 = () -> LocalAddressUtils.getLocalNetworkInterfaceAddr();
        C4 = () -> {
            InetAddress addr;
            DatagramSocket socket2;
            ArrayList<InetAddress> list = new ArrayList<InetAddress>(2);
            try {
                socket2 = new DatagramSocket();
                try {
                    socket2.connect(SOMEADDR_IPV4, 10002);
                    addr = socket2.getLocalAddress();
                    if (addr != null && addr instanceof Inet4Address && !addr.isAnyLocalAddress() && !addr.isLoopbackAddress()) {
                        list.add(addr);
                    }
                }
                finally {
                    socket2.close();
                }
            }
            catch (SecurityException | SocketException socket2) {
                // empty catch block
            }
            try {
                socket2 = new DatagramSocket();
                try {
                    socket2.connect(SOMEADDR_IPV6, 10002);
                    addr = socket2.getLocalAddress();
                    if (addr != null && addr instanceof Inet6Address && !addr.isAnyLocalAddress() && !addr.isLoopbackAddress()) {
                        list.add(addr);
                    }
                }
                finally {
                    socket2.close();
                }
            }
            catch (SecurityException | SocketException exception) {
                // empty catch block
            }
            return list;
        };
        LocalAddressUtils.refreshNetworkInfo(false);
    }
}

