/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.forceAtlas;

import java.util.ArrayList;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.spi.LayoutData;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.plugin.ForceVectorNodeLayoutData;
import org.gephi.layout.plugin.ForceVectorUtils;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ForceAtlasLayout
extends AbstractLayout
implements Layout {
    public double inertia;
    protected Graph graph;
    private double repulsionStrength;
    private double attractionStrength;
    private double maxDisplacement;
    private boolean freezeBalance;
    private double freezeStrength;
    private double freezeInertia;
    private double gravity;
    private double speed;
    private double cooling;
    private boolean outboundAttractionDistribution;
    private boolean adjustSizes;

    public ForceAtlasLayout(LayoutBuilder layoutBuilder) {
        super(layoutBuilder);
    }

    public void resetPropertiesValues() {
        this.inertia = 0.1;
        this.setRepulsionStrength(200.0);
        this.setAttractionStrength(10.0);
        this.setMaxDisplacement(10.0);
        this.setFreezeBalance(true);
        this.setFreezeStrength(80.0);
        this.setFreezeInertia(0.2);
        this.setGravity(30.0);
        this.setOutboundAttractionDistribution(false);
        this.setAdjustSizes(false);
        this.setSpeed(1.0);
        this.setCooling(1.0);
    }

    public void initAlgo() {
        ForceAtlasLayout.ensureSafeLayoutNodePositions(this.graphModel);
    }

    private double getEdgeWeight(Edge edge, boolean isDynamicWeight, Interval interval) {
        if (isDynamicWeight) {
            return edge.getWeight(interval);
        }
        return edge.getWeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goAlgo() {
        this.graph = this.graphModel.getGraphVisible();
        this.graph.readLock();
        boolean isDynamicWeight = this.graphModel.getEdgeTable().getColumn("weight").isDynamic();
        Interval interval = this.graph.getView().getTimeInterval();
        try {
            Node nf;
            Node[] nodes = this.graph.getNodes().toArray();
            Edge[] edges = this.graph.getEdges().toArray();
            for (Node node : nodes) {
                if (node.getLayoutData() != null && node.getLayoutData() instanceof ForceVectorNodeLayoutData) continue;
                node.setLayoutData((LayoutData)new ForceVectorNodeLayoutData());
            }
            for (Node node : nodes) {
                Node[] layoutData = (Node[])node.getLayoutData();
                layoutData.old_dx = layoutData.dx;
                layoutData.old_dy = layoutData.dy;
                layoutData.dx = (float)((double)layoutData.dx * this.inertia);
                layoutData.dy = (float)((double)layoutData.dy * this.inertia);
            }
            if (this.isAdjustSizes().booleanValue()) {
                for (Node node : nodes) {
                    for (Node n2 : nodes) {
                        if (node == n2) continue;
                        ForceVectorUtils.fcBiRepulsor_noCollide(node, n2, this.getRepulsionStrength() * (double)(1 + this.graph.getDegree(node)) * (double)(1 + this.graph.getDegree(n2)));
                    }
                }
            } else {
                for (Node node : nodes) {
                    for (Node n2 : nodes) {
                        if (node == n2) continue;
                        ForceVectorUtils.fcBiRepulsor(node, n2, this.getRepulsionStrength() * (double)(1 + this.graph.getDegree(node)) * (double)(1 + this.graph.getDegree(n2)));
                    }
                }
            }
            if (this.isAdjustSizes().booleanValue()) {
                if (this.isOutboundAttractionDistribution().booleanValue()) {
                    for (Node node : edges) {
                        nf = node.getSource();
                        Node nt = node.getTarget();
                        double bonus = nf.isFixed() || nt.isFixed() ? 100.0 : 1.0;
                        ForceVectorUtils.fcBiAttractor_noCollide(nf, nt, (bonus *= this.getEdgeWeight((Edge)node, isDynamicWeight, interval)) * this.getAttractionStrength() / (double)(1 + this.graph.getDegree(nf)));
                    }
                } else {
                    for (Node node : edges) {
                        nf = node.getSource();
                        Node nt = node.getTarget();
                        double bonus = nf.isFixed() || nt.isFixed() ? 100.0 : 1.0;
                        ForceVectorUtils.fcBiAttractor_noCollide(nf, nt, (bonus *= this.getEdgeWeight((Edge)node, isDynamicWeight, interval)) * this.getAttractionStrength());
                    }
                }
            } else if (this.isOutboundAttractionDistribution().booleanValue()) {
                for (Node node : edges) {
                    nf = node.getSource();
                    Node nt = node.getTarget();
                    double bonus = nf.isFixed() || nt.isFixed() ? 100.0 : 1.0;
                    ForceVectorUtils.fcBiAttractor(nf, nt, (bonus *= this.getEdgeWeight((Edge)node, isDynamicWeight, interval)) * this.getAttractionStrength() / (double)(1 + this.graph.getDegree(nf)));
                }
            } else {
                for (Node node : edges) {
                    nf = node.getSource();
                    Node nt = node.getTarget();
                    double bonus = nf.isFixed() || nt.isFixed() ? 100.0 : 1.0;
                    ForceVectorUtils.fcBiAttractor(nf, nt, (bonus *= this.getEdgeWeight((Edge)node, isDynamicWeight, interval)) * this.getAttractionStrength());
                }
            }
            for (Node node : nodes) {
                float nx = node.x();
                float ny = node.y();
                double d = 1.0E-4 + Math.sqrt(nx * nx + ny * ny);
                double gf = 1.0E-4 * this.getGravity() * d;
                ForceVectorNodeLayoutData layoutData = (ForceVectorNodeLayoutData)node.getLayoutData();
                layoutData.dx = (float)((double)layoutData.dx - gf * (double)nx / d);
                layoutData.dy = (float)((double)layoutData.dy - gf * (double)ny / d);
            }
            if (this.isFreezeBalance().booleanValue()) {
                for (Node node : nodes) {
                    ForceVectorNodeLayoutData layoutData = (ForceVectorNodeLayoutData)node.getLayoutData();
                    layoutData.dx = (float)((double)layoutData.dx * (this.getSpeed() * 10.0));
                    layoutData.dy = (float)((double)layoutData.dy * (this.getSpeed() * 10.0));
                }
            } else {
                for (Node node : nodes) {
                    ForceVectorNodeLayoutData layoutData = (ForceVectorNodeLayoutData)node.getLayoutData();
                    layoutData.dx = (float)((double)layoutData.dx * this.getSpeed());
                    layoutData.dy = (float)((double)layoutData.dy * this.getSpeed());
                }
            }
            for (Node node : nodes) {
                float ratio;
                ForceVectorNodeLayoutData nLayout = (ForceVectorNodeLayoutData)node.getLayoutData();
                if (node.isFixed()) continue;
                double d = 1.0E-4 + Math.sqrt(nLayout.dx * nLayout.dx + nLayout.dy * nLayout.dy);
                if (this.isFreezeBalance().booleanValue()) {
                    nLayout.freeze = (float)(this.getFreezeInertia() * (double)nLayout.freeze + (1.0 - this.getFreezeInertia()) * 0.1 * this.getFreezeStrength() * Math.sqrt(Math.sqrt((nLayout.old_dx - nLayout.dx) * (nLayout.old_dx - nLayout.dx) + (nLayout.old_dy - nLayout.dy) * (nLayout.old_dy - nLayout.dy))));
                    ratio = (float)Math.min(d / (d * (double)(1.0f + nLayout.freeze)), this.getMaxDisplacement() / d);
                } else {
                    ratio = (float)Math.min(1.0, this.getMaxDisplacement() / d);
                }
                nLayout.dx = (float)((double)nLayout.dx * ((double)ratio / this.getCooling()));
                nLayout.dy = (float)((double)nLayout.dy * ((double)ratio / this.getCooling()));
                float x = node.x() + nLayout.dx;
                float y = node.y() + nLayout.dy;
                node.setX(x);
                node.setY(y);
            }
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    public void endAlgo() {
        this.graph.readLock();
        try {
            for (Node n : this.graph.getNodes()) {
                n.setLayoutData(null);
            }
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    @Override
    public boolean canAlgo() {
        return true;
    }

    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        String FORCE_ATLAS = "Force Atlas";
        try {
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.inertia.name"), (String)"Force Atlas", (String)"forceAtlas.inertia.name", (String)NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.inertia.desc"), (String)"getInertia", (String)"setInertia"));
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.repulsionStrength.name"), (String)"Force Atlas", (String)"forceAtlas.repulsionStrength.name", (String)NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.repulsionStrength.desc"), (String)"getRepulsionStrength", (String)"setRepulsionStrength"));
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.attractionStrength.name"), (String)"Force Atlas", (String)"forceAtlas.attractionStrength.name", (String)NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.attractionStrength.desc"), (String)"getAttractionStrength", (String)"setAttractionStrength"));
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.maxDisplacement.name"), (String)"Force Atlas", (String)"forceAtlas.maxDisplacement.name", (String)NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.maxDisplacement.desc"), (String)"getMaxDisplacement", (String)"setMaxDisplacement"));
            properties.add(LayoutProperty.createProperty((Layout)this, Boolean.class, (String)NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.freezeBalance.name"), (String)"Force Atlas", (String)"forceAtlas.freezeBalance.name", (String)NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.freezeBalance.desc"), (String)"isFreezeBalance", (String)"setFreezeBalance"));
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.freezeStrength.name"), (String)"Force Atlas", (String)"forceAtlas.freezeStrength.name", (String)NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.freezeStrength.desc"), (String)"getFreezeStrength", (String)"setFreezeStrength"));
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.freezeInertia.name"), (String)"Force Atlas", (String)"forceAtlas.freezeInertia.name", (String)NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.freezeInertia.desc"), (String)"getFreezeInertia", (String)"setFreezeInertia"));
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.gravity.name"), (String)"Force Atlas", (String)"forceAtlas.gravity.name", (String)NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.gravity.desc"), (String)"getGravity", (String)"setGravity"));
            properties.add(LayoutProperty.createProperty((Layout)this, Boolean.class, (String)NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.outboundAttractionDistribution.name"), (String)"Force Atlas", (String)"forceAtlas.outboundAttractionDistribution.name", (String)NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.outboundAttractionDistribution.desc"), (String)"isOutboundAttractionDistribution", (String)"setOutboundAttractionDistribution"));
            properties.add(LayoutProperty.createProperty((Layout)this, Boolean.class, (String)NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.adjustSizes.name"), (String)"Force Atlas", (String)"forceAtlas.adjustSizes.name", (String)NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.adjustSizes.desc"), (String)"isAdjustSizes", (String)"setAdjustSizes"));
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.speed.name"), (String)"Force Atlas", (String)"forceAtlas.speed.name", (String)NbBundle.getMessage(ForceAtlasLayout.class, (String)"forceAtlas.speed.desc"), (String)"getSpeed", (String)"setSpeed"));
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    public Double getInertia() {
        return this.inertia;
    }

    public void setInertia(Double inertia) {
        this.inertia = inertia;
    }

    public Double getRepulsionStrength() {
        return this.repulsionStrength;
    }

    public void setRepulsionStrength(Double repulsionStrength) {
        this.repulsionStrength = repulsionStrength;
    }

    public Double getAttractionStrength() {
        return this.attractionStrength;
    }

    public void setAttractionStrength(Double attractionStrength) {
        this.attractionStrength = attractionStrength;
    }

    public Double getMaxDisplacement() {
        return this.maxDisplacement;
    }

    public void setMaxDisplacement(Double maxDisplacement) {
        this.maxDisplacement = maxDisplacement;
    }

    public Boolean isFreezeBalance() {
        return this.freezeBalance;
    }

    public void setFreezeBalance(Boolean freezeBalance) {
        this.freezeBalance = freezeBalance;
    }

    public Double getFreezeStrength() {
        return this.freezeStrength;
    }

    public void setFreezeStrength(Double freezeStrength) {
        this.freezeStrength = freezeStrength;
    }

    public Double getFreezeInertia() {
        return this.freezeInertia;
    }

    public void setFreezeInertia(Double freezeInertia) {
        this.freezeInertia = freezeInertia;
    }

    public Double getGravity() {
        return this.gravity;
    }

    public void setGravity(Double gravity) {
        this.gravity = gravity;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public void setSpeed(Double speed) {
        this.speed = speed;
    }

    public Double getCooling() {
        return this.cooling;
    }

    public void setCooling(Double cooling) {
        this.cooling = cooling;
    }

    public Boolean isOutboundAttractionDistribution() {
        return this.outboundAttractionDistribution;
    }

    public void setOutboundAttractionDistribution(Boolean outboundAttractionDistribution) {
        this.outboundAttractionDistribution = outboundAttractionDistribution;
    }

    public Boolean isAdjustSizes() {
        return this.adjustSizes;
    }

    public void setAdjustSizes(Boolean adjustSizes) {
        this.adjustSizes = adjustSizes;
    }
}

