/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.infonode.docking.DockingWindowListener;
import net.infonode.docking.FloatingWindow;
import net.infonode.docking.FocusManager;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.RootWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.WindowBar;
import net.infonode.docking.WindowDragger;
import net.infonode.docking.WindowPopupMenuFactory;
import net.infonode.docking.WindowTab;
import net.infonode.docking.drag.DockingWindowDragger;
import net.infonode.docking.drop.ChildDropInfo;
import net.infonode.docking.drop.DropFilter;
import net.infonode.docking.drop.SplitDropInfo;
import net.infonode.docking.internal.ReadContext;
import net.infonode.docking.internal.WindowAncestors;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.internalutil.DropAction;
import net.infonode.docking.location.LocationDecoder;
import net.infonode.docking.model.SplitWindowItem;
import net.infonode.docking.model.TabWindowItem;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.model.WindowItem;
import net.infonode.docking.properties.DockingWindowProperties;
import net.infonode.docking.title.DockingWindowTitleProvider;
import net.infonode.docking.title.SimpleDockingWindowTitleProvider;
import net.infonode.docking.util.DockingUtil;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.EventUtil;
import net.infonode.gui.mouse.MouseButtonListener;
import net.infonode.gui.panel.BasePanel;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapListener;
import net.infonode.properties.propertymap.PropertyMapManager;
import net.infonode.properties.propertymap.PropertyMapTreeListener;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;
import net.infonode.util.ArrayUtil;
import net.infonode.util.Direction;

public abstract class DockingWindow
extends BasePanel {
    private static int DROP_FLOATING_YOFFSET = 10;
    private DockingWindow windowParent;
    private WindowTab tab;
    private DockingWindow lastFocusedChildWindow;
    private WindowPopupMenuFactory popupMenuFactory;
    private ArrayList mouseButtonListeners;
    private ArrayList listeners;
    private PropertyMapListener propertiesListener = new PropertyMapListener(){

        @Override
        public void propertyValuesChanged(PropertyMap propertyMap, Map changes) {
            DockingWindow.this.doUpdate();
            DockingWindow.this.updateButtonVisibility();
        }
    };
    private PropertyMapTreeListener propertyObjectTreeListener = new PropertyMapTreeListener(){

        @Override
        public void propertyValuesChanged(Map changes) {
            DockingWindow.this.doUpdate();
        }
    };
    private static HashSet optimizeWindows = new HashSet();
    private static int optimizeDepth;
    private WindowItem windowItem;
    private WeakReference lastRootWindow = new WeakReference<Object>(null);
    private static int updateModelDepth;

    public abstract Icon getIcon();

    public abstract DockingWindow getChildWindow(int var1);

    public abstract int getChildWindowCount();

    protected abstract void doReplace(DockingWindow var1, DockingWindow var2);

    protected abstract void doRemoveWindow(DockingWindow var1);

    protected abstract void update();

    abstract void removeWindowComponent(DockingWindow var1);

    abstract void restoreWindowComponent(DockingWindow var1);

    protected DockingWindow(WindowItem windowItem) {
        DockingWindow window = windowItem.getConnectedWindow();
        if (window != null) {
            window.setWindowItem(windowItem.copy());
        }
        this.windowItem = windowItem;
        this.windowItem.setConnectedWindow(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DockingWindow.this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.mousePressed(e);
            }
        });
    }

    protected void init() {
        PropertyMapWeakListenerManager.addWeakListener(this.getWindowProperties().getMap(), this.propertiesListener);
        PropertyMapWeakListenerManager.addWeakTreeListener(this.getPropertyObject(), this.propertyObjectTreeListener);
        this.doUpdate();
        this.updateWindowItem(this.getRootWindow());
    }

    private void doUpdate() {
        this.update();
        if (this.tab != null) {
            this.tab.windowTitleChanged();
        }
        if (this.windowParent != null && this.windowParent.getChildWindowCount() == 1) {
            this.windowParent.doUpdate();
        }
    }

    protected void addWindowItem(DockingWindow w, int index) {
        boolean isRestore = w.getWindowItem().isRestoreWindow();
        this.windowItem.addWindow(w.getWindowItem(), index);
        if (!isRestore) {
            w.updateWindowItems();
        }
    }

    protected void updateWindowItem(DockingWindow w) {
        int index = this.getChildWindowIndex(w);
        int modelIndex = index == 0 ? 0 : this.windowItem.getWindowIndex(this.getChildWindow(index - 1).getWindowItem()) + 1;
        this.windowItem.addWindow(w.getWindowItem(), modelIndex);
    }

    protected final void updateWindowItems() {
        this.windowItem.clearWindows();
        int i = 0;
        while (i < this.getChildWindowCount()) {
            boolean isRestore = this.getChildWindow((int)i).windowItem.isRestoreWindow();
            this.windowItem.addWindow(this.getChildWindow((int)i).windowItem);
            if (!isRestore) {
                this.getChildWindow(i).updateWindowItems();
            }
            ++i;
        }
    }

    public void setPreferredMinimizeDirection(Direction direction) {
        this.windowItem.setLastMinimizedDirection(direction);
    }

    public Direction getPreferredMinimizeDirection() {
        return this.windowItem.getLastMinimizedDirection();
    }

    private ArrayList getMouseButtonListeners() {
        return this.mouseButtonListeners;
    }

    private void setMouseButtonListeners(ArrayList listeners) {
        this.mouseButtonListeners = listeners;
    }

    private ArrayList getListeners() {
        return this.listeners;
    }

    private void setListeners(ArrayList listeners) {
        this.listeners = listeners;
    }

    public boolean isUndocked() {
        return this.windowParent != null && this.windowParent.isUndocked();
    }

    public void addTabMouseButtonListener(MouseButtonListener listenerDocking) {
        if (this.getMouseButtonListeners() == null) {
            this.setMouseButtonListeners(new ArrayList(2));
        }
        this.getMouseButtonListeners().add(listenerDocking);
    }

    public void removeTabMouseButtonListener(MouseButtonListener listenerDocking) {
        if (this.getMouseButtonListeners() != null && this.getMouseButtonListeners().remove(listenerDocking) && this.getMouseButtonListeners().size() == 0) {
            this.setMouseButtonListeners(null);
        }
    }

    void fireTabWindowMouseButtonEvent(MouseEvent event) {
        this.fireTabWindowMouseButtonEvent(this, EventUtil.convert(event, this));
    }

    void fireTabWindowMouseButtonEvent(DockingWindow window, MouseEvent event) {
        if (this.getMouseButtonListeners() != null) {
            MouseButtonListener[] l = this.getMouseButtonListeners().toArray(new MouseButtonListener[this.getMouseButtonListeners().size()]);
            int i = l.length - 1;
            while (i >= 0) {
                l[i].mouseButtonEvent(event);
                --i;
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireTabWindowMouseButtonEvent(window, event);
        }
    }

    public void addListener(DockingWindowListener listener) {
        if (this.getListeners() == null) {
            this.setListeners(new ArrayList(2));
        }
        this.getListeners().add(listener);
    }

    public void removeListener(DockingWindowListener listener) {
        if (this.getListeners() != null) {
            this.getListeners().remove(listener);
            if (this.getListeners().size() == 0) {
                this.setListeners(null);
            }
        }
    }

    public DockingWindow getWindowParent() {
        return this.windowParent;
    }

    public SplitWindow split(final DockingWindow splitWithWindow, final Direction direction, final float dividerLocation) {
        final SplitWindow w = new SplitWindow(direction == Direction.RIGHT || direction == Direction.LEFT);
        DockingWindow.optimizeAfter(splitWithWindow.getWindowParent(), new Runnable(){

            @Override
            public void run() {
                DockingWindow.this.getWindowParent().replaceChildWindow(DockingWindow.this, w);
                w.setWindows(direction == Direction.DOWN || direction == Direction.RIGHT ? DockingWindow.this : splitWithWindow, direction == Direction.UP || direction == Direction.LEFT ? DockingWindow.this : splitWithWindow);
                w.setDividerLocation(dividerLocation);
                w.getWindowParent().optimizeWindowLayout();
            }
        });
        return w;
    }

    public DockingWindowDragger startDrag(RootWindow dropTarget) {
        return new WindowDragger(this, dropTarget);
    }

    public DockingWindowProperties getWindowProperties() {
        return this.getWindowItem().getDockingWindowProperties();
    }

    public RootWindow getRootWindow() {
        return this.windowParent == null ? null : this.windowParent.getRootWindow();
    }

    public void restoreWithAbort() throws OperationAbortedException {
        this.fireWindowRestoring(this);
        this.restore();
    }

    public void restore() {
        if (this.isMaximized()) {
            this.doRestoreFromMaximize();
        } else if (this.isMinimized() || this.getRootWindow() == null) {
            ArrayList views = new ArrayList();
            this.findViews(views);
            ArrayList<DockingWindow[]> ancestors = new ArrayList<DockingWindow[]>();
            int i = 0;
            while (i < views.size()) {
                ancestors.add(((DockingWindow)views.get(i)).getAncestors());
                ++i;
            }
            this.restoreViews(views);
            i = 0;
            while (i < views.size()) {
                DockingWindow window = (DockingWindow)views.get(i);
                window.doFireWindowRestored(window);
                DockingWindow[] a = (DockingWindow[])ancestors.get(i);
                int k = 0;
                while (k < a.length) {
                    a[k].doFireWindowRestored(window);
                    ++k;
                }
                ++i;
            }
            this.restoreFocus();
        }
        this.updateButtonVisibility();
    }

    private DockingWindow doRestoreFromMaximize() {
        DockingWindow restoredInWindow = null;
        if (this.isUndocked()) {
            FloatingWindow w = DockingUtil.getFloatingWindowFor(this);
            if (w != null) {
                w.setMaximizedWindow(null);
                restoredInWindow = w;
            }
        } else {
            RootWindow w = this.getRootWindow();
            if (w != null) {
                w.setMaximizedWindow(null);
                restoredInWindow = w;
            }
        }
        return restoredInWindow;
    }

    private ArrayList doRestore() {
        ArrayList views = new ArrayList();
        this.findViews(views);
        this.restoreViews(views);
        return views;
    }

    public void close() {
        if (this.windowParent != null) {
            DockingWindow[] ancestors = this.getAncestors();
            DockingWindow.optimizeAfter(this.windowParent, new Runnable(){

                @Override
                public void run() {
                    DockingWindow.this.windowParent.removeChildWindow(DockingWindow.this);
                }
            });
            int i = ancestors.length - 1;
            while (i >= 0) {
                ancestors[i].fireWindowClosed(this);
                --i;
            }
        }
    }

    public void closeWithAbort() throws OperationAbortedException {
        this.fireWindowClosing(this);
        this.close();
    }

    public FloatingWindow undock(Point location) {
        FloatingWindow fw = this.getRootWindow().createFloatingWindow(this, location);
        return fw;
    }

    public FloatingWindow undockWithAbort(Point location) throws OperationAbortedException {
        this.fireWindowUndocking(this);
        return this.undock(location);
    }

    public void dock() {
        if (this.isUndocked()) {
            ArrayList dockedViews = this.doRestore();
            this.updateButtonVisibility();
            this.fireWindowDocked(dockedViews);
            if (dockedViews.size() > 0 && ((DockingWindow)dockedViews.get(0)).getRootWindow() != null) {
                FocusManager.focusWindow((DockingWindow)dockedViews.get(0));
            }
        }
    }

    public void dockWithAbort() throws OperationAbortedException {
        if (this.isUndocked()) {
            this.fireWindowDocking(this);
            this.dock();
        }
    }

    public int getChildWindowIndex(DockingWindow window) {
        int i = 0;
        while (i < this.getChildWindowCount()) {
            if (this.getChildWindow(i) == window) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public WindowPopupMenuFactory getPopupMenuFactory() {
        return this.popupMenuFactory;
    }

    public void setPopupMenuFactory(WindowPopupMenuFactory popupMenuFactory) {
        this.popupMenuFactory = popupMenuFactory;
    }

    public boolean isMinimized() {
        return this.windowParent != null && this.windowParent.isMinimized();
    }

    public DockingWindow getLastFocusedChildWindow() {
        return this.lastFocusedChildWindow;
    }

    public final void maximize() {
        if (this.isUndocked()) {
            FloatingWindow w = DockingUtil.getFloatingWindowFor(this);
            if (w != null) {
                w.setMaximizedWindow(this);
            }
        } else {
            RootWindow rootWindow = this.getRootWindow();
            if (rootWindow != null) {
                rootWindow.setMaximizedWindow(this);
            }
        }
        this.updateButtonVisibility();
    }

    public void maximizeWithAbort() throws OperationAbortedException {
        if (!this.isMaximized()) {
            this.fireWindowMaximizing(this);
            this.maximize();
        }
    }

    public boolean isMaximized() {
        DockingWindow w;
        if (this.isUndocked()) {
            FloatingWindow floatingWindow = DockingUtil.getFloatingWindowFor(this);
            w = floatingWindow != null ? floatingWindow.getMaximizedWindow() : null;
        } else {
            RootWindow rootWindow = this.getRootWindow();
            DockingWindow dockingWindow = w = rootWindow != null ? rootWindow.getMaximizedWindow() : null;
        }
        return w == this;
    }

    public void minimize() {
        this.getOptimizedWindow().doMinimize();
    }

    public void minimize(Direction direction) {
        this.doMinimize(direction);
    }

    public void minimizeWithAbort() throws OperationAbortedException {
        if (!this.isMinimized() && this.getRootWindow().getClosestWindowBar(this) != null) {
            this.fireWindowMinimizing(this);
            this.minimize();
        }
    }

    public void minimizeWithAbort(Direction direction) throws OperationAbortedException {
        if (!this.isMinimized() && this.getRootWindow().getWindowBar(direction) != null) {
            this.fireWindowMinimizing(this);
            this.minimize(direction);
        }
    }

    private void doMinimize() {
        this.doMinimize(this.windowItem.getLastMinimizedDirection() != null && this.getRootWindow().getWindowBar(this.windowItem.getLastMinimizedDirection()).isEnabled() ? this.windowItem.getLastMinimizedDirection() : this.getRootWindow().getClosestWindowBar(this));
    }

    private void doMinimize(Direction direction) {
        DockingWindow w = this.getOptimizedWindow();
        if (direction == null || w.isMinimized()) {
            return;
        }
        WindowBar bar = this.getRootWindow().getWindowBar(direction);
        if (bar != null) {
            bar.addTab(w);
            this.updateButtonVisibility();
        }
    }

    public boolean isMinimizable() {
        return this.getOptimizedWindow().getWindowProperties().getMinimizeEnabled() && !this.isUndocked() && this.getRootWindow() != null && this.getRootWindow().windowBarEnabled();
    }

    public boolean isMaximizable() {
        return !this.isMinimized() && this.getOptimizedWindow().getWindowProperties().getMaximizeEnabled();
    }

    public boolean isClosable() {
        return this.getOptimizedWindow().getWindowProperties().getCloseEnabled();
    }

    public boolean isRestorable() {
        return this.getOptimizedWindow().getWindowProperties().getRestoreEnabled();
    }

    public boolean isUndockable() {
        return this.getOptimizedWindow().getWindowProperties().getUndockEnabled();
    }

    public boolean isDockable() {
        return this.getOptimizedWindow().getWindowProperties().getDockEnabled();
    }

    public void replaceChildWindow(DockingWindow oldWindow, DockingWindow newWindow) {
        if (oldWindow == newWindow) {
            return;
        }
        DockingWindow nw = this.internalReplaceChildWindow(oldWindow, newWindow);
        if (this.getUpdateModel()) {
            boolean isRestore = nw.getWindowItem().isRestoreWindow();
            oldWindow.windowItem.replaceWith(nw.getWindowItem());
            if (!isRestore) {
                nw.updateWindowItems();
            }
            this.cleanUpModel();
        }
    }

    protected DockingWindow internalReplaceChildWindow(final DockingWindow oldWindow, final DockingWindow newWindow) {
        final WindowAncestors oldAncestors = newWindow.storeAncestors();
        final DockingWindow nw = newWindow.getContentWindow(this);
        DockingWindow.optimizeAfter(newWindow, new Runnable(){

            @Override
            public void run() {
                if (nw == oldWindow) {
                    return;
                }
                if (nw.getWindowParent() != null) {
                    nw.getWindowParent().removeChildWindow(nw);
                }
                nw.setWindowParent(DockingWindow.this);
                if (oldWindow.isShowingInRootWindow()) {
                    oldWindow.fireWindowHidden(oldWindow);
                }
                oldWindow.setWindowParent(null);
                if (oldWindow == DockingWindow.this.lastFocusedChildWindow) {
                    DockingWindow.this.lastFocusedChildWindow = null;
                }
                DockingWindow.this.doReplace(oldWindow, nw);
                DockingWindow.this.fireTitleChanged();
                oldWindow.fireWindowRemoved(DockingWindow.this, oldWindow);
                DockingWindow.this.fireWindowRemoved(DockingWindow.this, oldWindow);
                nw.fireWindowAdded(DockingWindow.this, nw);
                if (nw.isShowingInRootWindow()) {
                    nw.fireWindowShown(nw);
                }
                newWindow.notifyListeners(oldAncestors);
            }
        });
        return nw;
    }

    public String getTitle() {
        DockingWindowTitleProvider titleProvider = this.getWindowProperties().getTitleProvider();
        return (titleProvider == null ? SimpleDockingWindowTitleProvider.INSTANCE : titleProvider).getTitle(this);
    }

    @Override
    public String toString() {
        return this.getTitle();
    }

    protected WindowAncestors storeAncestors() {
        return new WindowAncestors(this.getAncestors(), this.isMinimized(), this.isUndocked());
    }

    protected void notifyListeners(WindowAncestors ancestors) {
        if (this.isMinimized() && !ancestors.isMinimized()) {
            this.fireWindowMinimized(this, ancestors.getAncestors());
        }
        if (this.isUndocked() && !ancestors.isUndocked()) {
            this.fireWindowUndocked(this, ancestors.getAncestors());
        }
        if (!this.isUndocked() && ancestors.isUndocked()) {
            this.fireWindowDocked(this, ancestors.getAncestors());
        }
    }

    protected boolean isShowingInRootWindow() {
        return this.windowParent != null && this.windowParent.isChildShowingInRootWindow(this);
    }

    protected boolean isChildShowingInRootWindow(DockingWindow child) {
        return this.isShowingInRootWindow();
    }

    public void makeVisible() {
        this.showChildWindow(null);
    }

    public void restoreFocus() {
        if (this.lastFocusedChildWindow != null) {
            this.lastFocusedChildWindow.restoreFocus();
        } else {
            DockingWindow w = this.getPreferredFocusChild();
            if (w != null) {
                w.restoreFocus();
            } else {
                ComponentUtil.smartRequestFocus(this);
            }
        }
    }

    protected DockingWindow getPreferredFocusChild() {
        return this.getChildWindowCount() > 0 ? this.getChildWindow(0) : null;
    }

    protected DockingWindow getOptimizedWindow() {
        return this;
    }

    protected DockingWindow getBestFittedWindow(DockingWindow parentWindow) {
        return this;
    }

    protected void internalClose() {
        DockingWindow.optimizeAfter(this.windowParent, new Runnable(){

            @Override
            public void run() {
                DockingWindow.this.windowParent.removeChildWindow(DockingWindow.this);
            }
        });
    }

    protected void showChildWindow(DockingWindow window) {
        if (this.windowParent != null && !this.isMaximized()) {
            this.windowParent.showChildWindow(this);
        }
    }

    protected boolean insideTab() {
        return this.windowParent == null ? false : this.windowParent.childInsideTab();
    }

    protected boolean childInsideTab() {
        return this.windowParent == null ? false : this.windowParent.childInsideTab();
    }

    protected DockingWindow[] getAncestors() {
        DockingWindow w = this;
        int count = 0;
        while (w != null) {
            w = w.getWindowParent();
            ++count;
        }
        DockingWindow[] windows = new DockingWindow[count];
        w = this;
        while (w != null) {
            windows[--count] = w;
            w = w.getWindowParent();
        }
        return windows;
    }

    private void fireWindowRemoved(DockingWindow removedFromWindow, DockingWindow removedWindow) {
        if (this.getListeners() != null) {
            DockingWindowListener[] l = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            int i = 0;
            while (i < l.length) {
                l[i].windowRemoved(removedFromWindow, removedWindow);
                ++i;
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowRemoved(removedFromWindow, removedWindow);
        }
    }

    protected void fireWindowShown(DockingWindow window) {
        if (this.getListeners() != null) {
            DockingWindowListener[] l = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            int i = 0;
            while (i < l.length) {
                l[i].windowShown(window);
                ++i;
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowShown(window);
        }
    }

    protected void fireViewFocusChanged(View previouslyFocusedView, View focusedView) {
        if (this.getListeners() != null) {
            DockingWindowListener[] l = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            int i = 0;
            while (i < l.length) {
                l[i].viewFocusChanged(previouslyFocusedView, focusedView);
                ++i;
            }
        }
    }

    protected void fireWindowHidden(DockingWindow window) {
        if (this.getListeners() != null) {
            DockingWindowListener[] l = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            int i = 0;
            while (i < l.length) {
                l[i].windowHidden(window);
                ++i;
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowHidden(window);
        }
    }

    private void fireWindowAdded(DockingWindow addedToWindow, DockingWindow addedWindow) {
        if (this.getListeners() != null) {
            DockingWindowListener[] l = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            int i = 0;
            while (i < l.length) {
                l[i].windowAdded(addedToWindow, addedWindow);
                ++i;
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowAdded(addedToWindow, addedWindow);
        }
    }

    private void fireWindowClosing(DockingWindow window) throws OperationAbortedException {
        if (this.getListeners() != null) {
            DockingWindowListener[] l = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            int i = 0;
            while (i < l.length) {
                l[i].windowClosing(window);
                ++i;
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowClosing(window);
        }
    }

    private void fireWindowClosed(DockingWindow window) {
        if (this.getListeners() != null) {
            DockingWindowListener[] l = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            int i = 0;
            while (i < l.length) {
                l[i].windowClosed(window);
                ++i;
            }
        }
    }

    void fireWindowUndocking(DockingWindow window) throws OperationAbortedException {
        if (this.getListeners() != null) {
            DockingWindowListener[] l = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            int i = 0;
            while (i < l.length) {
                l[i].windowUndocking(window);
                ++i;
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowUndocking(window);
        }
    }

    void fireWindowUndocked(DockingWindow window, DockingWindow[] oldAncestors) {
        this.doFireWindowUndocked(window);
        int i = oldAncestors.length - 1;
        while (i >= 0) {
            oldAncestors[i].doFireWindowUndocked(this);
            --i;
        }
    }

    private void doFireWindowUndocked(DockingWindow window) {
        if (this.getListeners() != null) {
            DockingWindowListener[] l = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            int i = 0;
            while (i < l.length) {
                l[i].windowUndocked(window);
                ++i;
            }
        }
    }

    void fireWindowMinimizing(DockingWindow window) throws OperationAbortedException {
        if (this.getListeners() != null) {
            DockingWindowListener[] l = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            int i = 0;
            while (i < l.length) {
                l[i].windowMinimizing(window);
                ++i;
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowMinimizing(window);
        }
    }

    void fireWindowMaximizing(DockingWindow window) throws OperationAbortedException {
        if (this.getListeners() != null) {
            DockingWindowListener[] l = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            int i = 0;
            while (i < l.length) {
                l[i].windowMaximizing(window);
                ++i;
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowMaximizing(window);
        }
    }

    void fireWindowRestoring(DockingWindow window) throws OperationAbortedException {
        if (this.getListeners() != null) {
            DockingWindowListener[] l = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            int i = 0;
            while (i < l.length) {
                l[i].windowRestoring(window);
                ++i;
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowRestoring(window);
        }
    }

    void fireWindowDocking(DockingWindow window) throws OperationAbortedException {
        if (this.getListeners() != null) {
            DockingWindowListener[] l = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            int i = 0;
            while (i < l.length) {
                l[i].windowDocking(window);
                ++i;
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowDocking(window);
        }
    }

    void fireWindowDocked(DockingWindow window, DockingWindow[] oldAncestors) {
        this.doFireWindowDocked(window);
        int i = oldAncestors.length - 1;
        while (i >= 0) {
            oldAncestors[i].doFireWindowDocked(this);
            --i;
        }
    }

    void fireWindowDocked(ArrayList dockedViews) {
        int i = 0;
        while (i < dockedViews.size()) {
            DockingWindow window = (DockingWindow)dockedViews.get(i);
            window.doFireWindowDocked(window);
            DockingWindow[] ancestors = window.getAncestors();
            int k = 0;
            while (k < ancestors.length) {
                ancestors[k].doFireWindowDocked(window);
                ++k;
            }
            ++i;
        }
    }

    private void doFireWindowDocked(DockingWindow window) {
        if (this.getListeners() != null) {
            DockingWindowListener[] l = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            int i = 0;
            while (i < l.length) {
                l[i].windowDocked(window);
                ++i;
            }
        }
    }

    private void doFireWindowRestored(DockingWindow window) {
        if (this.getListeners() != null) {
            DockingWindowListener[] l = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            int i = 0;
            while (i < l.length) {
                l[i].windowRestored(window);
                ++i;
            }
        }
    }

    void fireWindowMaximized(DockingWindow window) {
        if (this.getListeners() != null) {
            DockingWindowListener[] l = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            int i = 0;
            while (i < l.length) {
                l[i].windowMaximized(window);
                ++i;
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowMaximized(window);
        }
    }

    void fireWindowMinimized(DockingWindow window, DockingWindow[] oldAncestors) {
        this.doFireWindowMinimized(window);
        int i = oldAncestors.length - 1;
        while (i >= 0) {
            oldAncestors[i].doFireWindowMinimized(window);
            --i;
        }
    }

    private void doFireWindowMinimized(DockingWindow window) {
        if (this.getListeners() != null) {
            DockingWindowListener[] l = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            int i = 0;
            while (i < l.length) {
                l[i].windowMinimized(window);
                ++i;
            }
        }
    }

    void fireWindowRestored(DockingWindow window) {
        if (this.getListeners() != null) {
            DockingWindowListener[] l = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            int i = 0;
            while (i < l.length) {
                l[i].windowRestored(window);
                ++i;
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowRestored(window);
        }
    }

    protected void setLastMinimizedDirection(Direction direction) {
        this.windowItem.setLastMinimizedDirection(direction);
    }

    protected void clearChildrenFocus(DockingWindow child, View view) {
        int i = 0;
        while (i < this.getChildWindowCount()) {
            if (child != this.getChildWindow(i)) {
                this.getChildWindow(i).clearFocus(view);
            }
            ++i;
        }
    }

    void childGainedFocus(DockingWindow child, View view) {
        if (child != null) {
            this.lastFocusedChildWindow = child;
        }
        this.clearChildrenFocus(child, view);
        if (this.windowParent != null) {
            this.windowParent.childGainedFocus(this, view);
        }
    }

    WindowTab getTab() {
        if (this.tab == null) {
            this.tab = new WindowTab(this, false);
        }
        return this.tab;
    }

    protected void childRemoved(DockingWindow child) {
        if (this.lastFocusedChildWindow == child) {
            this.lastFocusedChildWindow = null;
        }
    }

    protected void updateButtonVisibility() {
        if (this.tab != null) {
            this.tab.updateTabButtons(null);
        }
        int i = 0;
        while (i < this.getChildWindowCount()) {
            this.getChildWindow(i).updateButtonVisibility();
            ++i;
        }
    }

    protected final void readLocations(ObjectInputStream in, RootWindow rootWindow, int version) throws IOException {
        if (version < 3) {
            LocationDecoder.decode(in, rootWindow);
        }
        if (version > 1) {
            int index = in.readInt();
            this.lastFocusedChildWindow = index == -1 ? null : this.getChildWindow(index);
        }
        int i = 0;
        while (i < this.getChildWindowCount()) {
            this.getChildWindow(i).readLocations(in, rootWindow, version);
            ++i;
        }
    }

    protected void writeLocations(ObjectOutputStream out) throws IOException {
        out.writeInt(this.lastFocusedChildWindow == null ? -1 : this.getChildWindowIndex(this.lastFocusedChildWindow));
        int i = 0;
        while (i < this.getChildWindowCount()) {
            this.getChildWindow(i).writeLocations(out);
            ++i;
        }
    }

    protected static void beginOptimize(DockingWindow window) {
        ++optimizeDepth;
        if (window != null) {
            optimizeWindows.add(window);
        }
        PropertyMapManager.getInstance().beginBatch();
    }

    protected static void endOptimize() {
        PropertyMapManager.getInstance().endBatch();
        if (--optimizeDepth == 0) {
            while (optimizeWindows.size() > 0) {
                HashSet s = optimizeWindows;
                optimizeWindows = new HashSet();
                for (DockingWindow window : s) {
                    window.optimizeWindowLayout();
                }
            }
        }
    }

    protected static void optimizeAfter(DockingWindow window, final Runnable runnable) {
        FocusManager.getInstance().pinFocus(new Runnable(){

            @Override
            public void run() {
                DockingWindow.beginOptimize(DockingWindow.this);
                try {
                    runnable.run();
                }
                finally {
                    DockingWindow.endOptimize();
                }
            }
        });
    }

    protected boolean needsTitleWindow() {
        return false;
    }

    protected boolean showsWindowTitle() {
        return false;
    }

    protected void optimizeWindowLayout() {
    }

    protected DockingWindow getLocationWindow() {
        return this;
    }

    protected void fireTitleChanged() {
        if (this.tab != null) {
            this.tab.windowTitleChanged();
        }
        if (this.windowParent != null) {
            this.windowParent.fireTitleChanged();
        }
    }

    protected DockingWindow getContentWindow(DockingWindow parent) {
        return this.needsTitleWindow() && !parent.showsWindowTitle() ? new TabWindow(this) : this;
    }

    protected final void removeChildWindow(final DockingWindow window) {
        DockingWindow.optimizeAfter(window.getWindowParent(), new Runnable(){

            @Override
            public void run() {
                if (window.isShowingInRootWindow()) {
                    window.fireWindowHidden(window);
                }
                window.setWindowParent(null);
                if (DockingWindow.this.lastFocusedChildWindow == window) {
                    DockingWindow.this.lastFocusedChildWindow = null;
                }
                DockingWindow.this.doRemoveWindow(window);
                DockingWindow.this.fireTitleChanged();
                window.fireWindowRemoved(DockingWindow.this, window);
                DockingWindow.this.fireWindowRemoved(DockingWindow.this, window);
                DockingWindow.this.afterWindowRemoved(window);
            }
        });
    }

    protected final void removeWindow(DockingWindow window) {
        window.setWindowParent(null);
        if (this.getUpdateModel()) {
            this.windowItem.removeWindow(this.windowItem.getChildWindowContaining(window.getWindowItem()));
            this.cleanUpModel();
        }
    }

    protected final void detach() {
        DockingWindow oldParent = this.getWindowParent();
        if (oldParent != null) {
            oldParent.removeChildWindow(this);
        }
    }

    protected final DockingWindow addWindow(DockingWindow window) {
        if (window == null) {
            return null;
        }
        DockingWindow w = window.getContentWindow(this);
        w.detach();
        w.setWindowParent(this);
        this.fireTitleChanged();
        w.fireWindowAdded(this, w);
        if (w.isShowingInRootWindow()) {
            this.fireWindowShown(w);
        }
        return w;
    }

    protected void rootChanged(RootWindow oldRoot, RootWindow newRoot) {
        if (newRoot != null) {
            this.lastRootWindow = new WeakReference<RootWindow>(newRoot);
        }
        int i = 0;
        while (i < this.getChildWindowCount()) {
            if (this.getChildWindow(i) != null) {
                this.getChildWindow(i).rootChanged(oldRoot, newRoot);
            }
            ++i;
        }
        this.updateWindowItem(newRoot);
    }

    protected void clearFocus(View view) {
        int i = 0;
        while (i < this.getChildWindowCount()) {
            this.getChildWindow(i).clearFocus(view);
            ++i;
        }
    }

    private void setWindowParent(DockingWindow window) {
        if (window == this.windowParent) {
            return;
        }
        RootWindow oldRoot = this.getRootWindow();
        if (this.windowParent != null) {
            if (this.isMaximized()) {
                if (this.isUndocked()) {
                    DockingUtil.getFloatingWindowFor(this).setMaximizedWindow(null);
                } else {
                    this.getRootWindow().setMaximizedWindow(null);
                }
            }
            this.windowParent.childRemoved(this);
            this.clearFocus(null);
            if (this.tab != null) {
                this.tab.setContentComponent(this);
            }
        }
        this.windowParent = window;
        RootWindow newRoot = this.getRootWindow();
        if (oldRoot != newRoot) {
            this.rootChanged(oldRoot, newRoot);
        }
    }

    private Direction getSplitDirection(Point p) {
        double[] relativeDist = new double[]{p.getX() / (double)this.getWidth(), ((double)this.getWidth() - p.getX()) / (double)this.getWidth(), p.getY() / (double)this.getHeight(), ((double)this.getHeight() - p.getY()) / (double)this.getHeight()};
        int index = ArrayUtil.findSmallest(relativeDist);
        return index == 0 ? Direction.LEFT : (index == 1 ? Direction.RIGHT : (index == 2 ? Direction.UP : Direction.DOWN));
    }

    private int getEdgeDistance(Point p, Direction dir) {
        return dir == Direction.RIGHT ? this.getWidth() - p.x : (dir == Direction.DOWN ? this.getHeight() - p.y : (dir == Direction.LEFT ? p.x : p.y));
    }

    DropAction acceptDrop(Point p, DockingWindow window) {
        DropAction da = null;
        FloatingWindow fw = DockingUtil.getFloatingWindowFor(window);
        FloatingWindow fw2 = DockingUtil.getFloatingWindowFor(this);
        if (this.getRootWindow() != window.getRootWindow() || (window.getWindowProperties().getDockEnabled() || fw == null || fw2 != null) && (window.getWindowProperties().getUndockEnabled() || fw == fw2)) {
            da = !this.isShowing() || !this.contains(p) || this.hasParent(window) || !this.getRootWindow().getRootWindowProperties().getRecursiveTabsEnabled() && this.insideTab() ? null : this.doAcceptDrop(p, window);
        }
        return da;
    }

    DropAction getDefaultDropAction() {
        return new DropAction(){

            @Override
            public void execute(DockingWindow window, MouseEvent mouseEvent) {
                if (DockingWindow.this.getWindowProperties().getUndockEnabled() && DockingWindow.this.getWindowProperties().getUndockOnDropEnabled()) {
                    FloatingWindow fw;
                    Point p = mouseEvent.getPoint();
                    Point p2 = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), p, DockingWindow.this.getRootWindow());
                    Point p3 = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), p, DockingWindow.this.getRootWindow().getRootPane());
                    if (!DockingWindow.this.getRootWindow().contains(p2) && !DockingWindow.this.getRootWindow().floatingWindowsContainPoint(p3) && ((fw = DockingUtil.getFloatingWindowFor(window)) == null || fw.getChildWindowCount() > 0 && fw.getChildWindow(0).getChildWindowCount() > 1)) {
                        SwingUtilities.convertPointToScreen(p, (Component)mouseEvent.getSource());
                        p.x -= window.getWidth() / 2;
                        p.y -= Math.min(DROP_FLOATING_YOFFSET, window.getHeight() / 2);
                        try {
                            window.undockWithAbort(p);
                        }
                        catch (OperationAbortedException operationAbortedException) {
                            // empty catch block
                        }
                    }
                }
            }
        };
    }

    protected boolean acceptsSplitWith(DockingWindow window) {
        return window != this;
    }

    protected DropAction doAcceptDrop(Point p, DockingWindow window) {
        DropAction da = this.acceptSplitDrop(p, window, this.getRootWindow().getRootWindowProperties().getEdgeSplitDistance());
        if (da != null) {
            return da;
        }
        da = this.acceptChildDrop(p, window);
        if (da != null) {
            return da;
        }
        da = this.acceptInteriorDrop(p, window);
        if (da != null) {
            return da;
        }
        return this.acceptSplitDrop(p, window, -1);
    }

    protected DropAction acceptSplitDrop(Point p, DockingWindow window, int splitDistance) {
        if (!this.acceptsSplitWith(window)) {
            return null;
        }
        Direction splitDir = this.getSplitDirection(p);
        int dist = this.getEdgeDistance(p, splitDir);
        if (splitDistance != -1 && dist > splitDistance * this.getEdgeDepth(splitDir)) {
            return null;
        }
        if (this.getSplitDropFilter().acceptDrop(new SplitDropInfo(window, this, p, splitDir))) {
            return this.split(window, splitDir);
        }
        return null;
    }

    protected DropAction split(DockingWindow window, final Direction splitDir) {
        int width = splitDir == Direction.LEFT || splitDir == Direction.RIGHT ? this.getWidth() / 3 : this.getWidth();
        int height = splitDir == Direction.DOWN || splitDir == Direction.UP ? this.getHeight() / 3 : this.getHeight();
        int x = splitDir == Direction.RIGHT ? this.getWidth() - width : 0;
        int y = splitDir == Direction.DOWN ? this.getHeight() - height : 0;
        Rectangle rect = new Rectangle(x, y, width, height);
        this.getRootWindow().setDragRectangle(SwingUtilities.convertRectangle(this, rect, this.getRootWindow()));
        return new DropAction(){

            @Override
            public void execute(DockingWindow window, MouseEvent mouseEvent) {
                try {
                    window.beforeDrop(DockingWindow.this);
                    DockingWindow.this.split(window, splitDir, splitDir == Direction.UP || splitDir == Direction.LEFT ? 0.33f : 0.66f);
                    window.restoreFocus();
                }
                catch (OperationAbortedException operationAbortedException) {
                    // empty catch block
                }
            }
        };
    }

    protected void beforeDrop(DockingWindow target) throws OperationAbortedException {
        if (!this.isMinimized() && target.isMinimized()) {
            this.fireWindowMinimizing(this);
        }
        if (!this.isUndocked() && target.isUndocked()) {
            this.fireWindowUndocking(this);
        }
    }

    protected DropAction createTabWindow(DockingWindow window) {
        this.getRootWindow().setDragRectangle(SwingUtilities.convertRectangle(this.getParent(), this.getBounds(), this.getRootWindow()));
        return new DropAction(){

            @Override
            public void execute(final DockingWindow window, MouseEvent mouseEvent) {
                DockingWindow.optimizeAfter(window.getWindowParent(), new Runnable(){

                    @Override
                    public void run() {
                        try {
                            window.beforeDrop(DockingWindow.this);
                            TabWindow tabWindow = new TabWindow();
                            DockingWindow.this.windowParent.replaceChildWindow(DockingWindow.this, tabWindow);
                            tabWindow.addTab(DockingWindow.this);
                            tabWindow.addTab(window);
                        }
                        catch (OperationAbortedException operationAbortedException) {
                            // empty catch block
                        }
                    }
                });
            }
        };
    }

    protected DropAction acceptInteriorDrop(Point p, DockingWindow window) {
        return null;
    }

    protected boolean hasParent(DockingWindow w) {
        return w == this || this.getWindowParent() != null && this.getWindowParent().hasParent(w);
    }

    protected DockingWindow oldRead(ObjectInputStream in, ReadContext context) throws IOException {
        this.windowItem.readSettings(in, context);
        return this;
    }

    protected abstract PropertyMap getPropertyObject();

    protected abstract PropertyMap createPropertyObject();

    void showPopupMenu(MouseEvent event) {
        if (event.isConsumed()) {
            return;
        }
        DockingWindow w = this;
        while (w.getPopupMenuFactory() == null) {
            if ((w = w.getWindowParent()) != null) continue;
            return;
        }
        JPopupMenu popupMenu = w.getPopupMenuFactory().createPopupMenu(this);
        if (popupMenu != null && popupMenu.getComponentCount() > 0) {
            popupMenu.show(event.getComponent(), event.getX(), event.getY());
        }
    }

    protected void setFocused(boolean focused) {
        if (this.tab != null) {
            this.tab.setFocused(focused);
        }
    }

    protected int getEdgeDepth(Direction dir) {
        return 1 + (this.windowParent == null ? 0 : this.windowParent.getChildEdgeDepth(this, dir));
    }

    protected int getChildEdgeDepth(DockingWindow window, Direction dir) {
        return this.windowParent == null ? 0 : this.windowParent.getChildEdgeDepth(this, dir);
    }

    protected DropAction acceptChildDrop(Point p, DockingWindow window) {
        int i = 0;
        while (i < this.getChildWindowCount()) {
            DropAction da;
            DockingWindow childWindow = this.getChildWindow(i);
            Point p2 = SwingUtilities.convertPoint(this, p, childWindow);
            if (this.getChildDropFilter().acceptDrop(new ChildDropInfo(window, this, p, childWindow)) && (da = childWindow.acceptDrop(p2, window)) != null) {
                return da;
            }
            ++i;
        }
        return null;
    }

    protected WindowItem getWindowItem() {
        return this.windowItem;
    }

    protected boolean getUpdateModel() {
        return updateModelDepth == 0 && this.windowItem.isRestoreWindow();
    }

    private void findViews(ArrayList views) {
        if (this instanceof View) {
            views.add(this);
        }
        int i = 0;
        while (i < this.getChildWindowCount()) {
            this.getChildWindow(i).findViews(views);
            ++i;
        }
    }

    private void restoreViews(ArrayList views) {
        int i = 0;
        while (i < views.size()) {
            ((DockingWindow)views.get(i)).restoreItem();
            ++i;
        }
    }

    protected static void beginUpdateModel() {
        ++updateModelDepth;
    }

    protected static void endUpdateModel() {
        --updateModelDepth;
    }

    private void restoreItem() {
        DockingWindow.beginUpdateModel();
        try {
            RootWindow rootWindow;
            if (this.windowItem != null) {
                WindowItem item = this.windowItem;
                while (item.getParent() != null) {
                    DockingWindow w;
                    DockingWindow parentWindow = item.getParent().getConnectedWindow();
                    if (parentWindow != null && parentWindow.getRootWindow() != null && !parentWindow.isMinimized() && !parentWindow.isUndocked()) {
                        if (parentWindow instanceof TabWindow) {
                            DockingWindow.insertTab((TabWindow)parentWindow, this);
                        } else if (parentWindow instanceof RootWindow) {
                            w = this.getContainer(item.getParent(), this.windowItem);
                            ((RootWindow)parentWindow).setWindow(w);
                        }
                        return;
                    }
                    w = null;
                    int i = 0;
                    while (i < item.getParent().getWindowCount()) {
                        WindowItem child = item.getParent().getWindow(i);
                        if (child != item && (w = child.getVisibleDockingWindow()) != null) break;
                        ++i;
                    }
                    if (w != null) {
                        final DockingWindow w1 = w;
                        final WindowItem fitem = item;
                        DockingWindow.optimizeAfter(w.getWindowParent(), new Runnable(){

                            @Override
                            public void run() {
                                if (fitem.getParent() instanceof SplitWindowItem) {
                                    SplitWindowItem splitWindowItem = (SplitWindowItem)fitem.getParent();
                                    boolean isLeft = splitWindowItem.getWindow(0) == fitem;
                                    SplitWindow newWindow = new SplitWindow(splitWindowItem.isHorizontal(), splitWindowItem.getDividerLocation(), null, null, splitWindowItem);
                                    w1.getWindowParent().internalReplaceChildWindow(w1, newWindow);
                                    DockingWindow w = DockingWindow.this.getContainer(splitWindowItem, DockingWindow.this.windowItem);
                                    DockingWindow w2 = w1.getContainer(splitWindowItem, w1.windowItem);
                                    newWindow.setWindows(isLeft ? w : w2, isLeft ? w2 : w);
                                } else if (fitem.getParent() instanceof TabWindowItem) {
                                    TabWindowItem tabWindowItem = (TabWindowItem)fitem.getParent();
                                    TabWindow newWindow = new TabWindow(null, tabWindowItem);
                                    w1.getWindowParent().internalReplaceChildWindow(w1, newWindow);
                                    DockingWindow.insertTab(newWindow, DockingWindow.this);
                                    DockingWindow.insertTab(newWindow, w1.getOptimizedWindow());
                                }
                            }
                        });
                        return;
                    }
                    item = item.getParent();
                }
            }
            if ((rootWindow = (RootWindow)this.lastRootWindow.get()) != null) {
                final WindowItem topItem = this.getWindowItem().getTopItem();
                DockingWindow.optimizeAfter(null, new Runnable(){

                    @Override
                    public void run() {
                        DockingWindow w = rootWindow.getWindow();
                        if (w == null) {
                            WindowItem wi = rootWindow.getWindowItem();
                            if (wi.getWindowCount() == 0) {
                                wi.addWindow(topItem);
                            } else {
                                SplitWindowItem splitWindowItem = new SplitWindowItem();
                                splitWindowItem.addWindow(wi.getWindow(0));
                                splitWindowItem.addWindow(topItem);
                                wi.addWindow(splitWindowItem);
                            }
                            rootWindow.setWindow(DockingWindow.this.getContainer(topItem, DockingWindow.this.getWindowItem()));
                        } else {
                            SplitWindow newWindow = new SplitWindow(true);
                            newWindow.getWindowItem().addWindow(rootWindow.getWindowItem().getWindow(0));
                            newWindow.getWindowItem().addWindow(topItem);
                            rootWindow.setWindow(newWindow);
                            newWindow.setWindows(w, DockingWindow.this.getContainer(topItem, DockingWindow.this.getWindowItem()));
                            rootWindow.getWindowItem().addWindow(newWindow.getWindowItem());
                        }
                    }
                });
            }
        }
        finally {
            DockingWindow.endUpdateModel();
        }
    }

    private static void insertTab(TabWindow tabWindow, DockingWindow window) {
        int index = 0;
        WindowItem item = tabWindow.getWindowItem();
        WindowItem childItem = item.getChildWindowContaining(window.getWindowItem());
        int i = 0;
        while (i < item.getWindowCount()) {
            WindowItem wi = item.getWindow(i);
            if (wi == childItem) break;
            DockingWindow w = wi.getVisibleDockingWindow();
            if (w != null) {
                ++index;
            }
            ++i;
        }
        tabWindow.addTabNoSelect(window, index);
        tabWindow.updateSelectedTab();
    }

    /*
     * Unable to fully structure code
     */
    private DockingWindow getContainer(WindowItem topItem, WindowItem item) {
        if (this.needsTitleWindow()) ** GOTO lbl9
        return this;
lbl-1000:
        // 1 sources

        {
            if (item instanceof TabWindowItem) {
                w = new TabWindow(null, (TabWindowItem)item);
                w.addTabNoSelect(this, 0);
                return w;
            }
            item = item.getParent();
lbl9:
            // 2 sources

            ** while (item != topItem)
        }
lbl10:
        // 1 sources

        w = new TabWindow();
        w.addTabNoSelect(this, 0);
        item.replaceWith(w.getWindowItem());
        w.getWindowItem().addWindow(item);
        return w;
    }

    private void setWindowItem(WindowItem windowItem) {
        this.windowItem = windowItem;
        windowItem.setConnectedWindow(this);
        this.updateWindowItem(this.getRootWindow());
    }

    protected void updateWindowItem(RootWindow rootWindow) {
        this.windowItem.setParentDockingWindowProperties(rootWindow == null ? WindowItem.emptyProperties : rootWindow.getRootWindowProperties().getDockingWindowProperties());
    }

    protected void afterWindowRemoved(DockingWindow window) {
    }

    protected void write(ObjectOutputStream out, WriteContext context, ViewWriter viewWriter) throws IOException {
    }

    protected void cleanUpModel() {
        if (this.windowParent != null) {
            this.windowParent.cleanUpModel();
        }
    }

    DropFilter getSplitDropFilter() {
        return this.getWindowProperties().getDropFilterProperties().getSplitDropFilter();
    }

    DropFilter getChildDropFilter() {
        return this.getWindowProperties().getDropFilterProperties().getChildDropFilter();
    }

    DropFilter getInteriorDropFilter() {
        return this.getWindowProperties().getDropFilterProperties().getInteriorDropFilter();
    }

    DropFilter getInsertTabDropFilter() {
        return this.getWindowProperties().getDropFilterProperties().getInsertTabDropFilter();
    }
}

