/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.traces.painters;

import info.monitorenter.gui.chart.ITracePainter;
import info.monitorenter.gui.chart.TracePoint2D;
import java.awt.Graphics;

public abstract class ATracePainter
implements ITracePainter {
    private boolean m_isEnded = false;
    private int m_previousX;
    private int m_previousY;
    private TracePoint2D m_previousPoint;

    public int compareTo(ITracePainter o) {
        return this.getClass().getName().compareTo(o.getClass().getName());
    }

    public void discontinue(Graphics g2d) {
        this.endPaintIteration(g2d);
        this.startPaintIteration(g2d);
    }

    public void endPaintIteration(Graphics g2d) {
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null) {
            result = this.getClass() == obj.getClass();
        }
        return result;
    }

    public int getPreviousX() {
        int result = this.m_previousX;
        if (this.m_isEnded) {
            this.m_previousX = Integer.MIN_VALUE;
            if (this.m_previousY == Integer.MIN_VALUE) {
                this.m_isEnded = false;
            }
        }
        return result;
    }

    public int getPreviousY() {
        int result = this.m_previousY;
        if (this.m_isEnded) {
            this.m_previousY = Integer.MIN_VALUE;
            if (this.m_previousX == Integer.MIN_VALUE) {
                this.m_isEnded = false;
            }
        }
        return result;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public void paintPoint(int absoluteX, int absoluteY, int nextX, int nextY, Graphics g, TracePoint2D original) {
        this.m_previousX = nextX;
        this.m_previousY = nextY;
        this.m_previousPoint = original;
    }

    public void startPaintIteration(Graphics g2d) {
    }

    protected TracePoint2D getPreviousPoint() {
        return this.m_previousPoint;
    }
}

