/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import ca.odell.glazedlists.swing.DefaultEventComboBoxModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import com.jidesoft.swing.CheckBoxList;
import com.jidesoft.swing.CheckBoxListSelectionModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.controller.SenderFilmlistLoadApprover;
import mediathek.gui.dialogEinstellungen.DaysSpinner;
import mediathek.gui.messages.FilmListImportTypeChangedEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.FileDialogs;
import mediathek.tool.FilmListUpdateType;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MessageBus;
import mediathek.tool.SVGIconUtilities;
import mediathek.tool.SenderListBoxModel;
import mediathek.tool.TextCopyPasteHandler;
import mediathek.tool.swing.MultilineLabel;
import net.engio.mbassy.listener.Handler;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.configuration2.Configuration;
import org.jdesktop.swingx.VerticalLayout;

public class PanelFilmlisteLaden
extends JPanel {
    private final Configuration config = ApplicationConfiguration.getConfiguration();
    private boolean warningDialogShown;
    private boolean senderSelectionChanged;
    private JLabel lblUrl;
    private JTextField jTextFieldUrl;
    private JButton jButtonDateiAuswaehlen;
    private JCheckBox jCheckBoxUpdate;
    private JRadioButton jRadioButtonAuto;
    private JRadioButton jRadioButtonManuell;
    private JCheckBox cbEvaluateDuplicates;
    private JButton btnReloadFilmlist;
    private JCheckBox cbSign;
    private JCheckBox cbTrailer;
    private JCheckBox cbAudio;
    private JCheckBox cbLivestreams;
    private JPanel panel1;
    private CheckBoxList senderCheckBoxList;

    public PanelFilmlisteLaden(boolean inSettingsDialog) {
        MessageBus.getMessageBus().subscribe((Object)this);
        this.initComponents();
        this.jButtonDateiAuswaehlen.setIcon((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/folder-open.svg"));
        this.init();
        this.initReloadButton();
        this.setupCheckBoxes();
        this.btnReloadFilmlist.setVisible(inSettingsDialog);
        if (inSettingsDialog) {
            this.prepareSettingsLayout();
        } else {
            this.panel1.setToolTipText("<html>Bei \u00c4nderungen wird eine komplette Filmliste vom Server geladen.<br>Dies funktioniert <b>NICHT im Erweiterungsmodus</b>!!!</html>");
            this.panel1.setBorder(new TitledBorder("Ausgew\u00e4hlte Sender laden:"));
        }
        this.setupSenderList();
        this.jRadioButtonManuell.addChangeListener(changeEvent -> {
            boolean selected = this.jRadioButtonManuell.isSelected();
            this.jTextFieldUrl.setEnabled(selected);
            this.jButtonDateiAuswaehlen.setEnabled(selected);
            this.jCheckBoxUpdate.setEnabled(selected);
        });
        boolean enableDuplicateEvaluation = this.config.getBoolean("film.evaluate_duplicates", true);
        this.cbEvaluateDuplicates.setSelected(enableDuplicateEvaluation);
        this.cbEvaluateDuplicates.addActionListener(actionEvent -> this.config.setProperty("film.evaluate_duplicates", (Object)this.cbEvaluateDuplicates.isSelected()));
    }

    private void initReloadButton() {
        this.btnReloadFilmlist.setIcon((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/arrows-rotate.svg"));
        this.btnReloadFilmlist.addActionListener(actionEvent -> {
            Daten daten = Daten.getInstance();
            daten.getListeFilme().clear();
            daten.getFilmeLaden().loadFilmlist("", this.hasSenderSelectionChanged());
        });
    }

    private void setupSenderList() {
        DefaultEventComboBoxModel model = GlazedListsSwing.eventComboBoxModelWithThreadProxyList(SenderListBoxModel.getProvidedSenderList());
        this.senderCheckBoxList.setModel((ListModel)model);
        CheckBoxListSelectionModel cblsm = this.senderCheckBoxList.getCheckBoxListSelectionModel();
        for (int i = 0; i < model.getSize(); ++i) {
            String item = (String)model.getElementAt(i);
            if (SenderFilmlistLoadApprover.isApproved(item)) {
                cblsm.addSelectionInterval(i, i);
                continue;
            }
            cblsm.removeSelectionInterval(i, i);
        }
        cblsm.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                for (int i = 0; i < model.getSize(); ++i) {
                    String item = (String)model.getElementAt(i);
                    if (cblsm.isSelectedIndex(i)) {
                        SenderFilmlistLoadApprover.approve(item);
                        continue;
                    }
                    SenderFilmlistLoadApprover.deny(item);
                }
                this.senderSelectionChanged = true;
                SwingUtilities.invokeLater(() -> {
                    if (!this.warningDialogShown) {
                        String msg = "<html>Bei \u00c4nderungen an den Sendern <b>muss</b> zwingend ein Neustart durchgef\u00fchrt werden.</html>";
                        JOptionPane.showMessageDialog(this, msg, "MediathekView", 2);
                        this.warningDialogShown = true;
                    }
                });
            }
        });
    }

    private void prepareSettingsLayout() {
        this.lblUrl.setVisible(false);
        this.jTextFieldUrl.setVisible(false);
        this.jButtonDateiAuswaehlen.setVisible(false);
    }

    private void setupCheckBoxes() {
        this.cbSign.setSelected(this.config.getBoolean("filmlist.load.sign_language", true));
        this.cbSign.addActionListener(actionEvent -> this.config.setProperty("filmlist.load.sign_language", (Object)this.cbSign.isSelected()));
        this.cbAudio.setSelected(this.config.getBoolean("filmlist.load.audio_description", true));
        this.cbAudio.addActionListener(actionEvent -> this.config.setProperty("filmlist.load.audio_description", (Object)this.cbAudio.isSelected()));
        this.cbTrailer.setSelected(this.config.getBoolean("filmlist.load.trailer", true));
        this.cbTrailer.addActionListener(actionEvent -> this.config.setProperty("filmlist.load.trailer", (Object)this.cbTrailer.isSelected()));
        this.cbLivestreams.setSelected(this.config.getBoolean("filmlist.load.livestreams", true));
        this.cbLivestreams.addActionListener(actionEvent -> this.config.setProperty("filmlist.load.livestreams", (Object)this.cbLivestreams.isSelected()));
        this.jCheckBoxUpdate.setSelected(this.config.getBoolean("filmlist.extend_old_filmlist", false));
        this.jCheckBoxUpdate.addActionListener(actionEvent -> this.config.setProperty("filmlist.extend_old_filmlist", (Object)this.jCheckBoxUpdate.isSelected()));
    }

    public boolean hasSenderSelectionChanged() {
        return this.senderSelectionChanged;
    }

    private void init() {
        this.initRadio();
        this.jButtonDateiAuswaehlen.setIcon((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/folder-open.svg"));
        this.jButtonDateiAuswaehlen.addActionListener(actionEvent -> {
            File loadFile = FileDialogs.chooseLoadFileLocation(MediathekGui.ui(), "Filmliste laden", "");
            if (loadFile != null) {
                this.jTextFieldUrl.setText(loadFile.getAbsolutePath());
            }
        });
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PanelFilmlisteLaden.this.jRadioButtonManuell.isSelected()) {
                    GuiFunktionen.setFilmListUpdateType(FilmListUpdateType.MANUAL);
                } else {
                    GuiFunktionen.setFilmListUpdateType(FilmListUpdateType.AUTOMATIC);
                }
                MessageBus.getMessageBus().publishAsync((Object)new FilmListImportTypeChangedEvent());
            }
        };
        this.jRadioButtonManuell.addActionListener(listener);
        this.jRadioButtonAuto.addActionListener(listener);
        this.jTextFieldUrl.getDocument().addDocumentListener(new BeobDateiUrl());
        TextCopyPasteHandler<JTextField> handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldUrl);
        this.jTextFieldUrl.setComponentPopupMenu(handler.getPopupMenu());
    }

    @Handler
    private void handleFilmListImportTypeChanged(FilmListImportTypeChangedEvent e) {
        SwingUtilities.invokeLater(this::initRadio);
    }

    private void initRadio() {
        switch (GuiFunktionen.getFilmListUpdateType()) {
            case MANUAL: {
                this.jRadioButtonManuell.setSelected(true);
                break;
            }
            case AUTOMATIC: {
                this.jRadioButtonAuto.setSelected(true);
            }
        }
        this.jTextFieldUrl.setText(MVConfig.get(MVConfig.Configs.SYSTEM_IMPORT_URL_MANUELL));
    }

    public JCheckBox getJCheckBoxUpdate() {
        return this.jCheckBoxUpdate;
    }

    public JTextField getJTextFieldUrl() {
        return this.jTextFieldUrl;
    }

    private void initComponents() {
        JPanel jPanelAuto = new JPanel();
        MultilineLabel multilineLabel1 = new MultilineLabel();
        JPanel jPanelManuel = new JPanel();
        MultilineLabel multilineLabel2 = new MultilineLabel();
        this.lblUrl = new JLabel();
        this.jTextFieldUrl = new JTextField();
        this.jButtonDateiAuswaehlen = new JButton();
        this.jCheckBoxUpdate = new JCheckBox();
        this.jRadioButtonAuto = new JRadioButton();
        this.jRadioButtonManuell = new JRadioButton();
        JSeparator separator1 = new JSeparator();
        JPanel panel3 = new JPanel();
        JPanel panel4 = new JPanel();
        this.cbEvaluateDuplicates = new JCheckBox();
        JPanel panel2 = new JPanel();
        JLabel label1 = new JLabel();
        DaysSpinner jSpinnerDays = new DaysSpinner();
        JLabel label2 = new JLabel();
        this.btnReloadFilmlist = new JButton();
        JPanel jPanel1 = new JPanel();
        this.cbSign = new JCheckBox();
        this.cbTrailer = new JCheckBox();
        this.cbAudio = new JCheckBox();
        this.cbLivestreams = new JCheckBox();
        this.panel1 = new JPanel();
        JScrollPane scrollPane1 = new JScrollPane();
        this.senderCheckBoxList = new CheckBoxList();
        this.setPreferredSize(new Dimension(740, 506));
        this.setLayout((LayoutManager)new MigLayout(new LC().fillX().insets("5").hideMode(3).gridGap("5", "5"), new AC().align("label").gap().size("640").grow().fill(), new AC().gap().gap().gap().gap()));
        jPanelAuto.setBorder(new TitledBorder("Die Filmliste automatisch laden"));
        jPanelAuto.setLayout((LayoutManager)new MigLayout(new LC().insets("5").hideMode(3).gridGap("5", "5"), new AC().grow().fill().gap().grow().fill(), new AC().fill()));
        multilineLabel1.setText("Die Filmliste wird beim Programmstart automatisch geladen (wenn \u00e4lter als 3h). Zus\u00e4tzlich kann sie \u00fcber den Button \"Filmliste laden\" aktualisiert werden.");
        multilineLabel1.setFont(multilineLabel1.getFont().deriveFont((float)multilineLabel1.getFont().getSize() - 1.0f));
        jPanelAuto.add((Component)multilineLabel1, new CC().cell(new int[]{0, 0, 2, 1}));
        this.add((Component)jPanelAuto, new CC().cell(new int[]{1, 0}));
        jPanelManuel.setBorder(new TitledBorder("Filmliste nur manuell laden"));
        jPanelManuel.setMaximumSize(new Dimension(750, Integer.MAX_VALUE));
        jPanelManuel.setLayout((LayoutManager)new MigLayout(new LC().insets("5").hideMode(3).gridGap("5", "5"), new AC().fill().gap().grow().fill().gap().fill().gap().fill(), new AC().fill().gap().fill().gap().fill()));
        multilineLabel2.setText("Die Filmliste wird nur manuell \u00fcber den Button \"Filmliste laden\" aus dem Internet geladen. Alternativ kann auch eine Datei zum Laden angegeben werden.");
        multilineLabel2.setFont(multilineLabel2.getFont().deriveFont((float)multilineLabel2.getFont().getSize() - 1.0f));
        jPanelManuel.add((Component)multilineLabel2, new CC().cell(new int[]{0, 0, 4, 1}));
        this.lblUrl.setText("Datei:");
        jPanelManuel.add((Component)this.lblUrl, new CC().cell(new int[]{0, 1}));
        jPanelManuel.add((Component)this.jTextFieldUrl, new CC().cell(new int[]{1, 1, 2, 1}));
        this.jButtonDateiAuswaehlen.setToolTipText("URL oder lokale Filmliste ausw\u00e4hlen");
        jPanelManuel.add((Component)this.jButtonDateiAuswaehlen, new CC().cell(new int[]{3, 1}).alignX("left").growX(0.0f).width("32:32:32").height("32:32:32"));
        this.jCheckBoxUpdate.setText("Alte Filmliste nicht l\u00f6schen, nur erweitern");
        jPanelManuel.add((Component)this.jCheckBoxUpdate, new CC().cell(new int[]{0, 2, 2, 1}));
        this.add((Component)jPanelManuel, new CC().cell(new int[]{1, 1}));
        this.add((Component)this.jRadioButtonAuto, new CC().cell(new int[]{0, 0}).alignY("top").growY(0.0f));
        this.add((Component)this.jRadioButtonManuell, new CC().cell(new int[]{0, 1}).alignY("top").growY(0.0f));
        this.add((Component)separator1, new CC().cell(new int[]{0, 2, 2, 1}).growX());
        panel3.setBorder(new TitledBorder("Einschr\u00e4nkungen f\u00fcr das Laden der Filmliste"));
        panel3.setLayout((LayoutManager)new VerticalLayout());
        panel4.setBorder(new TitledBorder("Duplikate (\u00c4nderungen erfordern Neuladen der Filmliste)"));
        panel4.setLayout((LayoutManager)new VerticalLayout());
        this.cbEvaluateDuplicates.setText("Erkennung beim Laden der Filmliste einschalten");
        panel4.add(this.cbEvaluateDuplicates);
        panel3.add(panel4);
        panel2.setLayout((LayoutManager)new MigLayout(new LC().insets("5").hideMode(3), new AC().fill().gap().fill().gap().fill().gap().align("left"), new AC().fill()));
        label1.setText("Nur Filme der letzten");
        panel2.add((Component)label1, new CC().cell(new int[]{0, 0}).alignX("center").growX(0.0f));
        panel2.add((Component)jSpinnerDays, new CC().cell(new int[]{1, 0}));
        label2.setText("Tage laden.");
        panel2.add((Component)label2, new CC().cell(new int[]{2, 0}).alignX("center").growX(0.0f));
        this.btnReloadFilmlist.setToolTipText("Filmliste jetzt aktualisieren");
        panel2.add((Component)this.btnReloadFilmlist, new CC().cell(new int[]{3, 0}));
        panel3.add(panel2);
        jPanel1.setBorder(new TitledBorder("Zus\u00e4tzliche Filmdaten laden"));
        jPanel1.setToolTipText("<html>Alle nicht angew\u00e4hlten Eintr\u00e4ge werden beim Laden der Filmliste aus dem Endergebnis herausgefiltert.<br/><b>Die Eintr\u00e4ge werden dauerhaft aus der lokalen Filmliste entfernt.</b><br/>Sie werden erst wieder beim Laden einer neuen Liste vom Server hinzugef\u00fcgt wenn die Einstellungen entsprechend angepasst wurden.</html>");
        jPanel1.setLayout((LayoutManager)new MigLayout(new LC().insets("5").hideMode(3).gridGap("5", "5"), new AC().fill().gap().fill().gap().fill().gap().fill(), new AC().fill()));
        this.cbSign.setText("Geb\u00e4rdensprache");
        jPanel1.add((Component)this.cbSign, new CC().cell(new int[]{2, 0}));
        this.cbTrailer.setText("Trailer/Teaser/Vorschau");
        jPanel1.add((Component)this.cbTrailer, new CC().cell(new int[]{0, 0}));
        this.cbAudio.setText("H\u00f6rfassungen");
        jPanel1.add((Component)this.cbAudio, new CC().cell(new int[]{1, 0}));
        this.cbLivestreams.setText("Livestreams");
        jPanel1.add((Component)this.cbLivestreams, new CC().cell(new int[]{3, 0}));
        panel3.add(jPanel1);
        this.panel1.setBorder(new TitledBorder("Diese Sender laden (\u00c4nderungen erfordern Programmneustart und eine vollst\u00e4ndig neue Filmliste)"));
        this.panel1.setToolTipText("<html>Die Einstellungen beziehen sich auf den n\u00e4chsten <b>vollst\u00e4ndigen</b> Ladevorgang einer Fillmliste.<br>Es kann somit vorkommen dass die Aktualisierung erst nach Neustart des Programms <br><b>und dem Laden einer kompletten Liste vom Server</b> (keine DIFF-Liste!) sichtbar wird.<br><br>Hier ge\u00e4nderte Einstellungen werden in der Senderliste des Filterdialogs <b>erst nach Neustart</b> sichtbar!</html>");
        this.panel1.setLayout((LayoutManager)new MigLayout(new LC().insets("5").hideMode(3).alignX("left").gridGapX("10"), new AC().grow().fill(), new AC()));
        this.senderCheckBoxList.setMaximumSize(null);
        this.senderCheckBoxList.setMinimumSize(new Dimension(100, 50));
        this.senderCheckBoxList.setPreferredSize(null);
        this.senderCheckBoxList.setLayoutOrientation(1);
        this.senderCheckBoxList.setSelectionMode(1);
        scrollPane1.setViewportView((Component)this.senderCheckBoxList);
        this.panel1.add((Component)scrollPane1, new CC().cell(new int[]{0, 0}));
        panel3.add(this.panel1);
        this.add((Component)panel3, new CC().cell(new int[]{0, 3, 2, 1}).growX());
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.jRadioButtonAuto);
        buttonGroup1.add(this.jRadioButtonManuell);
    }

    private class BeobDateiUrl
    implements DocumentListener {
        private BeobDateiUrl() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.turnOnManualImport();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.turnOnManualImport();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.turnOnManualImport();
        }

        private void turnOnManualImport() {
            MVConfig.add(MVConfig.Configs.SYSTEM_IMPORT_URL_MANUELL, PanelFilmlisteLaden.this.jTextFieldUrl.getText());
        }
    }
}

