/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten.blacklist;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import mediathek.config.MVConfig;
import mediathek.daten.DatenFilm;
import mediathek.daten.blacklist.BlacklistRule;
import mediathek.daten.blacklist.ListeBlacklist;
import mediathek.tool.Filter;

class ApplyBlacklistFilterPredicate
implements Predicate<DatenFilm> {
    private static final String[] EMPTY_STRING = new String[]{""};
    private final boolean isWhitelist = Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_IST_WHITELIST));
    private final ListeBlacklist listeBlacklist;
    private final Map<BlacklistRule, BlacklistPattern> rulePatternMap;

    public ApplyBlacklistFilterPredicate(ListeBlacklist listeBlacklist) {
        this.listeBlacklist = listeBlacklist;
        this.rulePatternMap = new ConcurrentHashMap<BlacklistRule, BlacklistPattern>(listeBlacklist.size());
        this.createPatterns();
    }

    private void createPatterns() {
        this.listeBlacklist.parallelStream().forEach(entry -> {
            String[] pTitel = this.createPattern(entry.hasTitlePattern(), entry.getTitel());
            String[] pThema = this.createPattern(entry.hasThemaPattern(), entry.getThema_titel());
            BlacklistPattern blPattern = new BlacklistPattern(pTitel, pThema);
            this.rulePatternMap.putIfAbsent((BlacklistRule)entry, blPattern);
        });
    }

    @Override
    public boolean test(DatenFilm film) {
        for (BlacklistRule entry : this.listeBlacklist) {
            BlacklistPattern blPattern = this.rulePatternMap.get(entry);
            if (!this.performFiltering(entry, blPattern.pTitel, blPattern.pThema, film)) continue;
            return this.isWhitelist;
        }
        return !this.isWhitelist;
    }

    protected String[] mySplit(String inputString) {
        String[] pTitle = inputString.split(",");
        if (pTitle.length == 0) {
            return EMPTY_STRING;
        }
        return pTitle;
    }

    private String[] createPattern(boolean isPattern, String inputString) {
        if (isPattern) {
            return new String[]{inputString};
        }
        return this.mySplit(inputString);
    }

    private boolean performFiltering(BlacklistRule entry, String[] titelSuchen, String[] themaTitelSuchen, DatenFilm film) {
        boolean result = false;
        String thema = film.getThema();
        String title = film.getTitle();
        String senderSuchen = entry.getSender();
        String themaSuchen = entry.getThema();
        if ((senderSuchen.isEmpty() || film.getSender().compareTo(senderSuchen) == 0) && (themaSuchen.isEmpty() || thema.equalsIgnoreCase(themaSuchen)) && (titelSuchen.length == 0 || Filter.pruefen(titelSuchen, title)) && (themaTitelSuchen.length == 0 || Filter.pruefen(themaTitelSuchen, thema) || Filter.pruefen(themaTitelSuchen, title)) && this.checkLengthWithMin(film.getFilmLength())) {
            result = true;
        }
        return result;
    }

    public boolean lengthCheck(int filterLaengeInMinuten, long filmLaenge) {
        return filterLaengeInMinuten == 0 || filmLaenge == 0L;
    }

    private boolean checkLengthWithMin(long filmLaenge) {
        return this.lengthCheck(0, filmLaenge) || filmLaenge > 0L;
    }

    record BlacklistPattern(String[] pTitel, String[] pThema) {
    }
}

