/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import com.google.common.base.MoreObjects;
import java.io.File;
import java.util.Objects;
import javax.inject.Inject;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.provider.PropertyFactory;
import org.gradle.jvm.toolchain.internal.DefaultToolchainSpec;
import org.gradle.jvm.toolchain.internal.JavaExecutableUtils;
import org.gradle.jvm.toolchain.internal.JavaToolchainSpecInternal;

public class SpecificInstallationToolchainSpec
extends DefaultToolchainSpec {
    private final File javaHome;

    @Inject
    public SpecificInstallationToolchainSpec(PropertyFactory propertyFactory, File javaHome) {
        super(propertyFactory);
        this.javaHome = javaHome;
        this.finalizeProperties();
    }

    public static SpecificInstallationToolchainSpec fromJavaHome(PropertyFactory propertyFactory, File javaHome) {
        if (javaHome.exists()) {
            if (javaHome.isDirectory()) {
                return new SpecificInstallationToolchainSpec(propertyFactory, javaHome);
            }
            throw new InvalidUserDataException("The configured Java home is not a directory (" + javaHome.getAbsolutePath() + ")");
        }
        throw new InvalidUserDataException("The configured Java home does not exist (" + javaHome.getAbsolutePath() + ")");
    }

    public static SpecificInstallationToolchainSpec fromJavaExecutable(PropertyFactory propertyFactory, String executable) {
        return new SpecificInstallationToolchainSpec(propertyFactory, JavaExecutableUtils.resolveJavaHomeOfExecutable(executable));
    }

    @Override
    public Key toKey() {
        return new Key(this.javaHome);
    }

    @Override
    public boolean isConfigured() {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public File getJavaHome() {
        return this.javaHome;
    }

    @Override
    public String getDisplayName() {
        return MoreObjects.toStringHelper((String)"SpecificToolchain ").add("javaHome", (Object)this.javaHome).toString();
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    public static class Key
    implements JavaToolchainSpecInternal.Key {
        private final File javaHome;

        public Key(File javaHome) {
            this.javaHome = javaHome;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.javaHome, key.javaHome);
        }

        public int hashCode() {
            return Objects.hash(this.javaHome);
        }
    }
}

