/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.internal.xcodeproj;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.gradle.ide.xcode.internal.xcodeproj.PBXBuildPhase;
import org.gradle.ide.xcode.internal.xcodeproj.PBXFileReference;
import org.gradle.ide.xcode.internal.xcodeproj.PBXProjectItem;
import org.gradle.ide.xcode.internal.xcodeproj.XCConfigurationList;
import org.gradle.ide.xcode.internal.xcodeproj.XcodeprojSerializer;
import org.jspecify.annotations.Nullable;

public abstract class PBXTarget
extends PBXProjectItem {
    private final String name;
    private final ProductType productType;
    private final List<PBXBuildPhase> buildPhases;
    private final XCConfigurationList buildConfigurationList;
    private @Nullable String productName;
    private @Nullable PBXFileReference productReference;

    public PBXTarget(String name, ProductType productType) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.productType = (ProductType)((Object)Preconditions.checkNotNull((Object)((Object)productType)));
        this.buildPhases = new ArrayList<PBXBuildPhase>();
        this.buildConfigurationList = new XCConfigurationList();
    }

    public String getName() {
        return this.name;
    }

    public ProductType getProductType() {
        return this.productType;
    }

    public List<PBXBuildPhase> getBuildPhases() {
        return this.buildPhases;
    }

    public XCConfigurationList getBuildConfigurationList() {
        return this.buildConfigurationList;
    }

    public @Nullable String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public @Nullable PBXFileReference getProductReference() {
        return this.productReference;
    }

    public void setProductReference(PBXFileReference v) {
        this.productReference = v;
    }

    @Override
    public String isa() {
        return "PBXTarget";
    }

    @Override
    public int stableHash() {
        return this.name.hashCode();
    }

    @Override
    public void serializeInto(XcodeprojSerializer s) {
        super.serializeInto(s);
        s.addField("name", this.name);
        if (this.productType != null) {
            s.addField("productType", this.productType.toString());
        }
        if (this.productName != null) {
            s.addField("productName", this.productName);
        }
        if (this.productReference != null) {
            s.addField("productReference", this.productReference);
        }
        s.addField("buildPhases", this.buildPhases);
        if (this.buildConfigurationList != null) {
            s.addField("buildConfigurationList", this.buildConfigurationList);
        }
    }

    public static enum ProductType {
        INDEXER("org.gradle.product-type.indexer"),
        STATIC_LIBRARY("com.apple.product-type.library.static"),
        DYNAMIC_LIBRARY("com.apple.product-type.library.dynamic"),
        TOOL("com.apple.product-type.tool"),
        BUNDLE("com.apple.product-type.bundle"),
        FRAMEWORK("com.apple.product-type.framework"),
        STATIC_FRAMEWORK("com.apple.product-type.framework.static"),
        APPLICATION("com.apple.product-type.application"),
        UNIT_TEST("com.apple.product-type.bundle.unit-test"),
        IN_APP_PURCHASE_CONTENT("com.apple.product-type.in-app-purchase-content"),
        APP_EXTENSION("com.apple.product-type.app-extension"),
        WATCH_OS1_APPLICATION("com.apple.product-type.application.watchapp"),
        WATCH_OS1_EXTENSION("com.apple.product-type.watchkit-extension");

        public final String identifier;

        private ProductType(String identifier) {
            this.identifier = identifier;
        }

        public String toString() {
            return this.identifier;
        }
    }
}

