/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.com.ibm.icu;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.module.ModuleReader;
import java.lang.module.ResolvedModule;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeResourceAccess;
import org.graalvm.shadowed.com.ibm.icu.impl.ICUData;
import org.graalvm.shadowed.org.tukaani.xz.FinishableOutputStream;
import org.graalvm.shadowed.org.tukaani.xz.FinishableWrapperOutputStream;
import org.graalvm.shadowed.org.tukaani.xz.LZMA2Options;

public class ICU4JFeature
implements Feature {
    private static final int MIN_SIZE_TO_COMPRESS = 512;
    private static final double GOOD_ENOUGH_COMPRESSION_RATIO = 0.9;
    static final int DICT_SIZE = 65536;
    static final int MAGIC = 43778;

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        List<ResourceEntry> resourcePatterns = List.of(new ResourceEntry("org.graalvm.shadowed.com.ibm.icu.util.UResourceBundle", "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/[^/]*\\.(?:res|lst)$"), new ResourceEntry("org.graalvm.shadowed.com.ibm.icu.charset.CharsetMBCS", "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/.*\\.cnv$"), new ResourceEntry("org.graalvm.shadowed.com.ibm.icu.impl.UCaseProps", "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/ucase\\.icu$"), new ResourceEntry("org.graalvm.shadowed.com.ibm.icu.impl.UCharacterName", "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/unames\\.icu$"), new ResourceEntry("org.graalvm.shadowed.com.ibm.icu.impl.UCharacterProperty", "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/uprops\\.icu$"), new ResourceEntry("org.graalvm.shadowed.com.ibm.icu.impl.UCharacterProperty$LayoutProps", "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/ulayout\\.icu$"), new ResourceEntry("org.graalvm.shadowed.com.ibm.icu.impl.UPropertyAliases", "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/pnames\\.icu$"), new ResourceEntry("org.graalvm.shadowed.com.ibm.icu.impl.EmojiProps", "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/uemoji\\.icu$"), new ResourceEntry("org.graalvm.shadowed.com.ibm.icu.impl.UBiDiProps", "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/ubidi\\.icu$"), new ResourceEntry("org.graalvm.shadowed.com.ibm.icu.impl.coll.CollationRoot", "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/coll/ucadata\\.icu$"), new ResourceEntry(List.of("org.graalvm.shadowed.com.ibm.icu.impl.coll.CollationLoader", "org.graalvm.shadowed.com.ibm.icu.text.Collator"), "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/coll/[^/]*\\.res$"), new ResourceEntry("org.graalvm.shadowed.com.ibm.icu.charset.UConverterAlias", "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/cnvalias\\.icu$"), new ResourceEntry(List.of("org.graalvm.shadowed.com.ibm.icu.impl.TimeZoneNamesImpl", "org.graalvm.shadowed.com.ibm.icu.impl.TimeZoneGenericNames", "org.graalvm.shadowed.com.ibm.icu.text.TimeZoneFormat"), "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/zone/.*"), new ResourceEntry("org.graalvm.shadowed.com.ibm.icu.impl.ICURegionDataTables", "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/region/.*"), new ResourceEntry(List.of("org.graalvm.shadowed.com.ibm.icu.impl.ICULangDataTables", "org.graalvm.shadowed.com.ibm.icu.util.LocaleData"), "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/lang/.*"), new ResourceEntry(List.of("org.graalvm.shadowed.com.ibm.icu.impl.ICUCurrencyDisplayInfoProvider", "org.graalvm.shadowed.com.ibm.icu.impl.ICUCurrencyMetaInfo"), "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/curr/.*"), new ResourceEntry(List.of("org.graalvm.shadowed.com.ibm.icu.util.MeasureUnit", "org.graalvm.shadowed.com.ibm.icu.text.MeasureFormat", "org.graalvm.shadowed.com.ibm.icu.text.TimeUnitFormat", "org.graalvm.shadowed.com.ibm.icu.impl.number.LongNameHandler"), "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/unit/.*"), new ResourceEntry(List.of("org.graalvm.shadowed.com.ibm.icu.text.TransliteratorRegistry", "org.graalvm.shadowed.com.ibm.icu.text.Transliterator"), "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/translit/.*"), new ResourceEntry("org.graalvm.shadowed.com.ibm.icu.text.RuleBasedNumberFormat", "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/rbnf/.*"), new ResourceEntry(List.of("org.graalvm.shadowed.com.ibm.icu.text.BreakIteratorFactory", "org.graalvm.shadowed.com.ibm.icu.impl.breakiter.DictionaryBreakEngine", "org.graalvm.shadowed.com.ibm.icu.impl.SimpleFilteredSentenceBreakIterator$Builder"), "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/brkitr/.*"), new ResourceEntry("org.graalvm.shadowed.com.ibm.icu.text.SpoofChecker$SpoofData$DefaultData", "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/confusables\\.cfu"), new ResourceEntry("org.graalvm.shadowed.com.ibm.icu.text.StringPrep", "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/[^/]*\\.spp"), new ResourceEntry("org.graalvm.shadowed.com.ibm.icu.impl.Normalizer2Impl", "org/graalvm/shadowed/com/ibm/icu/impl/data/icudata/[^/]*\\.nrm"), new ResourceEntry("org.graalvm.shadowed.com.ibm.icu.impl.duration.impl.ResourceBasedPeriodFormatterDataService", "org/graalvm/shadowed/com/ibm/icu/impl/duration/impl/data/.*"));
        for (ResourceEntry e : resourcePatterns) {
            access.registerReachabilityHandler(acc -> this.addCompressedResources(e.resourcePaths()), e.classNames().stream().map(cn -> Objects.requireNonNull(access.findClassByName(cn), cn)).toArray());
        }
    }

    private void addCompressedResources(List<String> patterns) {
        block16: {
            Class<ICUData> refClass = ICUData.class;
            Module module = refClass.getModule();
            ModuleLayer layer = module.getLayer();
            try {
                if (layer != null) {
                    Optional<ResolvedModule> resolvedModule = layer.configuration().findModule(module.getName());
                    try (ModuleReader reader = resolvedModule.get().reference().open();){
                        Stream<String> entryStream = reader.list();
                        this.addCompressedResources(patterns, module, entryStream, name -> reader.open((String)name).get());
                        break block16;
                    }
                }
                URL urlClassPath = refClass.getClassLoader().getResource(refClass.getName().replace('.', '/').concat(".class"));
                if (urlClassPath != null && urlClassPath.getProtocol().equals("jar")) {
                    String jarFilePath = URI.create(urlClassPath.getPath()).getPath();
                    int separatorIndex = jarFilePath.indexOf("!/");
                    if (separatorIndex != -1) {
                        jarFilePath = jarFilePath.substring(0, separatorIndex);
                        try (JarFile jf = new JarFile(jarFilePath);){
                            Stream<String> entryStream = jf.stream().map(ZipEntry::getName);
                            this.addCompressedResources(patterns, module, entryStream, name -> jf.getInputStream(jf.getJarEntry((String)name)));
                            break block16;
                        }
                    }
                    throw new IllegalArgumentException(jarFilePath);
                }
                throw new IllegalArgumentException("ICU4J module needs to be to either be on the module path or in a jar file on the native image builder class path. Found URL: " + String.valueOf(urlClassPath));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private void addCompressedResources(List<String> patterns, Module module, Stream<String> entryStream, ThrowingFunction<String, InputStream, IOException> openResource) throws IOException {
        byte[] magic = new byte[]{2, -85};
        List<Pattern> compiledPatterns = patterns.stream().map(Pattern::compile).toList();
        Stream<String> filteredEntries = entryStream.filter(s -> !s.endsWith("/") && !s.endsWith(".class"));
        Iterator iterator = filteredEntries.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (!compiledPatterns.stream().anyMatch(pattern -> pattern.matcher(name).matches())) continue;
            ByteArrayOutputStream compressedOutput = new ByteArrayOutputStream();
            byte[] data = null;
            int keepUncompressedThreshold = 512;
            do {
                try (InputStream resourceInput = openResource.apply(name);){
                    int uncompressedSize = resourceInput.available();
                    if (uncompressedSize <= keepUncompressedThreshold) {
                        data = resourceInput.readAllBytes();
                        if (data.length < magic.length || !Arrays.equals(data, 0, magic.length, magic, 0, magic.length)) continue;
                        throw new IllegalStateException("Uncompressed data must not start with compressed header bytes");
                    }
                    int preset = 6;
                    LZMA2Options opts = new LZMA2Options(preset);
                    opts.setDictSize(65536);
                    compressedOutput.write(magic);
                    compressedOutput.write(preset);
                    compressedOutput.write(Integer.numberOfTrailingZeros(65536));
                    compressedOutput.write(new byte[]{(byte)uncompressedSize, (byte)(uncompressedSize >> 8), (byte)(uncompressedSize >> 16), (byte)(uncompressedSize >> 24)});
                    try (FinishableOutputStream xz = opts.getOutputStream((FinishableOutputStream)new FinishableWrapperOutputStream((OutputStream)compressedOutput));){
                        resourceInput.transferTo((OutputStream)xz);
                    }
                    byte[] compressed = compressedOutput.toByteArray();
                    int compressedSize = compressed.length;
                    if ((double)compressedSize / (double)uncompressedSize > 0.9) {
                        keepUncompressedThreshold = uncompressedSize;
                        continue;
                    }
                    data = compressed;
                }
            } while (data == null);
            RuntimeResourceAccess.addResource((Module)module, (String)name, (byte[])data);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private record ResourceEntry(List<String> classNames, List<String> resourcePaths) {
        ResourceEntry(List<String> classNames, String resourcePath) {
            this(classNames, List.of(resourcePath));
        }

        ResourceEntry(String className, String resourcePath) {
            this(List.of(className), List.of(resourcePath));
        }
    }

    @FunctionalInterface
    private static interface ThrowingFunction<T, R, E extends Throwable> {
        public R apply(T var1) throws E;
    }
}

