/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import com.oracle.truffle.js.runtime.builtins.JSBigInt;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;

public final class JSBigIntObject
extends JSNonProxyObject {
    private final BigInt value;

    protected JSBigIntObject(Shape shape, JSDynamicObject proto, BigInt value) {
        super(shape, proto);
        this.value = value;
    }

    public BigInt getBigIntValue() {
        return this.value;
    }

    @Override
    public TruffleString getClassName() {
        return JSBigInt.CLASS_NAME;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TruffleString toDisplayStringImpl(boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        if (JavaScriptLanguage.get(null).getJSContext().isOptionNashornCompatibilityMode()) {
            return super.toDisplayStringImpl(allowSideEffects, format, depth);
        }
        BigInt primitiveValue = JSBigInt.valueOf(this);
        return JSRuntime.objectToDisplayString(this, allowSideEffects, format, depth, this.getBuiltinToStringTag(), new TruffleString[]{Strings.PRIMITIVE_VALUE}, new Object[]{primitiveValue});
    }
}

