/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringBuilderUTF16;
import com.oracle.truffle.js.builtins.ArrayPrototypeBuiltins;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.RegExpPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.StringPrototypeBuiltins;
import com.oracle.truffle.js.builtins.helper.IsPristineObjectNode;
import com.oracle.truffle.js.builtins.helper.JSRegExpExecIntlNode;
import com.oracle.truffle.js.builtins.helper.ReplaceStringParser;
import com.oracle.truffle.js.nodes.CompileRegexNode;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.binary.JSIdenticalNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsIntNode;
import com.oracle.truffle.js.nodes.cast.JSToLengthNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.cast.JSToUInt32Node;
import com.oracle.truffle.js.nodes.cast.LongToIntOrDoubleNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.builtins.JSRegExpObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;
import com.oracle.truffle.js.runtime.util.StringBuilderProfile;
import com.oracle.truffle.js.runtime.util.TRegexUtil;
import com.oracle.truffle.js.runtime.util.TRegexUtilFactory;
import java.util.EnumSet;

public final class RegExpPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<RegExpPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new RegExpPrototypeBuiltins();

    protected RegExpPrototypeBuiltins() {
        super(JSRegExp.PROTOTYPE_NAME, RegExpPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, RegExpPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                if (context.getEcmaScriptVersion() >= 6) {
                    return RegExpPrototypeBuiltinsFactory.JSRegExpExecNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                return RegExpPrototypeBuiltinsFactory.JSRegExpExecES5NodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 1: {
                if (context.getEcmaScriptVersion() >= 6) {
                    return RegExpPrototypeBuiltinsFactory.JSRegExpTestNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                return RegExpPrototypeBuiltinsFactory.JSRegExpTestES5NodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 2: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpToStringNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case 3: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpMatchNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 4: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpReplaceNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 5: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpSearchNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 6: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpSplitNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 7: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpCompileNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 8: {
                return RegExpPrototypeBuiltinsFactory.JSRegExpMatchAllNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 10: {
                return CompiledRegexPatternAccessor.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case 9: {
                return RegExpPrototypeBuiltinsFactory.RegExpFlagsGetterNodeGen.create(context, builtin, RegExpPrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return CompiledRegexFlagPropertyAccessor.create(context, builtin, builtinEnum.name(), RegExpPrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum RegExpPrototype implements BuiltinEnum<RegExpPrototype>
    {
        exec(1),
        test(1),
        toString(0),
        _match(1, Symbol.SYMBOL_MATCH),
        _replace(2, Symbol.SYMBOL_REPLACE),
        _search(1, Symbol.SYMBOL_SEARCH),
        _split(2, Symbol.SYMBOL_SPLIT),
        compile(2),
        _matchAll(1, Symbol.SYMBOL_MATCH_ALL),
        flags(0),
        source(0),
        global(0),
        multiline(0),
        ignoreCase(0),
        sticky(0),
        unicode(0),
        dotAll(0),
        hasIndices(0),
        unicodeSets(0);

        private final int length;
        private final Symbol key;

        private RegExpPrototype(int length) {
            this(length, null);
        }

        private RegExpPrototype(int length, Symbol symbol) {
            this.length = length;
            this.key = symbol;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isAnnexB() {
            return this == compile;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.range(flags, unicodeSets).contains(this);
        }

        @Override
        public int getECMAScriptVersion() {
            return switch (this.ordinal()) {
                case 3, 4, 5, 6 -> 6;
                case 8 -> 11;
                case 14, 15 -> 6;
                case 16 -> 9;
                case 17 -> 13;
                case 18 -> 15;
                default -> BuiltinEnum.super.getECMAScriptVersion();
            };
        }

        @Override
        public Object getKey() {
            return this.key != null ? this.key : BuiltinEnum.super.getKey();
        }
    }

    public static abstract class JSRegExpExecNode
    extends JSBuiltinNode {
        @Node.Child
        private JSRegExpExecIntlNode.JSRegExpExecBuiltinNode regExpNode;

        JSRegExpExecNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            assert (context.getEcmaScriptVersion() >= 6);
            this.regExpNode = JSRegExpExecIntlNode.JSRegExpExecBuiltinNode.create(context);
        }

        @Specialization
        Object doString(JSRegExpObject thisRegExp, TruffleString inputStr) {
            return this.regExpNode.execute(thisRegExp, inputStr);
        }

        @Specialization(replaces={"doString"})
        Object doObject(JSRegExpObject thisRegExp, Object input, @Cached JSToStringNode toStringNode) {
            return this.regExpNode.execute(thisRegExp, toStringNode.executeString(input));
        }

        @Fallback
        Object doNoRegExp(Object thisObj, Object input) {
            throw Errors.createTypeErrorNotARegExp(thisObj);
        }
    }

    @ImportStatic(value={JSRegExp.class})
    public static abstract class JSRegExpExecES5Node
    extends JSBuiltinNode {
        protected JSRegExpExecES5Node(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            assert (context.getEcmaScriptVersion() < 6);
        }

        public abstract JSDynamicObject execute(Object var1, Object var2);

        @Specialization
        protected JSDynamicObject exec(JSRegExpObject thisRegExp, Object input, @Bind Node node, @Cached JSToStringNode toStringNode, @Cached(value="create(getContext())") JSRegExpExecIntlNode.JSRegExpExecBuiltinNode regExpNode, @Cached TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached TRegexUtil.InteropReadIntMemberNode readGroupCount, @Cached TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart, @Cached TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd, @Cached TruffleString.SubstringByteIndexNode substringNode, @Cached InlinedCountingConditionProfile ifIsMatch, @Cached(value="create(INDEX, false, getContext(), false)") PropertySetNode setIndexNode, @Cached(value="create(INPUT, false, getContext(), false)") PropertySetNode setInputNode) {
            assert (this.getContext().getEcmaScriptVersion() < 6);
            TruffleString inputStr = toStringNode.executeString(input);
            Object result = regExpNode.execute(thisRegExp, inputStr);
            if (ifIsMatch.profile(node, TRegexUtil.TRegexResultAccessor.isMatch(result, node, readIsMatch))) {
                int groupCount = TRegexUtil.TRegexCompiledRegexAccessor.groupCount(JSRegExp.getCompiledRegex(thisRegExp), node, readGroupCount);
                Object[] matches = TRegexUtil.TRegexMaterializeResult.materializeFull(this.getContext(), result, groupCount, inputStr, node, substringNode, getStart, getEnd);
                JSArrayObject array = JSArray.createConstant(this.getContext(), this.getRealm(), matches);
                setIndexNode.setValueInt(array, TRegexUtil.TRegexResultAccessor.captureGroupStart(result, 0, node, getStart));
                setInputNode.setValue(array, inputStr);
                return array;
            }
            return Null.instance;
        }

        @Fallback
        protected static JSDynamicObject exec(Object thisObj, Object input) {
            throw Errors.createTypeErrorNotARegExp(thisObj);
        }

        @NeverDefault
        static JSRegExpExecES5Node create(JSContext context) {
            return RegExpPrototypeBuiltinsFactory.JSRegExpExecES5NodeGen.create(context, null, null);
        }
    }

    public static abstract class JSRegExpTestNode
    extends JSBuiltinNode {
        protected JSRegExpTestNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            assert (context.getEcmaScriptVersion() >= 6);
        }

        @Specialization
        protected static Object doRegExpString(JSRegExpObject thisObj, TruffleString inputStr, @Cached(value="create(getContext())") @Cached.Shared JSRegExpExecIntlNode regExpNode) {
            Object result = regExpNode.execute(thisObj, inputStr);
            return result != Null.instance;
        }

        @Specialization(guards={"isObjectNode.executeBoolean(thisObj)"}, limit="1", replaces={"doRegExpString"})
        protected static Object doObject(Object thisObj, Object input, @Cached IsJSObjectNode isObjectNode, @Cached JSToStringNode toStringNode, @Cached(value="create(getContext())") @Cached.Shared JSRegExpExecIntlNode regExpNode) {
            TruffleString inputStr = toStringNode.executeString(input);
            Object result = regExpNode.execute(thisObj, inputStr);
            return result != Null.instance;
        }

        @Fallback
        protected final Object doNotObject(Object thisObj, Object input) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }
    }

    public static abstract class JSRegExpTestES5Node
    extends JSBuiltinNode {
        protected JSRegExpTestES5Node(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            assert (context.getEcmaScriptVersion() < 6);
        }

        @Specialization
        protected final Object doRegExp(JSRegExpObject thisObj, Object input, @Cached JSToStringNode toStringNode, @Cached(value="create(getContext())") JSRegExpExecIntlNode regExpNode, @Cached TRegexUtil.InteropReadBooleanMemberNode readIsMatch) {
            TruffleString inputStr = toStringNode.executeString(input);
            Object result = regExpNode.execute(thisObj, inputStr);
            return readIsMatch.execute(this, result, "isMatch");
        }

        @Fallback
        protected final Object doNotRegExp(Object thisObj, Object input) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }
    }

    public static abstract class JSRegExpToStringNode
    extends JSBuiltinNode {
        @Node.Child
        private PropertyGetNode getSourceNode;
        @Node.Child
        private PropertyGetNode getFlagsNode;

        protected JSRegExpToStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getFlagsNode = PropertyGetNode.create(JSRegExp.FLAGS, false, context);
            this.getSourceNode = PropertyGetNode.create(Strings.SOURCE, false, context);
        }

        @Specialization(guards={"isObjectNode.executeBoolean(thisObj)"}, limit="1")
        protected Object toString(JSDynamicObject thisObj, @Cached IsJSObjectNode isObjectNode, @Cached JSToStringNode toString1Node, @Cached JSToStringNode toString2Node) {
            TruffleString source = toString1Node.executeString(this.getSourceNode.getValue((Object)thisObj));
            TruffleString flags = toString2Node.executeString(this.getFlagsNode.getValue((Object)thisObj));
            return JSRegExpToStringNode.toStringIntl(source, flags);
        }

        @Fallback
        protected Object toString(Object thisNonObj) {
            throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.toString", thisNonObj);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object toStringIntl(TruffleString source, TruffleString flags) {
            return Strings.concatAll(Strings.SLASH, source, Strings.SLASH, flags);
        }
    }

    @ImportStatic(value={JSRegExp.class})
    public static abstract class JSRegExpMatchNode
    extends RegExpPrototypeSymbolOperation {
        protected JSRegExpMatchNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isObjectNode.executeBoolean(rx)"}, limit="1")
        protected Object match(JSDynamicObject rx, Object param, @Bind Node node, @Cached IsJSObjectNode isObjectNode, @Cached(value="create(FLAGS, getContext())") PropertyGetNode getFlagsNode, @Cached JSToStringNode toStringNodeForFlags, @Cached TruffleString.ByteIndexOfCodePointNode stringIndexOfNode, @Cached TruffleString.CharIndexOfAnyCharUTF16Node stringIndexOfAnyNode, @Cached JSToStringNode toString1Node, @Cached JSToStringNode toString2Node, @Cached JSToLengthNode toLengthNode, @Cached InlinedConditionProfile isGlobal, @Cached AdvanceStringIndexNode advanceStringIndex, @Cached InlinedBranchProfile lastIndexNotIntBranch) {
            TruffleString s = toString1Node.executeString(param);
            TruffleString flags = toStringNodeForFlags.executeString(getFlagsNode.getValue((Object)rx));
            if (isGlobal.profile(node, Strings.indexOf(stringIndexOfNode, flags, 103) == -1)) {
                return this.regexExecIntl((Object)rx, s);
            }
            boolean fullUnicode = Strings.indexOfAny(stringIndexOfAnyNode, flags, 'u', 'v') != -1;
            this.setLastIndex((Object)rx, 0);
            JSArrayObject array = JSArray.createEmptyZeroLength(this.getContext(), this.getRealm());
            int n = 0;
            JSDynamicObject result;
            while ((result = (JSDynamicObject)((Object)this.regexExecIntl((Object)rx, s))) != Null.instance) {
                TruffleString matchStr = toString2Node.executeString(this.read((Object)result, 0L));
                this.write(array, n, matchStr);
                if (Strings.isEmpty(matchStr)) {
                    this.advanceLastIndexAfterEmptyMatch((Object)rx, s, fullUnicode, node, toLengthNode, advanceStringIndex, lastIndexNotIntBranch);
                }
                ++n;
            }
            return n == 0 ? Null.instance : array;
        }

        @Fallback
        protected static Object match(Object thisObj, Object string) {
            throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.@@match", thisObj);
        }
    }

    public static abstract class JSRegExpReplaceNode
    extends RegExpPrototypeSymbolOperation
    implements ReplaceStringConsumerTRegex.ParentNode {
        @Node.Child
        private JSToStringNode toString2Node;
        @Node.Child
        private JSToStringNode toString3Node;
        @Node.Child
        private JSToStringNode toString4Node;
        @Node.Child
        private IsJSObjectNode isObjectNode;
        @Node.Child
        private IsCallableNode isCallableNode;
        @Node.Child
        private ReadElementNode readNamedCaptureGroupNode;
        @Node.Child
        private JSToObjectNode toObjectNode;
        @Node.Child
        private IsPristineObjectNode isPristineObjectNode;
        @Node.Child
        private TruffleStringBuilder.AppendStringNode appendStringNode;
        @Node.Child
        private TruffleStringBuilder.AppendSubstringByteIndexNode appendSubStringNode;
        @Node.Child
        private TruffleStringBuilder.ToStringNode builderToStringNode;
        final StringBuilderProfile stringBuilderProfile;
        final BranchProfile invalidGroupNumberProfile = BranchProfile.create();
        @Node.Child
        private TRegexUtil.InvokeGetGroupBoundariesMethodNode getStartNode = TRegexUtil.InvokeGetGroupBoundariesMethodNode.create();
        @Node.Child
        private TRegexUtil.InvokeGetGroupBoundariesMethodNode getEndNode = TRegexUtil.InvokeGetGroupBoundariesMethodNode.create();
        @Node.Child
        private TRegexUtil.InteropReadMemberNode readGroupsNode = TRegexUtil.InteropReadMemberNode.create();
        @Node.Child
        private InteropLibrary namedCaptureGroupInterop = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
        @Node.Child
        private InteropLibrary groupIndicesInterop = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
        @Node.Child
        private TRegexUtil.InteropToIntNode toIntNode = TRegexUtilFactory.InteropToIntNodeGen.create();

        JSRegExpReplaceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.isObjectNode = IsJSObjectNode.create();
            this.isCallableNode = IsCallableNode.create();
            this.stringBuilderProfile = StringBuilderProfile.create(context.getStringLengthLimit());
        }

        @Specialization(guards={"stringEquals(equalsNode, cachedReplaceValue, replaceValue)"}, limit="1")
        protected Object replaceStringCached(JSDynamicObject rx, Object searchValue, TruffleString replaceValue, @Cached(value="replaceValue") TruffleString cachedReplaceValue, @Cached(value="parseReplaceValueWithNCG(replaceValue)", dimensions=1) ReplaceStringParser.Token[] cachedParsedReplaceValueWithNamedCG, @Cached(value="parseReplaceValueWithoutNCG(replaceValue)", dimensions=1) ReplaceStringParser.Token[] cachedParsedReplaceValueWithoutNamedCG, @Cached.Shared @Cached JSToStringNode toString1Node, @Cached TruffleString.EqualNode equalsNode, @Cached @Cached.Shared ReplaceInternalNode replaceInternal, @Cached @Cached.Shared ReplaceAccordingToSpecNode replaceAccordingToSpec) {
            this.checkObject(rx);
            TruffleString searchString = toString1Node.executeString(searchValue);
            if (this.isPristine(rx)) {
                return replaceInternal.execute((JSRegExpObject)rx, searchString, cachedReplaceValue, cachedParsedReplaceValueWithNamedCG, cachedParsedReplaceValueWithoutNamedCG, this.getContext(), this);
            }
            return replaceAccordingToSpec.execute(rx, searchString, cachedReplaceValue, false, this.getContext(), this);
        }

        @Specialization(replaces={"replaceStringCached"})
        protected Object replaceString(JSDynamicObject rx, Object searchValue, TruffleString replaceValue, @Cached.Shared @Cached JSToStringNode toString1Node, @Cached @Cached.Shared ReplaceInternalNode replaceInternal, @Cached @Cached.Shared ReplaceAccordingToSpecNode replaceAccordingToSpec) {
            this.checkObject(rx);
            TruffleString searchString = toString1Node.executeString(searchValue);
            if (this.isPristine(rx)) {
                return replaceInternal.execute((JSRegExpObject)rx, searchString, replaceValue, null, null, this.getContext(), this);
            }
            return replaceAccordingToSpec.execute(rx, searchString, replaceValue, false, this.getContext(), this);
        }

        @Specialization(replaces={"replaceString"})
        protected Object replaceDynamic(JSDynamicObject rx, Object searchValue, Object replaceValue, @Cached.Shared @Cached JSToStringNode toString1Node, @Cached @Cached.Shared ReplaceInternalNode replaceInternal, @Cached @Cached.Shared ReplaceAccordingToSpecNode replaceAccordingToSpec, @Cached InlinedConditionProfile functionalReplaceProfile) {
            Object replaceVal;
            this.checkObject(rx);
            TruffleString searchString = toString1Node.executeString(searchValue);
            boolean functionalReplace = functionalReplaceProfile.profile((Node)this, this.isCallableNode.executeBoolean(replaceValue));
            if (functionalReplace) {
                replaceVal = replaceValue;
            } else {
                TruffleString replaceString = this.toString2(replaceValue);
                replaceVal = replaceString;
                if (this.isPristine(rx)) {
                    return replaceInternal.execute((JSRegExpObject)rx, searchString, replaceString, null, null, this.getContext(), this);
                }
            }
            return replaceAccordingToSpec.execute(rx, searchString, replaceVal, functionalReplace, this.getContext(), this);
        }

        @Fallback
        protected Object doNoObject(Object rx, Object searchString, Object replaceValue) {
            throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.@@replace", rx);
        }

        private void checkObject(JSDynamicObject rx) {
            if (!this.isObjectNode.executeBoolean((Object)rx)) {
                throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.@@replace", (Object)rx);
            }
        }

        ReplaceStringParser.Token[] parseReplaceValueWithNCG(TruffleString replaceValue) {
            return this.parseReplaceValue(replaceValue, true);
        }

        ReplaceStringParser.Token[] parseReplaceValueWithoutNCG(TruffleString replaceValue) {
            return this.parseReplaceValue(replaceValue, false);
        }

        ReplaceStringParser.Token[] parseReplaceValue(TruffleString replaceValue, boolean parseNamedCG) {
            return ReplaceStringParser.parse(this.getContext(), replaceValue, 100, parseNamedCG);
        }

        private TruffleString toString2(Object obj) {
            if (this.toString2Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toString2Node = (JSToStringNode)this.insert(JSToStringNode.create());
            }
            return this.toString2Node.executeString(obj);
        }

        private TruffleString toString3(Object obj) {
            if (this.toString3Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toString3Node = (JSToStringNode)this.insert(JSToStringNode.create());
            }
            return this.toString3Node.executeString(obj);
        }

        final TruffleString toString4(Object obj) {
            if (this.toString4Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toString4Node = (JSToStringNode)this.insert(JSToStringNode.create());
            }
            return this.toString4Node.executeString(obj);
        }

        private boolean isPristine(JSDynamicObject rx) {
            if (this.isPristineObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isPristineObjectNode = (IsPristineObjectNode)this.insert(IsPristineObjectNode.createRegExpExecAndMatch(this.getContext()));
            }
            return this.isPristineObjectNode.execute(rx);
        }

        final Object readNamedCaptureGroup(Object namedCaptureGroups, Object groupNameStr) {
            if (this.readNamedCaptureGroupNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readNamedCaptureGroupNode = (ReadElementNode)this.insert(ReadElementNode.create(this.getContext()));
            }
            return this.readNamedCaptureGroupNode.executeWithTargetAndIndex(namedCaptureGroups, groupNameStr);
        }

        private Object toObject(Object obj) {
            if (this.toObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toObjectNode = (JSToObjectNode)this.insert(JSToObjectNode.create());
            }
            return this.toObjectNode.execute(obj);
        }

        @Override
        public void append(TruffleStringBuilderUTF16 sb, TruffleString s) {
            if (this.appendStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.appendStringNode = (TruffleStringBuilder.AppendStringNode)this.insert((Node)TruffleStringBuilder.AppendStringNode.create());
            }
            this.stringBuilderProfile.append(this.appendStringNode, sb, s);
        }

        @Override
        public void append(TruffleStringBuilderUTF16 sb, TruffleString s, int fromIndex, int toIndex) {
            if (this.appendSubStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.appendSubStringNode = (TruffleStringBuilder.AppendSubstringByteIndexNode)this.insert((Node)TruffleStringBuilder.AppendSubstringByteIndexNode.create());
            }
            this.stringBuilderProfile.append(this.appendSubStringNode, sb, s, fromIndex, toIndex);
        }

        private TruffleString builderToString(TruffleStringBuilderUTF16 sb) {
            if (this.builderToStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.builderToStringNode = (TruffleStringBuilder.ToStringNode)this.insert((Node)TruffleStringBuilder.ToStringNode.create());
            }
            return StringBuilderProfile.toString(this.builderToStringNode, sb);
        }

        @Override
        public BranchProfile getInvalidGroupNumberProfile() {
            return this.invalidGroupNumberProfile;
        }

        @Override
        public TRegexUtil.InvokeGetGroupBoundariesMethodNode getGetStartNode() {
            return this.getStartNode;
        }

        @Override
        public TRegexUtil.InvokeGetGroupBoundariesMethodNode getGetEndNode() {
            return this.getEndNode;
        }

        @ImportStatic(value={JSRegExp.class})
        protected static abstract class ReplaceInternalNode
        extends JavaScriptBaseNode {
            protected ReplaceInternalNode() {
            }

            protected abstract TruffleString execute(JSRegExpObject var1, TruffleString var2, TruffleString var3, ReplaceStringParser.Token[] var4, ReplaceStringParser.Token[] var5, JSContext var6, JSRegExpReplaceNode var7);

            @Specialization(guards={"getCompiledRegex(rx) == tRegexCompiledRegex"}, limit="1")
            protected static TruffleString doCached(JSRegExpObject rx, TruffleString s, TruffleString replaceString, ReplaceStringParser.Token[] parsedWithNamedCG, ReplaceStringParser.Token[] parsedWithoutNamedCG, JSContext context, JSRegExpReplaceNode parent, @Bind Node node, @Cached(value="getCompiledRegex(rx)") Object tRegexCompiledRegex, @Cached(value="create(context, false)") @Cached.Shared JSRegExpExecIntlNode.JSRegExpExecIntlIgnoreLastIndexNode execIgnoreLastIndexNode, @Cached @Cached.Shared AdvanceStringIndexNode advanceStringIndex, @Cached @Cached.Shared JSToLengthNode toLength, @Cached @Cached.Shared InlinedConditionProfile globalProfile, @Cached @Cached.Shared InlinedConditionProfile stickyProfile, @Cached @Cached.Shared InlinedConditionProfile noMatchProfile, @Cached @Cached.Shared InlinedConditionProfile hasNamedCaptureGroupsProfile, @Cached @Cached.Shared InlinedBranchProfile dollarProfile, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readGlobal, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readSticky, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readUnicode, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readUnicodeSets, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached @Cached.Shared TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart, @Cached @Cached.Shared TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd, @Cached @Cached.Shared TRegexUtil.InteropReadMemberNode readFlags, @Cached @Cached.Shared TRegexUtil.InteropReadMemberNode readGroups, @Cached @Cached.Shared TRegexUtil.InteropReadIntMemberNode readGroupCount) {
                Object tRegexResult;
                long lastIndex;
                Object tRegexFlags = TRegexUtil.TRegexCompiledRegexAccessor.flags(tRegexCompiledRegex, node, readFlags);
                boolean global = globalProfile.profile(node, TRegexUtil.TRegexFlagsAccessor.global(tRegexFlags, node, readGlobal));
                boolean eitherUnicode = TRegexUtil.TRegexFlagsAccessor.unicode(tRegexFlags, node, readUnicode) || TRegexUtil.TRegexFlagsAccessor.unicodeSets(tRegexFlags, node, readUnicodeSets);
                boolean sticky = stickyProfile.profile(node, TRegexUtil.TRegexFlagsAccessor.sticky(tRegexFlags, node, readSticky));
                int length = Strings.length(s);
                TruffleStringBuilderUTF16 sb = parent.stringBuilderProfile.newStringBuilder(length + 16);
                int lastMatchEnd = 0;
                int matchStart = -1;
                if (global) {
                    lastIndex = 0L;
                } else {
                    lastIndex = toLength.executeLong(parent.getLastIndex(rx));
                    if (!sticky) {
                        lastIndex = 0L;
                    }
                }
                Object lastRegexResult = null;
                while (lastIndex <= (long)length && !noMatchProfile.profile(node, !TRegexUtil.TRegexResultAccessor.isMatch(tRegexResult = execIgnoreLastIndexNode.execute(rx, s, lastIndex), node, readIsMatch))) {
                    if (!context.getRegExpStaticResultUnusedAssumption().isValid()) {
                        lastRegexResult = tRegexResult;
                    }
                    matchStart = TRegexUtil.TRegexResultAccessor.captureGroupStart(tRegexResult, 0, node, getStart);
                    int matchEnd = TRegexUtil.TRegexResultAccessor.captureGroupEnd(tRegexResult, 0, node, getEnd);
                    assert (matchStart >= 0 && matchStart <= length && matchStart >= lastMatchEnd);
                    parent.append(sb, s, lastMatchEnd, matchStart);
                    Object namedCG = TRegexUtil.TRegexCompiledRegexAccessor.namedCaptureGroups(tRegexCompiledRegex, node, readGroups);
                    boolean hasNamedCG = hasNamedCaptureGroupsProfile.profile(node, !parent.namedCaptureGroupInterop.isNull(namedCG));
                    int groupCount = TRegexUtil.TRegexCompiledRegexAccessor.groupCount(tRegexCompiledRegex, node, readGroupCount);
                    if (parsedWithNamedCG == null) {
                        ReplaceStringParser.process(context, replaceString, groupCount, hasNamedCG, new ReplaceStringConsumerTRegex(sb, s, replaceString, matchStart, matchEnd, tRegexResult, tRegexCompiledRegex, groupCount), parent, node, dollarProfile);
                    } else {
                        ReplaceStringParser.processParsed(hasNamedCG ? parsedWithNamedCG : parsedWithoutNamedCG, new ReplaceStringConsumerTRegex(sb, s, replaceString, matchStart, matchEnd, tRegexResult, tRegexCompiledRegex, groupCount), parent);
                    }
                    lastMatchEnd = matchEnd;
                    if (!global) break;
                    if (matchStart == matchEnd) {
                        lastIndex = advanceStringIndex.execute(node, s, matchEnd, eitherUnicode);
                        continue;
                    }
                    lastIndex = matchEnd;
                }
                if (global || sticky) {
                    parent.setLastIndex((Object)rx, global ? 0 : lastMatchEnd);
                }
                if (matchStart < 0) {
                    assert (lastMatchEnd == 0 && sb.isEmpty());
                    return s;
                }
                if (context.isOptionRegexpStaticResult()) {
                    JSRealm.get(node).setStaticRegexResult(context, tRegexCompiledRegex, s, matchStart, lastRegexResult);
                }
                if (lastMatchEnd < length) {
                    parent.append(sb, s, lastMatchEnd, length);
                }
                return parent.builderToString(sb);
            }

            @Specialization(replaces={"doCached"})
            protected static TruffleString doUncached(JSRegExpObject rx, TruffleString s, TruffleString replaceString, ReplaceStringParser.Token[] parsedWithNamedCG, ReplaceStringParser.Token[] parsedWithoutNamedCG, JSContext context, JSRegExpReplaceNode parent, @Bind Node node, @Cached(value="create(context, false)") @Cached.Shared JSRegExpExecIntlNode.JSRegExpExecIntlIgnoreLastIndexNode execIgnoreLastIndexNode, @Cached @Cached.Shared AdvanceStringIndexNode advanceStringIndex, @Cached @Cached.Shared JSToLengthNode toLength, @Cached @Cached.Shared InlinedConditionProfile globalProfile, @Cached @Cached.Shared InlinedConditionProfile stickyProfile, @Cached @Cached.Shared InlinedConditionProfile noMatchProfile, @Cached @Cached.Shared InlinedConditionProfile hasNamedCaptureGroupsProfile, @Cached @Cached.Shared InlinedBranchProfile dollarProfile, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readGlobal, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readSticky, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readUnicode, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readUnicodeSets, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached @Cached.Shared TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart, @Cached @Cached.Shared TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd, @Cached @Cached.Shared TRegexUtil.InteropReadMemberNode readFlags, @Cached @Cached.Shared TRegexUtil.InteropReadMemberNode readGroups, @Cached @Cached.Shared TRegexUtil.InteropReadIntMemberNode readGroupCount) {
                return ReplaceInternalNode.doCached(rx, s, replaceString, parsedWithNamedCG, parsedWithoutNamedCG, context, parent, node, JSRegExp.getCompiledRegex(rx), execIgnoreLastIndexNode, advanceStringIndex, toLength, globalProfile, stickyProfile, noMatchProfile, hasNamedCaptureGroupsProfile, dollarProfile, readGlobal, readSticky, readUnicode, readUnicodeSets, readIsMatch, getStart, getEnd, readFlags, readGroups, readGroupCount);
            }
        }

        @ImportStatic(value={JSRegExp.class, JSConfig.class, JSAbstractArray.class})
        protected static abstract class ReplaceAccordingToSpecNode
        extends JavaScriptBaseNode {
            protected ReplaceAccordingToSpecNode() {
            }

            protected abstract TruffleString execute(JSDynamicObject var1, TruffleString var2, Object var3, boolean var4, JSContext var5, JSRegExpReplaceNode var6);

            @Specialization
            protected static TruffleString replaceAccordingToSpec(JSDynamicObject rx, TruffleString s, Object replaceValue, boolean functionalReplace, JSContext context, JSRegExpReplaceNode parent, @Bind Node node, @Cached AdvanceStringIndexNode advanceStringIndex, @Cached JSToLengthNode toLength, @Cached JSToIntegerAsIntNode toIntegerNode, @Cached JSToStringNode toStringForFlagsNode, @Cached TruffleString.ByteIndexOfCodePointNode indexOfNode, @Cached TruffleString.CharIndexOfAnyCharUTF16Node indexOfAnyNode, @Cached(value="create(LENGTH, context)") PropertyGetNode getLength, @Cached(value="create(INDEX, context)") PropertyGetNode getIndexNode, @Cached(value="create(GROUPS, context)") PropertyGetNode getGroupsNode, @Cached(value="create(FLAGS, context)") PropertyGetNode getFlagsNode, @CachedLibrary(limit="InteropLibraryLimit") DynamicObjectLibrary getLazyRegexResult, @Cached(value="create(LAZY_REGEX_RESULT_ID)") HasHiddenKeyCacheNode hasLazyRegexResult, @Cached(value="createCall()") JSFunctionCallNode callFunction, @Cached InlinedBranchProfile growProfile, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile unicodeProfile, @Cached InlinedConditionProfile globalProfile, @Cached InlinedConditionProfile noMatchProfile, @Cached InlinedConditionProfile lazyResultArrayProfile, @Cached InlinedConditionProfile validPositionProfile, @Cached InlinedBranchProfile dollarProfile, @Cached InlinedBranchProfile lastIndexNotIntBranch) {
                TruffleString replaceString = null;
                Object replaceFunction = null;
                if (functionalReplace) {
                    replaceFunction = replaceValue;
                } else {
                    replaceString = (TruffleString)replaceValue;
                }
                TruffleString flags = toStringForFlagsNode.executeString(getFlagsNode.getValue((Object)rx));
                boolean global = globalProfile.profile(node, Strings.indexOf(indexOfNode, flags, 103) != -1);
                boolean fullUnicode = false;
                if (global) {
                    fullUnicode = unicodeProfile.profile(node, Strings.indexOfAny(indexOfAnyNode, flags, 'u', 'v') != -1);
                    parent.setLastIndex((Object)rx, 0);
                }
                SimpleArrayList<Object> results = new SimpleArrayList<Object>();
                int lengthS = Strings.length(s);
                TruffleStringBuilderUTF16 sb = parent.stringBuilderProfile.newStringBuilder(lengthS + 16);
                int nextSourcePosition = 0;
                int matchLength = -1;
                while (true) {
                    Object result;
                    if (noMatchProfile.profile(node, (result = parent.regexExecIntl((Object)rx, s)) == Null.instance)) {
                        if (matchLength >= 0) break;
                        return s;
                    }
                    results.add(result, node, growProfile);
                    if (!global) break;
                    matchLength = lazyResultArrayProfile.profile(node, ReplaceAccordingToSpecNode.isLazyResultArray(result, hasLazyRegexResult)) ? ReplaceAccordingToSpecNode.getLazyResultLength(result, 0, getLazyRegexResult, parent) : Strings.length(ReplaceAccordingToSpecNode.readCaptureGroup0(result, parent));
                    if (matchLength != 0) continue;
                    parent.advanceLastIndexAfterEmptyMatch((Object)rx, s, fullUnicode, node, toLength, advanceStringIndex, lastIndexNotIntBranch);
                }
                for (int i = 0; i < results.size(); ++i) {
                    boolean hasNamedCG;
                    Object result = results.get(i);
                    int resultLength = ReplaceAccordingToSpecNode.toSafeArrayLength(toLength.executeLong(getLength.getValue(result)), node, errorBranch);
                    int groupCount = Math.max(resultLength, 1);
                    Object[] captures = new Object[groupCount];
                    TruffleString matched = ReplaceAccordingToSpecNode.readCaptureGroup0(result, parent);
                    captures[0] = matched;
                    matchLength = Strings.length(matched);
                    int position = Math.max(Math.min(toIntegerNode.executeInt(getIndexNode.getValue(result)), lengthS), 0);
                    for (int n = 1; n < groupCount; ++n) {
                        captures[n] = ReplaceAccordingToSpecNode.readCaptureGroupN(result, n, parent);
                    }
                    Object namedCaptures = getGroupsNode.getValue(result);
                    boolean bl = hasNamedCG = namedCaptures != Undefined.instance;
                    if (functionalReplace) {
                        int replacerArgsCount = groupCount + 2 + (hasNamedCG ? 1 : 0);
                        if ((long)replacerArgsCount > context.getFunctionArgumentsLimit()) {
                            errorBranch.enter(node);
                            throw Errors.createRangeErrorTooManyArguments();
                        }
                        Object[] arguments = JSArguments.createInitial((Object)Undefined.instance, replaceFunction, replacerArgsCount);
                        JSArguments.setUserArguments(arguments, 0, captures);
                        JSArguments.setUserArgument(arguments, groupCount, position);
                        JSArguments.setUserArgument(arguments, groupCount + 1, s);
                        if (hasNamedCG) {
                            JSArguments.setUserArgument(arguments, groupCount + 2, namedCaptures);
                        }
                        Object callResult = callFunction.executeCall(arguments);
                        TruffleString replacement = parent.toString2(callResult);
                        if (!validPositionProfile.profile(node, position >= nextSourcePosition)) continue;
                        parent.append(sb, s, nextSourcePosition, position);
                        parent.append(sb, replacement);
                        nextSourcePosition = position + matchLength;
                        continue;
                    }
                    if (hasNamedCG) {
                        namedCaptures = parent.toObject(namedCaptures);
                    }
                    if (!validPositionProfile.profile(node, position >= nextSourcePosition)) continue;
                    parent.append(sb, s, nextSourcePosition, position);
                    int matchEnd = Math.min(position + matchLength, lengthS);
                    ReplaceStringParser.process(context, replaceString, groupCount, hasNamedCG, new ReplaceStringConsumer(sb, s, replaceString, position, matchEnd, captures, namedCaptures), parent, node, dollarProfile);
                    nextSourcePosition = position + matchLength;
                }
                if (nextSourcePosition < lengthS) {
                    parent.append(sb, s, nextSourcePosition, lengthS);
                }
                return parent.builderToString(sb);
            }

            private static boolean isLazyResultArray(Object result, HasHiddenKeyCacheNode hasLazyRegexResultNode) {
                JSObject jso;
                boolean isLazyResultArray = hasLazyRegexResultNode.executeHasHiddenKey(result);
                assert (isLazyResultArray == (result instanceof JSObject && JSDynamicObject.hasProperty(jso = (JSObject)((Object)result), JSArray.LAZY_REGEX_RESULT_ID)));
                return isLazyResultArray;
            }

            private static int getLazyResultLength(Object obj, int groupNumber, DynamicObjectLibrary lazyRegexResultNode, JSRegExpReplaceNode parent) {
                Object regexResult = JSAbstractArray.arrayGetRegexResult((JSArrayObject)obj, lazyRegexResultNode);
                return TRegexUtil.TRegexResultAccessor.captureGroupLength(regexResult, groupNumber, null, parent.getStartNode, parent.getEndNode);
            }

            private static TruffleString readCaptureGroup0(Object result, JSRegExpReplaceNode parent) {
                return parent.toString3(parent.read(result, 0L));
            }

            private static Object readCaptureGroupN(Object result, int groupNumber, JSRegExpReplaceNode parent) {
                assert (groupNumber != 0);
                Object value = parent.read(result, groupNumber);
                if (value == Undefined.instance) {
                    return value;
                }
                return parent.toString3(value);
            }

            private static int toSafeArrayLength(long length, Node node, InlinedBranchProfile errorBranch) {
                assert (length >= 0L) : length;
                if (length > 0x7FFFFFF7L) {
                    errorBranch.enter(node);
                    throw Errors.outOfMemoryError();
                }
                return (int)length;
            }
        }
    }

    public static abstract class JSRegExpSearchNode
    extends RegExpPrototypeSymbolOperation {
        @Node.Child
        private PropertyGetNode getIndexNode;
        @Node.Child
        private JSIdenticalNode sameValueNode;

        protected JSRegExpSearchNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getIndexNode = PropertyGetNode.create(JSRegExp.INDEX, false, context);
            this.sameValueNode = JSIdenticalNode.createSameValue();
        }

        @Specialization(guards={"isObjectNode.executeBoolean(rx)"}, limit="1")
        protected Object search(JSDynamicObject rx, Object param, @Cached IsJSObjectNode isObjectNode, @Cached JSToStringNode toString1Node) {
            TruffleString s = toString1Node.executeString(param);
            Object previousLastIndex = this.getLastIndex((Object)rx);
            if (!this.sameValueNode.executeBoolean(previousLastIndex, 0)) {
                this.setLastIndex((Object)rx, 0);
            }
            Object result = this.regexExecIntl((Object)rx, s);
            Object currentLastIndex = this.getLastIndex((Object)rx);
            if (!this.sameValueNode.executeBoolean(currentLastIndex, previousLastIndex)) {
                this.setLastIndex((Object)rx, previousLastIndex);
            }
            return result == Null.instance ? Integer.valueOf(-1) : this.getIndexNode.getValue(result);
        }

        @Fallback
        protected Object search(Object thisObj, Object string) {
            throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.@@search", thisObj);
        }
    }

    @ImportStatic(value={JSGuards.class})
    public static abstract class JSRegExpSplitNode
    extends RegExpPrototypeSymbolOperation {
        @Node.Child
        private IsJSObjectNode isObjectNode;
        @Node.Child
        private JSToStringNode toString1Node;
        @Node.Child
        private IsPristineObjectNode isPristineObjectNode;

        JSRegExpSplitNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        JSArrayObject splitIntLimit(JSDynamicObject rx, Object input, int limit, @Cached @Cached.Shared JSToUInt32Node toUInt32, @Cached @Cached.Shared InlinedBranchProfile limitZeroBranch, @Cached @Cached.Shared SplitInternalNode splitInternal, @Cached @Cached.Shared SplitAccordingToSpecNode splitAccordingToSpec) {
            return this.doSplit(rx, input, toUInt32.executeLong(limit), this, limitZeroBranch, splitInternal, splitAccordingToSpec);
        }

        @Specialization
        JSArrayObject splitLongLimit(JSDynamicObject rx, Object input, long limit, @Cached @Cached.Shared JSToUInt32Node toUInt32, @Cached @Cached.Shared InlinedBranchProfile limitZeroBranch, @Cached @Cached.Shared SplitInternalNode splitInternal, @Cached @Cached.Shared SplitAccordingToSpecNode splitAccordingToSpec) {
            return this.doSplit(rx, input, toUInt32.executeLong(limit), this, limitZeroBranch, splitInternal, splitAccordingToSpec);
        }

        @Specialization(guards={"isUndefined(limit)"})
        JSArrayObject splitUndefinedLimit(JSDynamicObject rx, Object input, Object limit, @Cached @Cached.Shared InlinedBranchProfile limitZeroBranch, @Cached @Cached.Shared SplitInternalNode splitInternal, @Cached @Cached.Shared SplitAccordingToSpecNode splitAccordingToSpec) {
            return this.doSplit(rx, input, JSRuntime.MAX_SAFE_INTEGER_LONG, this, limitZeroBranch, splitInternal, splitAccordingToSpec);
        }

        @Specialization(guards={"!isUndefined(limit)"})
        JSArrayObject splitObjectLimit(JSDynamicObject rx, Object input, Object limit, @Cached @Cached.Shared SplitAccordingToSpecNode splitAccordingToSpec) {
            this.checkObject(rx);
            TruffleString str = this.toString1(input);
            Object constructor = this.getSpeciesConstructor(rx);
            return splitAccordingToSpec.execute(rx, str, limit, constructor, this.getContext(), this);
        }

        @Fallback
        static Object doNoObject(Object rx, Object input, Object flags) {
            throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.@@split", rx);
        }

        private JSArrayObject doSplit(JSDynamicObject rx, Object input, long limit, Node node, InlinedBranchProfile limitZeroBranch, SplitInternalNode splitInternal, SplitAccordingToSpecNode splitAccordingToSpec) {
            this.checkObject(rx);
            TruffleString str = this.toString1(input);
            if (limit == 0L) {
                limitZeroBranch.enter(node);
                return JSArray.createEmptyZeroLength(this.getContext(), this.getRealm());
            }
            Object constructor = this.getSpeciesConstructor(rx);
            if (constructor == this.getRealm().getRegExpConstructor() && this.isPristine(rx)) {
                return splitInternal.execute((JSRegExpObject)rx, str, limit, this.getContext(), this);
            }
            return splitAccordingToSpec.execute(rx, str, limit, constructor, this.getContext(), this);
        }

        private void checkObject(JSDynamicObject rx) {
            if (!this.isJSObject(rx)) {
                throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.@@split", (Object)rx);
            }
        }

        private Object getSpeciesConstructor(JSDynamicObject rx) {
            JSFunctionObject regexpConstructor = this.getRealm().getRegExpConstructor();
            return this.getArraySpeciesConstructorNode().speciesConstructor(rx, regexpConstructor);
        }

        static Object callRegExpConstructor(Object constructor, JSDynamicObject rx, TruffleString newFlags, JSFunctionCallNode constructorCall) {
            return constructorCall.executeCall(JSArguments.create((Object)JSFunction.CONSTRUCT, constructor, new Object[]{rx, newFlags}));
        }

        private boolean isJSObject(JSDynamicObject rx) {
            if (this.isObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isObjectNode = (IsJSObjectNode)this.insert(IsJSObjectNode.create());
            }
            return this.isObjectNode.executeBoolean((Object)rx);
        }

        private TruffleString toString1(Object obj) {
            if (this.toString1Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toString1Node = (JSToStringNode)this.insert(JSToStringNode.create());
            }
            return this.toString1Node.executeString(obj);
        }

        private boolean isPristine(JSDynamicObject rx) {
            if (this.isPristineObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isPristineObjectNode = (IsPristineObjectNode)this.insert(IsPristineObjectNode.createRegExpExecAndMatch(this.getContext()));
            }
            return this.isPristineObjectNode.execute(rx);
        }

        @ImportStatic(value={JSRegExp.class})
        protected static abstract class SplitInternalNode
        extends JavaScriptBaseNode {
            protected SplitInternalNode() {
            }

            protected abstract JSArrayObject execute(JSRegExpObject var1, TruffleString var2, long var3, JSContext var5, JSRegExpSplitNode var6);

            @Specialization(guards={"getCompiledRegex(rx) == tRegexCompiledRegex"}, limit="1")
            protected static JSArrayObject doCached(JSRegExpObject rx, TruffleString str, long lim, JSContext context, JSRegExpSplitNode parent, @Bind Node node, @Cached(value="getCompiledRegex(rx)") Object tRegexCompiledRegex, @Cached @Cached.Shared TRegexUtil.InteropReadMemberNode readFlags, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readSticky, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readUnicode, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readUnicodeSets, @Cached @Cached.Shared RemoveStickyFlagNode removeStickyFlag, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached @Cached.Shared TRegexUtil.InteropReadIntMemberNode readGroupCount, @Cached @Cached.Shared TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart, @Cached @Cached.Shared TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd, @Cached(value="createNew()") @Cached.Shared JSFunctionCallNode constructorCall, @Cached(value="create(context, false)") @Cached.Shared JSRegExpExecIntlNode.JSRegExpExecIntlIgnoreLastIndexNode execIgnoreLastIndex, @Cached @Cached.Shared TruffleString.SubstringByteIndexNode substringNode, @Cached @Cached.Shared AdvanceStringIndexNode advanceStringIndex, @Cached @Cached.Shared InlinedConditionProfile sizeIsZero, @Cached @Cached.Shared InlinedConditionProfile resultIsNull, @Cached @Cached.Shared InlinedConditionProfile stickyFlagSet, @Cached @Cached.Shared InlinedBranchProfile prematureReturnBranch) {
                JSRegExpObject splitter;
                Object tRegexFlags = TRegexUtil.TRegexCompiledRegexAccessor.flags(tRegexCompiledRegex, node, readFlags);
                boolean unicodeMatching = TRegexUtil.TRegexFlagsAccessor.unicode(tRegexFlags, node, readUnicode) || TRegexUtil.TRegexFlagsAccessor.unicodeSets(tRegexFlags, node, readUnicodeSets);
                JSRealm realm = JSRealm.get(node);
                if (stickyFlagSet.profile(node, TRegexUtil.TRegexFlagsAccessor.sticky(tRegexFlags, node, readSticky))) {
                    JSFunctionObject regexpConstructor = realm.getRegExpConstructor();
                    TruffleString newFlags = removeStickyFlag.execute(node, tRegexFlags);
                    splitter = (JSRegExpObject)JSRegExpSplitNode.callRegExpConstructor((Object)regexpConstructor, rx, newFlags, constructorCall);
                } else {
                    splitter = rx;
                }
                JSArrayObject array = JSArray.createEmptyZeroLength(context, realm);
                int size = Strings.length(str);
                int arrayLength = 0;
                int prevMatchEnd = 0;
                int fromIndex = 0;
                int matchStart = -1;
                int matchEnd = -1;
                Object lastRegexResult = null;
                do {
                    Object tRegexResult;
                    if (resultIsNull.profile(node, !TRegexUtil.TRegexResultAccessor.isMatch(tRegexResult = execIgnoreLastIndex.execute(splitter, str, fromIndex), node, readIsMatch))) {
                        if (!sizeIsZero.profile(node, size == 0) && matchStart >= 0) break;
                        parent.write(array, 0L, str);
                        return array;
                    }
                    if (!context.getRegExpStaticResultUnusedAssumption().isValid()) {
                        lastRegexResult = tRegexResult;
                    }
                    matchStart = TRegexUtil.TRegexResultAccessor.captureGroupStart(tRegexResult, 0, node, getStart);
                    matchEnd = TRegexUtil.TRegexResultAccessor.captureGroupEnd(tRegexResult, 0, node, getEnd);
                    if (matchEnd == prevMatchEnd) {
                        fromIndex = advanceStringIndex.execute(node, str, fromIndex, unicodeMatching);
                        continue;
                    }
                    TruffleString part = Strings.substring(context, substringNode, str, prevMatchEnd, matchStart - prevMatchEnd);
                    parent.write(array, arrayLength++, part);
                    if ((long)arrayLength == lim) {
                        prematureReturnBranch.enter(node);
                        return array;
                    }
                    prevMatchEnd = matchEnd;
                    long numberOfCaptures = TRegexUtil.TRegexCompiledRegexAccessor.groupCount(tRegexCompiledRegex, node, readGroupCount);
                    int i = 1;
                    while ((long)i < numberOfCaptures) {
                        parent.write(array, arrayLength, TRegexUtil.TRegexMaterializeResult.materializeGroup(context, tRegexResult, i, str, node, substringNode, getStart, getEnd));
                        if ((long)(++arrayLength) == lim) {
                            prematureReturnBranch.enter(node);
                            return array;
                        }
                        ++i;
                    }
                    fromIndex = matchStart == matchEnd ? advanceStringIndex.execute(node, str, fromIndex, unicodeMatching) : matchEnd;
                } while (fromIndex < size);
                if (context.isOptionRegexpStaticResult() && matchStart >= 0 && matchStart < size) {
                    realm.setStaticRegexResult(context, tRegexCompiledRegex, str, matchStart, lastRegexResult);
                }
                if (matchStart != matchEnd || prevMatchEnd < size) {
                    TruffleString part = Strings.substring(context, substringNode, str, prevMatchEnd, size - prevMatchEnd);
                    parent.write(array, arrayLength, part);
                }
                return array;
            }

            @Specialization(replaces={"doCached"})
            protected static JSArrayObject doUncached(JSRegExpObject rx, TruffleString str, long lim, JSContext context, JSRegExpSplitNode parent, @Bind Node node, @Cached @Cached.Shared TRegexUtil.InteropReadMemberNode readFlags, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readSticky, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readUnicode, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readUnicodeSets, @Cached @Cached.Shared RemoveStickyFlagNode removeStickyFlag, @Cached @Cached.Shared TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached @Cached.Shared TRegexUtil.InteropReadIntMemberNode readGroupCount, @Cached @Cached.Shared TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart, @Cached @Cached.Shared TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd, @Cached(value="createNew()") @Cached.Shared JSFunctionCallNode constructorCall, @Cached(value="create(context, false)") @Cached.Shared JSRegExpExecIntlNode.JSRegExpExecIntlIgnoreLastIndexNode execIgnoreLastIndex, @Cached @Cached.Shared TruffleString.SubstringByteIndexNode substringNode, @Cached @Cached.Shared AdvanceStringIndexNode advanceStringIndex, @Cached @Cached.Shared InlinedConditionProfile sizeIsZero, @Cached @Cached.Shared InlinedConditionProfile resultIsNull, @Cached @Cached.Shared InlinedConditionProfile stickyFlagSet, @Cached @Cached.Shared InlinedBranchProfile prematureReturnBranch) {
                return SplitInternalNode.doCached(rx, str, lim, context, parent, node, JSRegExp.getCompiledRegex(rx), readFlags, readSticky, readUnicode, readUnicodeSets, removeStickyFlag, readIsMatch, readGroupCount, getStart, getEnd, constructorCall, execIgnoreLastIndex, substringNode, advanceStringIndex, sizeIsZero, resultIsNull, stickyFlagSet, prematureReturnBranch);
            }
        }

        @ImportStatic(value={JSRegExp.class, Strings.class})
        protected static abstract class SplitAccordingToSpecNode
        extends JavaScriptBaseNode {
            protected SplitAccordingToSpecNode() {
            }

            protected abstract JSArrayObject execute(JSDynamicObject var1, TruffleString var2, Object var3, Object var4, JSContext var5, JSRegExpSplitNode var6);

            @Specialization
            protected static JSArrayObject split(JSDynamicObject rx, TruffleString str, Object limit, Object constructor, JSContext context, JSRegExpSplitNode parent, @Bind Node node, @Cached(value="create(FLAGS, context)") PropertyGetNode getFlags, @Cached(value="create(LENGTH, context)") PropertyGetNode getLength, @Cached JSToStringNode toString2, @Cached JSToUInt32Node toUInt32, @Cached TruffleString.CharIndexOfAnyCharUTF16Node indexOfNode, @Cached EnsureStickyNode ensureSticky, @Cached(value="createNew()") JSFunctionCallNode constructorCall, @Cached JSToLengthNode toLength, @Cached TruffleString.SubstringByteIndexNode substringNode, @Cached AdvanceStringIndexNode advanceStringIndex, @Cached InlinedConditionProfile limitUndefined, @Cached InlinedConditionProfile sizeIsZero, @Cached InlinedConditionProfile resultIsNull, @Cached InlinedConditionProfile sameMatchEnd, @Cached InlinedBranchProfile prematureReturnBranch) {
                long lim;
                TruffleString flags = toString2.executeString(getFlags.getValue((Object)rx));
                boolean unicodeMatching = Strings.indexOfAny(indexOfNode, flags, 'u', 'v') >= 0;
                TruffleString newFlags = ensureSticky.execute(node, flags);
                Object splitter = JSRegExpSplitNode.callRegExpConstructor(constructor, rx, newFlags, constructorCall);
                JSArrayObject array = JSArray.createEmptyZeroLength(context, JSRealm.get(node));
                if (limitUndefined.profile(node, limit == Undefined.instance)) {
                    lim = JSRuntime.MAX_SAFE_INTEGER_LONG;
                } else {
                    lim = toUInt32.executeLong(limit);
                    if (lim == 0L) {
                        prematureReturnBranch.enter(node);
                        return array;
                    }
                }
                int size = Strings.length(str);
                if (sizeIsZero.profile(node, size == 0)) {
                    if (parent.regexExecIntl(splitter, str) == Null.instance) {
                        parent.write(array, 0L, str);
                    }
                    return array;
                }
                int arrayLength = 0;
                int prevMatchEnd = 0;
                int fromIndex = 0;
                while (fromIndex < size) {
                    parent.setLastIndex(splitter, fromIndex);
                    JSDynamicObject regexResult = (JSDynamicObject)((Object)parent.regexExecIntl(splitter, str));
                    if (resultIsNull.profile(node, regexResult == Null.instance)) {
                        fromIndex = advanceStringIndex.execute(node, str, fromIndex, unicodeMatching);
                        continue;
                    }
                    long lastIndex = toLength.executeLong(parent.getLastIndex(splitter));
                    int matchEnd = (int)Math.min(lastIndex, (long)size);
                    if (sameMatchEnd.profile(node, matchEnd == prevMatchEnd)) {
                        fromIndex = advanceStringIndex.execute(node, str, fromIndex, unicodeMatching);
                        continue;
                    }
                    TruffleString part = Strings.substring(context, substringNode, str, prevMatchEnd, fromIndex - prevMatchEnd);
                    parent.write(array, arrayLength, part);
                    if ((long)(++arrayLength) == lim) {
                        prematureReturnBranch.enter(node);
                        return array;
                    }
                    prevMatchEnd = matchEnd;
                    fromIndex = matchEnd;
                    long numberOfCaptures = toLength.executeLong(getLength.getValue((Object)regexResult));
                    for (long i = 1L; i < numberOfCaptures; ++i) {
                        parent.write(array, arrayLength, parent.read((Object)regexResult, i));
                        if ((long)(++arrayLength) != lim) continue;
                        prematureReturnBranch.enter(node);
                        return array;
                    }
                }
                TruffleString part = Strings.substring(context, substringNode, str, prevMatchEnd, size - prevMatchEnd);
                parent.write(array, arrayLength, part);
                return array;
            }
        }

        @GenerateInline
        @GenerateCached(value=false)
        protected static abstract class EnsureStickyNode
        extends JavaScriptBaseNode {
            protected EnsureStickyNode() {
            }

            protected abstract TruffleString execute(Node var1, Object var2);

            @Specialization
            static TruffleString ensureSticky(Node node, TruffleString flags, @Cached InlinedConditionProfile emptyFlags, @Cached InlinedConditionProfile stickyFlagSet, @Cached(inline=false) TruffleString.ByteIndexOfCodePointNode indexOfNode, @Cached(inline=false) TruffleString.ConcatNode concatNode) {
                if (emptyFlags.profile(node, Strings.length(flags) == 0)) {
                    return Strings.Y;
                }
                if (stickyFlagSet.profile(node, Strings.indexOf(indexOfNode, flags, 121) >= 0)) {
                    return flags;
                }
                return Strings.concat(concatNode, flags, Strings.Y);
            }
        }

        @GenerateInline
        @GenerateCached(value=false)
        protected static abstract class RemoveStickyFlagNode
        extends JavaScriptBaseNode {
            protected RemoveStickyFlagNode() {
            }

            protected abstract TruffleString execute(Node var1, Object var2);

            @Specialization
            static TruffleString removeStickyFlag(Node node, Object tRegexFlags, @Cached TRegexUtil.InteropReadBooleanMemberNode readGlobalNode, @Cached TRegexUtil.InteropReadBooleanMemberNode readMultilineNode, @Cached TRegexUtil.InteropReadBooleanMemberNode readIgnoreCaseNode, @Cached TRegexUtil.InteropReadBooleanMemberNode readUnicodeNode, @Cached TRegexUtil.InteropReadBooleanMemberNode readDotAllNode, @Cached TRegexUtil.InteropReadBooleanMemberNode readHasIndicesNode) {
                char[] flags = new char[6];
                int len = 0;
                if (TRegexUtil.TRegexFlagsAccessor.hasIndices(tRegexFlags, node, readHasIndicesNode)) {
                    flags[len++] = 100;
                }
                if (TRegexUtil.TRegexFlagsAccessor.global(tRegexFlags, node, readGlobalNode)) {
                    flags[len++] = 103;
                }
                if (TRegexUtil.TRegexFlagsAccessor.ignoreCase(tRegexFlags, node, readIgnoreCaseNode)) {
                    flags[len++] = 105;
                }
                if (TRegexUtil.TRegexFlagsAccessor.multiline(tRegexFlags, node, readMultilineNode)) {
                    flags[len++] = 109;
                }
                if (TRegexUtil.TRegexFlagsAccessor.dotAll(tRegexFlags, node, readDotAllNode)) {
                    flags[len++] = 115;
                }
                if (TRegexUtil.TRegexFlagsAccessor.unicode(tRegexFlags, node, readUnicodeNode)) {
                    flags[len++] = 117;
                }
                if (TRegexUtil.TRegexFlagsAccessor.unicodeSets(tRegexFlags, node, readUnicodeNode)) {
                    flags[len++] = 118;
                }
                if (len == 0) {
                    return Strings.EMPTY_STRING;
                }
                return Strings.fromCharArray(flags, 0, len);
            }
        }
    }

    @ImportStatic(value={JSRegExp.class})
    public static abstract class JSRegExpCompileNode
    extends JSBuiltinNode {
        protected JSRegExpCompileNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSRegExpObject compile(JSRegExpObject thisRegExp, Object patternObj, Object flagsObj, @Bind Node node, @Cached(value="create(LAST_INDEX, false, getContext(), true)") PropertySetNode setLastIndexNode, @Cached(value="create(getContext())") CompileRegexNode compileRegexNode, @Cached(value="createUndefinedToEmpty()") JSToStringNode toStringNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile isRegExpProfile, @Cached TRegexUtil.InteropReadStringMemberNode readPattern, @Cached TRegexUtil.InteropReadMemberNode readFlags, @Cached TRegexUtil.InteropReadStringMemberNode readSource) {
            Object flags;
            Object pattern;
            Object regex;
            if (this.getRealm() != JSRegExp.getRealm(thisRegExp)) {
                errorBranch.enter(node);
                throw Errors.createTypeError("RegExp.prototype.compile cannot be used on a RegExp from a different Realm.");
            }
            if (!JSRegExp.getLegacyFeaturesEnabled(thisRegExp)) {
                errorBranch.enter(node);
                throw Errors.createTypeError("RegExp.prototype.compile cannot be used on subclasses of RegExp.");
            }
            if (isRegExpProfile.profile(node, patternObj instanceof JSRegExpObject)) {
                if (flagsObj != Undefined.instance) {
                    errorBranch.enter(node);
                    throw Errors.createTypeError("flags must be undefined", node);
                }
                regex = JSRegExp.getCompiledRegex((JSRegExpObject)patternObj);
                pattern = TRegexUtil.TRegexCompiledRegexAccessor.pattern(regex, node, readPattern);
                flags = TRegexUtil.TRegexFlagsAccessor.source(TRegexUtil.TRegexCompiledRegexAccessor.flags(regex, node, readFlags), node, readSource);
            } else {
                pattern = toStringNode.executeString(patternObj);
                flags = toStringNode.executeString(flagsObj);
            }
            regex = compileRegexNode.compile(pattern, flags);
            JSRegExp.updateCompilation(this.getContext(), thisRegExp, regex);
            setLastIndexNode.setValueInt(thisRegExp, 0);
            return thisRegExp;
        }

        @Fallback
        protected Object compile(Object thisObj, Object pattern, Object flags) {
            throw Errors.createTypeErrorNotARegExp(thisObj);
        }
    }

    @ImportStatic(value={JSRegExp.class})
    public static abstract class JSRegExpMatchAllNode
    extends JSBuiltinNode {
        public JSRegExpMatchAllNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isObjectNode.executeBoolean(regex)"}, limit="1")
        protected final Object matchAll(JSDynamicObject regex, Object stringObj, @Bind Node node, @Cached JSToStringNode toStringNodeForInput, @Cached(value="create(getContext(), false)") ArrayPrototypeBuiltins.ArraySpeciesConstructorNode speciesConstructNode, @Cached(value="create(FLAGS, getContext())") PropertyGetNode getFlagsNode, @Cached JSToStringNode toStringNodeForFlags, @Cached(value="create(LAST_INDEX, getContext())") PropertyGetNode getLastIndexNode, @Cached JSToLengthNode toLengthNode, @Cached(value="create(LAST_INDEX, false, getContext(), true)") PropertySetNode setLastIndexNode, @Cached(value="createCreateRegExpStringIteratorNode()") StringPrototypeBuiltins.CreateRegExpStringIteratorNode createRegExpStringIteratorNode, @Cached IsJSObjectNode isObjectNode, @Cached(inline=true) LongToIntOrDoubleNode indexToNumber, @Cached TruffleString.ByteIndexOfCodePointNode stringIndexOfNode, @Cached TruffleString.CharIndexOfAnyCharUTF16Node stringIndexOfAnyNode) {
            TruffleString string = toStringNodeForInput.executeString(stringObj);
            JSFunctionObject regExpConstructor = this.getRealm().getRegExpConstructor();
            Object constructor = speciesConstructNode.speciesConstructor(regex, regExpConstructor);
            TruffleString flags = toStringNodeForFlags.executeString(getFlagsNode.getValue((Object)regex));
            Object matcher = speciesConstructNode.construct(constructor, new Object[]{regex, flags});
            long lastIndex = toLengthNode.executeLong(getLastIndexNode.getValue((Object)regex));
            setLastIndexNode.setValue(matcher, indexToNumber.fromIndex(node, lastIndex));
            boolean global = Strings.indexOf(stringIndexOfNode, flags, 103) != -1;
            boolean fullUnicode = Strings.indexOfAny(stringIndexOfAnyNode, flags, 'u', 'v') != -1;
            return createRegExpStringIteratorNode.createIterator(matcher, string, global, fullUnicode);
        }

        @NeverDefault
        StringPrototypeBuiltins.CreateRegExpStringIteratorNode createCreateRegExpStringIteratorNode() {
            return new StringPrototypeBuiltins.CreateRegExpStringIteratorNode(this.getContext());
        }

        @Fallback
        protected Object matchAll(Object thisObj, Object string) {
            throw Errors.createTypeErrorIncompatibleReceiver("RegExp.prototype.@@matchAll", thisObj);
        }
    }

    static abstract class CompiledRegexPatternAccessor
    extends JSBuiltinNode {
        CompiledRegexPatternAccessor(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        Object doRegExp(JSRegExpObject obj, @Cached TRegexUtil.InteropReadStringMemberNode readPatternNode) {
            return JSRegExp.escapeRegExpPattern(readPatternNode.execute(this, JSRegExp.getCompiledRegex(obj), "pattern"));
        }

        @Specialization(guards={"isRegExpPrototype(obj)"})
        Object doPrototype(JSDynamicObject obj) {
            return JSRegExp.EMPTY_REGEX;
        }

        @Fallback
        public Object doObject(Object obj) {
            throw Errors.createTypeErrorIncompatibleReceiver(obj);
        }

        boolean isRegExpPrototype(JSDynamicObject obj) {
            return obj == this.getRealm().getRegExpPrototype();
        }

        static CompiledRegexPatternAccessor create(JSContext context, JSBuiltin builtin, JavaScriptNode[] args) {
            return RegExpPrototypeBuiltinsFactory.CompiledRegexPatternAccessorNodeGen.create(context, builtin, args);
        }
    }

    public static abstract class RegExpFlagsGetterNode
    extends JSBuiltinNode {
        @Node.Child
        private PropertyGetNode getGlobal;
        @Node.Child
        private PropertyGetNode getIgnoreCase;
        @Node.Child
        private PropertyGetNode getMultiline;
        @Node.Child
        private PropertyGetNode getDotAll;
        @Node.Child
        private PropertyGetNode getUnicode;
        @Node.Child
        private PropertyGetNode getSticky;
        @Node.Child
        private PropertyGetNode getHasIndices;
        @Node.Child
        private PropertyGetNode getUnicodeSets;
        @Node.Child
        private JSToBooleanNode toBoolean;

        public RegExpFlagsGetterNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getGlobal = PropertyGetNode.create(JSRegExp.GLOBAL, context);
            this.getIgnoreCase = PropertyGetNode.create(JSRegExp.IGNORE_CASE, context);
            this.getMultiline = PropertyGetNode.create(JSRegExp.MULTILINE, context);
            if (context.getEcmaScriptVersion() >= 9) {
                this.getDotAll = PropertyGetNode.create(JSRegExp.DOT_ALL, context);
            }
            this.getUnicode = PropertyGetNode.create(JSRegExp.UNICODE, context);
            this.getSticky = PropertyGetNode.create(JSRegExp.STICKY, context);
            if (context.isOptionRegexpMatchIndices()) {
                this.getHasIndices = PropertyGetNode.create(JSRegExp.HAS_INDICES, context);
            }
            if (context.isOptionRegexpUnicodeSets()) {
                this.getUnicodeSets = PropertyGetNode.create(JSRegExp.UNICODE_SETS, context);
            }
        }

        @Specialization(guards={"isObjectNode.executeBoolean(rx)"}, limit="1")
        protected Object doObject(JSDynamicObject rx, @Cached IsJSObjectNode isObjectNode, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            byte[] flags = new byte[8];
            int len = 0;
            if (this.getHasIndices != null && this.getFlag(rx, this.getHasIndices)) {
                flags[len++] = 100;
            }
            if (this.getFlag(rx, this.getGlobal)) {
                flags[len++] = 103;
            }
            if (this.getFlag(rx, this.getIgnoreCase)) {
                flags[len++] = 105;
            }
            if (this.getFlag(rx, this.getMultiline)) {
                flags[len++] = 109;
            }
            if (this.getDotAll != null && this.getFlag(rx, this.getDotAll)) {
                flags[len++] = 115;
            }
            if (this.getFlag(rx, this.getUnicode)) {
                flags[len++] = 117;
            }
            if (this.getUnicodeSets != null && this.getFlag(rx, this.getUnicodeSets)) {
                flags[len++] = 118;
            }
            if (this.getFlag(rx, this.getSticky)) {
                flags[len++] = 121;
            }
            if (len == 0) {
                return Strings.EMPTY_STRING;
            }
            return switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(flags, 0, len, TruffleString.Encoding.ISO_8859_1, true), TruffleString.Encoding.UTF_16);
        }

        @Fallback
        protected Object doNotObject(Object thisObj) {
            throw Errors.createTypeErrorNotAnObject(thisObj);
        }

        private boolean getFlag(JSDynamicObject re, PropertyGetNode getNode) {
            boolean flag;
            if (this.toBoolean == null) {
                try {
                    flag = getNode.getValueBoolean((Object)re);
                }
                catch (UnexpectedResultException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.toBoolean = (JSToBooleanNode)this.insert(JSToBooleanNode.create());
                    flag = this.toBoolean.executeBoolean(e.getResult());
                }
            } else {
                flag = this.toBoolean.executeBoolean(getNode.getValue((Object)re));
            }
            return flag;
        }
    }

    static abstract class CompiledRegexFlagPropertyAccessor
    extends JSBuiltinNode {
        private final String flagName;

        CompiledRegexFlagPropertyAccessor(JSContext context, JSBuiltin builtin, String flagName) {
            super(context, builtin);
            this.flagName = flagName;
        }

        @Specialization
        Object doRegExp(JSRegExpObject obj, @Cached TRegexUtil.TRegexCompiledRegexSingleFlagAccessorNode readFlag) {
            return readFlag.execute(this, JSRegExp.getCompiledRegex(obj), this.flagName);
        }

        @Specialization(guards={"isRegExpPrototype(obj)"})
        Object doPrototype(JSDynamicObject obj) {
            return Undefined.instance;
        }

        @Fallback
        public Object doObject(Object obj) {
            throw Errors.createTypeErrorIncompatibleReceiver(obj);
        }

        boolean isRegExpPrototype(JSDynamicObject obj) {
            return obj == this.getRealm().getRegExpPrototype();
        }

        public static CompiledRegexFlagPropertyAccessor create(JSContext context, JSBuiltin builtin, String flagName, JavaScriptNode[] args) {
            return RegExpPrototypeBuiltinsFactory.CompiledRegexFlagPropertyAccessorNodeGen.create(context, builtin, flagName, args);
        }
    }

    public static final class ReplaceStringConsumerTRegex
    implements ReplaceStringParser.Consumer<ParentNode, TruffleStringBuilderUTF16> {
        private final TruffleStringBuilderUTF16 sb;
        private final TruffleString input;
        private final TruffleString replaceStr;
        private final int startPos;
        private final int endPos;
        private final Object tRegexResult;
        private final Object tRegexCompiledRegex;
        private final int groupCount;

        public ReplaceStringConsumerTRegex(TruffleStringBuilderUTF16 sb, TruffleString input, TruffleString replaceStr, int startPos, int endPos, Object tRegexResult, Object tRegexCompiledRegex, int groupCount) {
            this.sb = sb;
            this.input = input;
            this.replaceStr = replaceStr;
            this.startPos = startPos;
            this.endPos = endPos;
            this.tRegexResult = tRegexResult;
            this.tRegexCompiledRegex = tRegexCompiledRegex;
            this.groupCount = groupCount;
        }

        @Override
        public void literal(ParentNode node, int start, int end) {
            node.append(this.sb, this.replaceStr, start, end);
        }

        @Override
        public void match(ParentNode node) {
            node.append(this.sb, this.input, this.startPos, this.endPos);
        }

        @Override
        public void matchHead(ParentNode node) {
            node.append(this.sb, this.input, 0, this.startPos);
        }

        @Override
        public void matchTail(ParentNode node) {
            node.append(this.sb, this.input, this.endPos, Strings.length(this.input));
        }

        @Override
        public void captureGroup(ParentNode parent, int groupNumber, int literalStart, int literalEnd) {
            Node node = (Node)parent;
            if (groupNumber < this.groupCount) {
                int start = TRegexUtil.TRegexResultAccessor.captureGroupStart(this.tRegexResult, groupNumber, node, parent.getGetStartNode());
                if (start >= 0) {
                    parent.append(this.sb, this.input, start, TRegexUtil.TRegexResultAccessor.captureGroupEnd(this.tRegexResult, groupNumber, node, parent.getGetEndNode()));
                }
            } else if (groupNumber > 9 && groupNumber / 10 < this.groupCount) {
                int start = TRegexUtil.TRegexResultAccessor.captureGroupStart(this.tRegexResult, groupNumber / 10, node, parent.getGetStartNode());
                if (start >= 0) {
                    parent.append(this.sb, this.input, start, TRegexUtil.TRegexResultAccessor.captureGroupEnd(this.tRegexResult, groupNumber / 10, node, parent.getGetEndNode()));
                }
                parent.append(this.sb, this.replaceStr, literalStart + 2, literalEnd);
            } else {
                parent.getInvalidGroupNumberProfile().enter();
                parent.append(this.sb, this.replaceStr, literalStart, literalEnd);
            }
        }

        @Override
        public void namedCaptureGroup(ParentNode node, TruffleString groupName) {
            JSRegExpReplaceNode parent = (JSRegExpReplaceNode)node;
            Object map = TRegexUtil.TRegexCompiledRegexAccessor.namedCaptureGroups(this.tRegexCompiledRegex, parent, parent.readGroupsNode);
            if (TRegexUtil.TRegexNamedCaptureGroupsAccessor.hasGroup(map, groupName, parent.namedCaptureGroupInterop)) {
                int[] groupNumbers;
                for (int groupNumber : groupNumbers = TRegexUtil.TRegexNamedCaptureGroupsAccessor.getGroupNumbers(map, groupName, parent.namedCaptureGroupInterop, parent.groupIndicesInterop, parent.toIntNode, parent)) {
                    int start = TRegexUtil.TRegexResultAccessor.captureGroupStart(this.tRegexResult, groupNumber, parent, parent.getStartNode);
                    if (start < 0) continue;
                    node.append(this.sb, this.input, start, TRegexUtil.TRegexResultAccessor.captureGroupEnd(this.tRegexResult, groupNumber, parent, parent.getEndNode));
                    break;
                }
            }
        }

        @Override
        public TruffleStringBuilderUTF16 getResult() {
            return this.sb;
        }

        public static interface ParentNode {
            public void append(TruffleStringBuilderUTF16 var1, TruffleString var2);

            public void append(TruffleStringBuilderUTF16 var1, TruffleString var2, int var3, int var4);

            public BranchProfile getInvalidGroupNumberProfile();

            public TRegexUtil.InvokeGetGroupBoundariesMethodNode getGetStartNode();

            public TRegexUtil.InvokeGetGroupBoundariesMethodNode getGetEndNode();
        }
    }

    public static final class ReplaceStringConsumer
    implements ReplaceStringParser.Consumer<JSRegExpReplaceNode, TruffleStringBuilderUTF16> {
        private final TruffleStringBuilderUTF16 sb;
        private final TruffleString input;
        private final TruffleString replaceStr;
        private final int startPos;
        private final int endPos;
        private final Object[] captures;
        private final Object namedCaptures;

        private ReplaceStringConsumer(TruffleStringBuilderUTF16 sb, TruffleString input, TruffleString replaceStr, int startPos, int endPos, Object[] captures, Object namedCaptures) {
            this.sb = sb;
            this.input = input;
            this.replaceStr = replaceStr;
            this.startPos = startPos;
            this.endPos = endPos;
            this.captures = captures;
            this.namedCaptures = namedCaptures;
        }

        @Override
        public void literal(JSRegExpReplaceNode node, int start, int end) {
            node.append(this.sb, this.replaceStr, start, end);
        }

        @Override
        public void match(JSRegExpReplaceNode node) {
            node.append(this.sb, (TruffleString)this.captures[0]);
        }

        @Override
        public void matchHead(JSRegExpReplaceNode node) {
            node.append(this.sb, this.input, 0, this.startPos);
        }

        @Override
        public void matchTail(JSRegExpReplaceNode node) {
            node.append(this.sb, this.input, this.endPos, Strings.length(this.input));
        }

        @Override
        public void captureGroup(JSRegExpReplaceNode node, int groupNumber, int literalStart, int literalEnd) {
            Object capture = this.captures[groupNumber];
            if (capture != Undefined.instance) {
                node.append(this.sb, (TruffleString)capture);
            }
        }

        @Override
        public void namedCaptureGroup(JSRegExpReplaceNode node, TruffleString groupName) {
            Object namedCapture = node.readNamedCaptureGroup(this.namedCaptures, groupName);
            if (namedCapture != Undefined.instance) {
                node.append(this.sb, node.toString4(namedCapture));
            }
        }

        @Override
        public TruffleStringBuilderUTF16 getResult() {
            return this.sb;
        }
    }

    public static abstract class RegExpPrototypeSymbolOperation
    extends JSBuiltinNode {
        @Node.Child
        private JSRegExpExecIntlNode regexExecIntlNode;
        @Node.Child
        private PropertyGetNode getLastIndexNode;
        @Node.Child
        private PropertySetNode setLastIndexNode;
        @Node.Child
        private WriteElementNode writeNode;
        @Node.Child
        private ReadElementNode readNode;
        @Node.Child
        private ArrayPrototypeBuiltins.ArraySpeciesConstructorNode arraySpeciesCreateNode;

        public RegExpPrototypeSymbolOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected Object read(Object target, long index) {
            if (this.readNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readNode = (ReadElementNode)this.insert(ReadElementNode.create(this.getContext()));
            }
            return this.readNode.executeWithTargetAndIndex(target, index);
        }

        protected void write(Object target, long index, Object value) {
            if (this.writeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeNode = (WriteElementNode)this.insert(WriteElementNode.create(this.getContext(), true, true));
            }
            this.writeNode.executeWithTargetAndIndexAndValue(target, index, value);
        }

        protected final ArrayPrototypeBuiltins.ArraySpeciesConstructorNode getArraySpeciesConstructorNode() {
            if (this.arraySpeciesCreateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arraySpeciesCreateNode = (ArrayPrototypeBuiltins.ArraySpeciesConstructorNode)this.insert(ArrayPrototypeBuiltins.ArraySpeciesConstructorNode.create(this.getContext(), false));
            }
            return this.arraySpeciesCreateNode;
        }

        private void initLastIndexNode() {
            if (this.setLastIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setLastIndexNode = (PropertySetNode)this.insert(PropertySetNode.create(JSRegExp.LAST_INDEX, false, this.getContext(), true));
            }
        }

        protected void setLastIndex(Object obj, int value) {
            this.initLastIndexNode();
            this.setLastIndexNode.setValueInt(obj, value);
        }

        protected void setLastIndex(Object obj, Object value) {
            this.initLastIndexNode();
            this.setLastIndexNode.setValue(obj, value);
        }

        protected Object getLastIndex(Object obj) {
            if (this.getLastIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getLastIndexNode = (PropertyGetNode)this.insert(PropertyGetNode.create(JSRegExp.LAST_INDEX, false, this.getContext()));
            }
            return this.getLastIndexNode.getValue(obj);
        }

        protected final void advanceLastIndexAfterEmptyMatch(Object regex, TruffleString string, boolean fullUnicode, Node node, JSToLengthNode toLengthNode, AdvanceStringIndexNode advanceStringIndex, InlinedBranchProfile lastIndexNotIntBranch) {
            long thisIndex = toLengthNode.executeLong(this.getLastIndex(regex));
            long nextIndex = thisIndex + 1L;
            if (CompilerDirectives.injectBranchProbability((double)0.75, (boolean)JSRuntime.longIsRepresentableAsInt(nextIndex))) {
                this.setLastIndex(regex, advanceStringIndex.execute(node, string, (int)thisIndex, fullUnicode));
            } else {
                lastIndexNotIntBranch.enter(node);
                this.setLastIndex(regex, nextIndex);
            }
        }

        protected Object regexExecIntl(Object regex, TruffleString input) {
            if (this.regexExecIntlNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.regexExecIntlNode = (JSRegExpExecIntlNode)this.insert(JSRegExpExecIntlNode.create(this.getContext()));
            }
            return this.regexExecIntlNode.execute(regex, input);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    protected static abstract class AdvanceStringIndexNode
    extends JavaScriptBaseNode {
        protected AdvanceStringIndexNode() {
        }

        public abstract int execute(Node var1, TruffleString var2, int var3, boolean var4);

        @Specialization
        protected static int advanceStringIndex(Node node, TruffleString s, int index, boolean unicode, @Cached(inline=false) TruffleString.ReadCharUTF16Node readChar, @Cached InlinedConditionProfile advanceUnicode, @Cached InlinedConditionProfile advanceIndexLength, @Cached InlinedConditionProfile advanceIndexFirst, @Cached InlinedConditionProfile advanceIndexSecond) {
            if (!advanceUnicode.profile(node, unicode)) {
                return index + 1;
            }
            if (advanceIndexLength.profile(node, index + 1 >= Strings.length(s))) {
                return index + 1;
            }
            char first = Strings.charAt(readChar, s, index);
            if (advanceIndexFirst.profile(node, first < '\ud800' || first > '\udbff')) {
                return index + 1;
            }
            char second = Strings.charAt(readChar, s, index + 1);
            if (advanceIndexSecond.profile(node, second < '\udc00' || second > '\udfff')) {
                return index + 1;
            }
            return index + 2;
        }
    }
}

