/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib.fastpath;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.truffle.PythonIntegerTypes;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.nodes.Node;

@GenerateCached(value=false)
@TypeSystemReference(value=PythonIntegerTypes.class)
public abstract class PyNumberSubtractFastPathsBase
extends BinaryOpNode {
    @Specialization(rewriteOn={ArithmeticException.class})
    public static int doII(int x, int y) throws ArithmeticException {
        return Math.subtractExact(x, y);
    }

    @Specialization(replaces={"doII"})
    public static long doIIOvf(int x, int y) {
        return (long)x - (long)y;
    }

    @Specialization(rewriteOn={ArithmeticException.class})
    public static long doLL(long x, long y) throws ArithmeticException {
        return Math.subtractExact(x, y);
    }

    @Specialization(replaces={"doLL"})
    public static Object doLongWithOverflow(long x, long y, @Bind Node inliningTarget) {
        long r = x - y;
        if (((x ^ y) & (x ^ r)) < 0L) {
            return PFactory.createInt(PythonLanguage.get(inliningTarget), IntBuiltins.SubNode.sub(PInt.longToBigInteger(x), PInt.longToBigInteger(y)));
        }
        return r;
    }

    @Specialization
    public static double doDD(double left, double right) {
        return left - right;
    }

    @Specialization
    public static double doDL(double left, long right) {
        return left - (double)right;
    }

    @Specialization
    public static double doLD(long left, double right) {
        return (double)left - right;
    }
}

