/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.ToNativeTypeNode;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.TypeNodesFactory;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@ExportLibrary(value=InteropLibrary.class)
public final class PythonClassNativeWrapper
extends PythonNativeWrapper.PythonAbstractObjectNativeWrapper {
    private final CArrayWrappers.CStringWrapper nameWrapper;

    private PythonClassNativeWrapper(PythonManagedClass object, TruffleString name, TruffleString.SwitchEncodingNode switchEncoding) {
        super(object, true);
        this.nameWrapper = new CArrayWrappers.CStringWrapper(switchEncoding.execute((AbstractTruffleString)name, TruffleString.Encoding.UTF_8), TruffleString.Encoding.UTF_8);
    }

    public CArrayWrappers.CStringWrapper getNameWrapper() {
        return this.nameWrapper;
    }

    public static PythonClassNativeWrapper wrap(PythonManagedClass obj, TruffleString name, TruffleString.SwitchEncodingNode switchEncoding) {
        PythonClassNativeWrapper nativeWrapper = obj.getClassNativeWrapper();
        if (nativeWrapper == null) {
            nativeWrapper = new PythonClassNativeWrapper(obj, name, switchEncoding);
            obj.setNativeWrapper(nativeWrapper);
        }
        return nativeWrapper;
    }

    public static void wrapNative(PythonManagedClass clazz, TruffleString name, Object pointer) {
        long flags;
        Object as_buffer;
        Object clear_fun;
        Object is_gc_fun;
        Object traverse_fun;
        Object free_fun;
        Object dealloc_fun;
        Object alloc_fun;
        long vectorcall_offset;
        long itemsize;
        if (clazz.getNativeWrapper() != null) {
            throw CompilerDirectives.shouldNotReachHere();
        }
        PythonClassNativeWrapper wrapper = new PythonClassNativeWrapper(clazz, name, TruffleString.SwitchEncodingNode.getUncached());
        clazz.setNativeWrapper(wrapper);
        CStructAccess.ReadI64Node readI64 = CStructAccess.ReadI64Node.getUncached();
        CStructAccess.ReadPointerNode readPointer = CStructAccess.ReadPointerNode.getUncached();
        InteropLibrary lib = InteropLibrary.getUncached();
        long basicsize = readI64.read(pointer, CFields.PyTypeObject__tp_basicsize);
        if (basicsize != 0L) {
            TypeNodesFactory.SetBasicSizeNodeGen.getUncached().execute(null, clazz, basicsize);
        }
        if ((itemsize = readI64.read(pointer, CFields.PyTypeObject__tp_itemsize)) != 0L) {
            TypeNodesFactory.SetItemSizeNodeGen.getUncached().execute(null, clazz, itemsize);
        }
        if ((vectorcall_offset = readI64.read(pointer, CFields.PyTypeObject__tp_vectorcall_offset)) != 0L) {
            HiddenAttr.WriteNode.executeUncached(clazz, HiddenAttr.VECTORCALL_OFFSET, vectorcall_offset);
        }
        if (!PGuards.isNullOrZero(alloc_fun = readPointer.read(pointer, CFields.PyTypeObject__tp_alloc), lib)) {
            HiddenAttr.WriteNode.executeUncached(clazz, HiddenAttr.ALLOC, alloc_fun);
        }
        if (!PGuards.isNullOrZero(dealloc_fun = readPointer.read(pointer, CFields.PyTypeObject__tp_dealloc), lib)) {
            HiddenAttr.WriteNode.executeUncached(clazz, HiddenAttr.DEALLOC, dealloc_fun);
        }
        if (!PGuards.isNullOrZero(free_fun = readPointer.read(pointer, CFields.PyTypeObject__tp_free), lib)) {
            HiddenAttr.WriteNode.executeUncached(clazz, HiddenAttr.FREE, free_fun);
        }
        if (!PGuards.isNullOrZero(traverse_fun = readPointer.read(pointer, CFields.PyTypeObject__tp_traverse), lib)) {
            HiddenAttr.WriteNode.executeUncached(clazz, HiddenAttr.TRAVERSE, traverse_fun);
        }
        if (!PGuards.isNullOrZero(is_gc_fun = readPointer.read(pointer, CFields.PyTypeObject__tp_is_gc), lib)) {
            HiddenAttr.WriteNode.executeUncached(clazz, HiddenAttr.IS_GC, is_gc_fun);
        }
        if (!PGuards.isNullOrZero(clear_fun = readPointer.read(pointer, CFields.PyTypeObject__tp_clear), lib)) {
            HiddenAttr.WriteNode.executeUncached(clazz, HiddenAttr.CLEAR, clear_fun);
        }
        if (!PGuards.isNullOrZero(as_buffer = readPointer.read(pointer, CFields.PyTypeObject__tp_as_buffer), lib)) {
            HiddenAttr.WriteNode.executeUncached(clazz, HiddenAttr.AS_BUFFER, as_buffer);
        }
        if ((flags = readI64.read(pointer, CFields.PyTypeObject__tp_flags)) == 0L) {
            flags = TypeNodes.GetTypeFlagsNode.executeUncached(clazz) | 0x1000L | 0x100L;
        }
        TypeNodes.SetTypeFlagsNode.executeUncached(clazz, flags);
        wrapper.replacement = pointer;
        wrapper.registerReplacement(pointer, false, lib);
    }

    public static void initNative(PythonManagedClass clazz, Object pointer) {
        PythonClassNativeWrapper classNativeWrapper = clazz.getClassNativeWrapper();
        if (classNativeWrapper == null) {
            throw CompilerDirectives.shouldNotReachHere();
        }
        ToNativeTypeNode.initializeType(classNativeWrapper, pointer, false);
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return PythonUtils.formatJString("PythonClassNativeWrapper(%s, isNative=%s)", this.getDelegate(), this.isNative());
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getReplacement(InteropLibrary lib) {
        if (this.replacement == null) {
            PythonManagedClass clazz = (PythonManagedClass)this.getDelegate();
            boolean heaptype = (TypeNodes.GetTypeFlagsNode.executeUncached(clazz) & 0x200L) != 0L;
            long size = CStructs.PyTypeObject.size();
            if (heaptype) {
                size = CStructs.PyHeapTypeObject.size();
                Object object = GetClassNode.executeUncached(clazz);
                if (object instanceof PythonAbstractNativeObject) {
                    PythonAbstractNativeObject nativeMetatype = (PythonAbstractNativeObject)object;
                    size = TypeNodes.GetBasicSizeNode.executeUncached(nativeMetatype);
                }
            }
            Object pointerObject = CStructAccess.AllocateNode.allocUncached(size);
            this.replacement = this.registerReplacement(pointerObject, true, lib);
            ToNativeTypeNode.initializeType(this, pointerObject, heaptype);
        }
        return this.replacement;
    }

    public Object getReplacementIfInitialized() {
        return this.replacement;
    }

    @ExportMessage
    boolean isPointer() {
        return this.isNative();
    }

    @ExportMessage
    long asPointer() throws UnsupportedMessageException {
        if (!this.isNative()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnsupportedMessageException.create();
        }
        return this.getNativePointer();
    }

    @ExportMessage
    void toNative() {
        if (!this.isNative()) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }
}

