/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.util;

import java.io.Serializable;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.SerializableString;
import tools.jackson.core.io.SerializedString;
import tools.jackson.core.util.DefaultIndenter;
import tools.jackson.core.util.Instantiatable;
import tools.jackson.core.util.Separators;

public class DefaultPrettyPrinter
implements PrettyPrinter,
Instantiatable<DefaultPrettyPrinter>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Indenter _arrayIndenter = FixedSpaceIndenter.instance();
    protected Indenter _objectIndenter = DefaultIndenter.SYSTEM_LINEFEED_INSTANCE;
    protected final SerializableString _rootValueSeparator;
    protected transient int _nesting;
    protected final Separators _separators;
    protected final String _objectNameValueSeparator;
    protected final String _objectEntrySeparator;
    protected final String _objectEmptySeparator;
    protected final String _arrayElementSeparator;
    protected final String _arrayEmptySeparator;

    public DefaultPrettyPrinter() {
        this(DEFAULT_SEPARATORS);
    }

    public DefaultPrettyPrinter(Separators separators) {
        this._separators = separators;
        this._rootValueSeparator = separators.getRootSeparator() == null ? null : new SerializedString(separators.getRootSeparator());
        this._objectNameValueSeparator = separators.getObjectNameValueSpacing().apply(separators.getObjectNameValueSeparator());
        this._objectEntrySeparator = separators.getObjectEntrySpacing().apply(separators.getObjectEntrySeparator());
        this._objectEmptySeparator = separators.getObjectEmptySeparator();
        this._arrayElementSeparator = separators.getArrayElementSpacing().apply(separators.getArrayElementSeparator());
        this._arrayEmptySeparator = separators.getArrayEmptySeparator();
    }

    public DefaultPrettyPrinter(DefaultPrettyPrinter base) {
        this._arrayIndenter = base._arrayIndenter;
        this._objectIndenter = base._objectIndenter;
        this._nesting = base._nesting;
        this._separators = base._separators;
        this._rootValueSeparator = base._rootValueSeparator;
        this._objectNameValueSeparator = base._objectNameValueSeparator;
        this._objectEntrySeparator = base._objectEntrySeparator;
        this._objectEmptySeparator = base._objectEmptySeparator;
        this._arrayElementSeparator = base._arrayElementSeparator;
        this._arrayEmptySeparator = base._arrayEmptySeparator;
    }

    public DefaultPrettyPrinter(DefaultPrettyPrinter base, Separators separators) {
        this._arrayIndenter = base._arrayIndenter;
        this._objectIndenter = base._objectIndenter;
        this._nesting = base._nesting;
        this._separators = separators;
        this._rootValueSeparator = separators.getRootSeparator() == null ? null : new SerializedString(separators.getRootSeparator());
        this._objectNameValueSeparator = separators.getObjectNameValueSpacing().apply(separators.getObjectNameValueSeparator());
        this._objectEntrySeparator = separators.getObjectEntrySpacing().apply(separators.getObjectEntrySeparator());
        this._objectEmptySeparator = separators.getObjectEmptySeparator();
        this._arrayElementSeparator = separators.getArrayElementSpacing().apply(separators.getArrayElementSeparator());
        this._arrayEmptySeparator = separators.getArrayEmptySeparator();
    }

    public void indentArraysWith(Indenter i) {
        this._arrayIndenter = i == null ? NopIndenter.instance() : i;
    }

    public void indentObjectsWith(Indenter i) {
        this._objectIndenter = i == null ? NopIndenter.instance() : i;
    }

    public DefaultPrettyPrinter withArrayIndenter(Indenter i) {
        if (i == null) {
            i = NopIndenter.instance();
        }
        if (this._arrayIndenter == i) {
            return this;
        }
        DefaultPrettyPrinter pp = new DefaultPrettyPrinter(this);
        pp._arrayIndenter = i;
        return pp;
    }

    public DefaultPrettyPrinter withObjectIndenter(Indenter i) {
        if (i == null) {
            i = NopIndenter.instance();
        }
        if (this._objectIndenter == i) {
            return this;
        }
        DefaultPrettyPrinter pp = new DefaultPrettyPrinter(this);
        pp._objectIndenter = i;
        return pp;
    }

    protected DefaultPrettyPrinter _withSpaces(boolean state) {
        Separators copy = this._separators.withObjectNameValueSpacing(state ? Separators.Spacing.BOTH : Separators.Spacing.NONE);
        DefaultPrettyPrinter pp = this.withSeparators(copy);
        return pp;
    }

    public DefaultPrettyPrinter withSeparators(Separators separators) {
        return new DefaultPrettyPrinter(this, separators);
    }

    @Override
    public DefaultPrettyPrinter createInstance() {
        if (this.getClass() != DefaultPrettyPrinter.class) {
            throw new IllegalStateException("Failed `createInstance()`: " + this.getClass().getName() + " does not override method; it has to");
        }
        return new DefaultPrettyPrinter(this);
    }

    @Override
    public void writeRootValueSeparator(JsonGenerator g) throws JacksonException {
        if (this._rootValueSeparator != null) {
            g.writeRaw(this._rootValueSeparator);
        }
    }

    @Override
    public void writeStartObject(JsonGenerator g) throws JacksonException {
        g.writeRaw('{');
        if (!this._objectIndenter.isInline()) {
            ++this._nesting;
        }
    }

    @Override
    public void beforeObjectEntries(JsonGenerator g) throws JacksonException {
        this._objectIndenter.writeIndentation(g, this._nesting);
    }

    @Override
    public void writeObjectNameValueSeparator(JsonGenerator g) throws JacksonException {
        g.writeRaw(this._objectNameValueSeparator);
    }

    @Override
    public void writeObjectEntrySeparator(JsonGenerator g) throws JacksonException {
        g.writeRaw(this._objectEntrySeparator);
        this._objectIndenter.writeIndentation(g, this._nesting);
    }

    @Override
    public void writeEndObject(JsonGenerator g, int nrOfEntries) throws JacksonException {
        if (!this._objectIndenter.isInline()) {
            --this._nesting;
        }
        if (nrOfEntries > 0) {
            this._objectIndenter.writeIndentation(g, this._nesting);
        } else {
            g.writeRaw(this._objectEmptySeparator);
        }
        g.writeRaw('}');
    }

    @Override
    public void writeStartArray(JsonGenerator g) throws JacksonException {
        if (!this._arrayIndenter.isInline()) {
            ++this._nesting;
        }
        g.writeRaw('[');
    }

    @Override
    public void beforeArrayValues(JsonGenerator g) throws JacksonException {
        this._arrayIndenter.writeIndentation(g, this._nesting);
    }

    @Override
    public void writeArrayValueSeparator(JsonGenerator g) throws JacksonException {
        g.writeRaw(this._arrayElementSeparator);
        this._arrayIndenter.writeIndentation(g, this._nesting);
    }

    @Override
    public void writeEndArray(JsonGenerator g, int nrOfValues) throws JacksonException {
        if (!this._arrayIndenter.isInline()) {
            --this._nesting;
        }
        if (nrOfValues > 0) {
            this._arrayIndenter.writeIndentation(g, this._nesting);
        } else {
            g.writeRaw(this._arrayEmptySeparator);
        }
        g.writeRaw(']');
    }

    public static class FixedSpaceIndenter
    extends NopIndenter {
        private static final FixedSpaceIndenter _fixedInstance = new FixedSpaceIndenter();

        public static FixedSpaceIndenter instance() {
            return _fixedInstance;
        }

        @Override
        public void writeIndentation(JsonGenerator g, int level) throws JacksonException {
            g.writeRaw(' ');
        }

        @Override
        public boolean isInline() {
            return true;
        }
    }

    public static interface Indenter {
        public void writeIndentation(JsonGenerator var1, int var2) throws JacksonException;

        public boolean isInline();
    }

    public static class NopIndenter
    implements Indenter,
    Serializable {
        private static final NopIndenter _nopInstance = new NopIndenter();

        public static NopIndenter instance() {
            return _nopInstance;
        }

        @Override
        public void writeIndentation(JsonGenerator g, int level) {
        }

        @Override
        public boolean isInline() {
            return true;
        }
    }
}

