/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class PyOSFSPathNode
extends PNodeWithContext {
    public abstract Object execute(Frame var1, Node var2, Object var3);

    @Specialization
    static Object doString(TruffleString object) {
        return object;
    }

    @Specialization
    static Object doPString(PString object) {
        return object;
    }

    @Specialization
    static Object doBytes(PBytes object) {
        return object;
    }

    @Fallback
    static Object callFspath(VirtualFrame frame, Node inliningTarget, Object object, @Cached GetClassNode getClassNode, @Cached LookupSpecialMethodNode.Dynamic lookupFSPath, @Cached(inline=false) CallUnaryMethodNode callFSPath, @Cached PRaiseNode raiseNode) {
        Object type = getClassNode.execute(inliningTarget, object);
        Object fspathMethod = lookupFSPath.execute((Frame)frame, inliningTarget, type, SpecialMethodNames.T___FSPATH__, object);
        if (fspathMethod == PNone.NO_VALUE) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_STR_BYTE_OSPATHLIKE_OBJ, object);
        }
        Object result = callFSPath.executeObject((Frame)frame, fspathMethod, object);
        assert (!TruffleStringMigrationHelpers.isJavaString(result));
        if (result instanceof TruffleString || result instanceof PString || result instanceof PBytes) {
            return result;
        }
        throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_FSPATH_TO_RETURN_STR_OR_BYTES, object, result);
    }
}

