/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.lib.PyLongFromDoubleNodeGen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
@ImportStatic(value={MathGuards.class})
public abstract class PyLongFromDoubleNode
extends Node {
    public abstract Object execute(Node var1, double var2);

    public static Object executeUncached(double value) {
        return PyLongFromDoubleNodeGen.getUncached().execute(null, value);
    }

    @Specialization(guards={"fitInt(value)"})
    static int doInt(double value) {
        return (int)value;
    }

    @Specialization(guards={"fitLong(value)"})
    static long doLong(double value) {
        return (long)value;
    }

    @Specialization(guards={"!fitLong(value)", "isFinite(value)"})
    static Object doFinite(double value, @Bind PythonLanguage language) {
        return PFactory.createInt(language, PyLongFromDoubleNode.toBigInteger(value));
    }

    @Specialization(guards={"!isFinite(value)"})
    static Object doInfinite(Node inliningTarget, double value, @Cached PRaiseNode raiseNode) {
        if (Double.isNaN(value)) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.CANNOT_CONVERT_FLOAT_NAN_TO_INTEGER);
        }
        assert (Double.isInfinite(value));
        throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError, ErrorMessages.CANNOT_CONVERT_FLOAT_INFINITY_TO_INTEGER);
    }

    @CompilerDirectives.TruffleBoundary
    private static BigInteger toBigInteger(double self) {
        return new BigDecimal(self, MathContext.UNLIMITED).toBigInteger();
    }

    protected static boolean isFinite(double value) {
        return Double.isFinite(value);
    }
}

