/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.typing;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.TypingModuleBuiltins;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.typing.GenericBuiltinsFactory;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PGeneric})
public final class GenericBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return GenericBuiltinsFactory.getFactories();
    }

    @Builtin(name="__init_subclass__", minNumOfPositionalArgs=1, isClassmethod=true, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class InitSubclassNode
    extends PythonBuiltinNode {
        private static final TruffleString T_GENERIC_INIT_SUBCLASS = PythonUtils.tsLiteral("_generic_init_subclass");

        @Specialization
        static Object initSubclass(VirtualFrame frame, Object cls, Object[] args, PKeyword[] kwargs, @Bind Node inliningTarget, @Cached TypingModuleBuiltins.CallTypingArgsKwargsNode callTypingNode) {
            return callTypingNode.execute(frame, inliningTarget, T_GENERIC_INIT_SUBCLASS, cls, args, kwargs);
        }
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=1, isClassmethod=true, takesVarArgs=true, takesVarKeywordArgs=true, doc="Parameterizes a generic class.\n\nAt least, parameterizing a generic class is the *main* thing this\nmethod does. For example, for some generic class `Foo`, this is called\nwhen we do `Foo[int]` - there, with `cls=Foo` and `params=int`.\n\nHowever, note that this method is also called when defining generic\nclasses in the first place with `class Foo[T]: ...`.\n")
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBuiltinNode {
        private static final TruffleString T_GENERIC_CLASS_ITEM = PythonUtils.tsLiteral("_generic_class_getitem");

        @Specialization
        static Object classGetItem(VirtualFrame frame, Object cls, Object[] args, PKeyword[] kwargs, @Bind Node inliningTarget, @Cached TypingModuleBuiltins.CallTypingArgsKwargsNode callTypingNode) {
            return callTypingNode.execute(frame, inliningTarget, T_GENERIC_CLASS_ITEM, cls, args, kwargs);
        }
    }
}

