/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.socket;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.builtins.objects.socket.PSocket;
import com.oracle.graal.python.builtins.objects.socket.SocketBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.socket.SocketBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.socket.SocketBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.socket.SocketNodes;
import com.oracle.graal.python.builtins.objects.socket.SocketUtils;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyLongAsIntNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.TimeUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PSocket})
public final class SocketBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = SocketBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return SocketBuiltinsFactory.getFactories();
    }

    private static void checkSelectable(Node inliningTarget, PRaiseNode raiseNode, PSocket socket) {
        if (!SocketBuiltins.isSelectable(socket)) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OSError, ErrorMessages.UNABLE_TO_SELECT_ON_SOCKET);
        }
    }

    private static boolean isSelectable(PSocket socket) {
        return PythonOS.getPythonOS() != PythonOS.PLATFORM_WIN32 || socket.getTimeoutNs() <= 0L || socket.getFd() < PosixConstants.FD_SETSIZE.value;
    }

    @Builtin(name="getsockopt", minNumOfPositionalArgs=3, numOfPositionalOnlyArgs=4, parameterNames={"$self", "level", "optname", "buflen"})
    @ArgumentsClinic(value={@ArgumentClinic(name="level", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="optname", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="buflen", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0")})
    @GenerateNodeFactory
    static abstract class GetSockOptNode
    extends PythonQuaternaryClinicBuiltinNode {
        GetSockOptNode() {
        }

        @Specialization
        static Object getSockOpt(VirtualFrame frame, PSocket socket, int level, int option, int buflen, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            try {
                if (buflen == 0) {
                    byte[] result = new byte[4];
                    posixLib.getsockopt(context.getPosixSupport(), socket.getFd(), level, option, result, result.length);
                    return PythonUtils.ARRAY_ACCESSOR.getInt(result, 0);
                }
                if (buflen > 0 && buflen < 1024) {
                    byte[] result = new byte[buflen];
                    int len = posixLib.getsockopt(context.getPosixSupport(), socket.getFd(), level, option, result, result.length);
                    return PFactory.createBytes(context.getLanguage(inliningTarget), result, len);
                }
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OSError, ErrorMessages.GETSECKOPT_BUFF_OUT_OFRANGE);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SocketBuiltinsClinicProviders.GetSockOptNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="setsockopt", minNumOfPositionalArgs=4, numOfPositionalOnlyArgs=5, parameterNames={"$self", "level", "optname", "flag1", "flag2"})
    @ArgumentsClinic(value={@ArgumentClinic(name="level", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="optname", conversion=ArgumentClinic.ClinicConversion.Int)})
    @GenerateNodeFactory
    static abstract class SetSockOptNode
    extends PythonClinicBuiltinNode {
        SetSockOptNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isNoValue(none)"})
        static Object setInt(VirtualFrame frame, PSocket socket, int level, int option, Object value, PNone none, @Bind PythonContext context, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @CachedLibrary(limit="3") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Bind Node inliningTarget, @Cached.Exclusive @Cached PyLongAsIntNode asIntNode, @Cached.Exclusive @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            int len;
            byte[] bytes;
            try {
                int flag = asIntNode.execute((Frame)frame, inliningTarget, value);
                bytes = new byte[4];
                len = bytes.length;
                PythonUtils.ARRAY_ACCESSOR.putInt(bytes, 0, flag);
            }
            catch (PException e) {
                Object buffer = bufferAcquireLib.acquireReadonly(value, frame, indirectCallData);
                try {
                    len = bufferLib.getBufferLength(buffer);
                    bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                }
                finally {
                    bufferLib.release(buffer, frame, indirectCallData);
                }
            }
            try {
                posixLib.setsockopt(context.getPosixSupport(), socket.getFd(), level, option, bytes, len);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }

        @Specialization(guards={"isNone(none)"})
        static Object setNull(VirtualFrame frame, PSocket socket, int level, int option, PNone none, Object buflenObj, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Bind Node inliningTarget, @Cached.Exclusive @Cached PyLongAsIntNode asIntNode, @Cached.Exclusive @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            int buflen = asIntNode.execute((Frame)frame, inliningTarget, buflenObj);
            if (buflen < 0) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OSError, ErrorMessages.SETSECKOPT_BUFF_OUT_OFRANGE);
            }
            try {
                posixLib.setsockopt(context.getPosixSupport(), socket.getFd(), level, option, null, buflen);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }

        @Fallback
        static Object error(Object self, Object level, Object option, Object flag1, Object flag2, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.SETSECKOPT_REQUIRERS_3RD_ARG_NULL);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SocketBuiltinsClinicProviders.SetSockOptNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="detach", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SockDetachNode
    extends PythonUnaryBuiltinNode {
        SockDetachNode() {
        }

        @Specialization
        int detach(PSocket socket) {
            int fd = socket.getFd();
            socket.setFd(-1);
            return fd;
        }
    }

    @Builtin(name="fileno", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SockFilenoNode
    extends PythonUnaryBuiltinNode {
        SockFilenoNode() {
        }

        @Specialization
        int fileno(PSocket socket) {
            return socket.getFd();
        }
    }

    @Builtin(name="proto", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class SockProtoNode
    extends PythonUnaryBuiltinNode {
        SockProtoNode() {
        }

        @Specialization
        int proto(PSocket socket) {
            return socket.getProto();
        }
    }

    @Builtin(name="type", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class SocketTypeNode
    extends PythonUnaryBuiltinNode {
        SocketTypeNode() {
        }

        @Specialization
        int type(PSocket socket) {
            return socket.getType();
        }
    }

    @Builtin(name="family", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class SocketFamilyNode
    extends PythonUnaryBuiltinNode {
        SocketFamilyNode() {
        }

        @Specialization
        int family(PSocket socket) {
            return socket.getFamily();
        }
    }

    @Builtin(name="shutdown", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "how"})
    @ArgumentClinic(name="how", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class ShutdownNode
    extends PythonBinaryClinicBuiltinNode {
        ShutdownNode() {
        }

        @Specialization
        static Object shutdown(VirtualFrame frame, PSocket socket, int how, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixLib.shutdown(context.getPosixSupport(), socket.getFd(), how);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SocketBuiltinsClinicProviders.ShutdownNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="settimeout", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class SetTimeoutNode
    extends PythonBinaryBuiltinNode {
        SetTimeoutNode() {
        }

        @Specialization
        static Object setTimeout(VirtualFrame frame, PSocket socket, Object seconds, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached SocketNodes.ParseTimeoutNode parseTimeoutNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            long timeout = parseTimeoutNode.execute(frame, inliningTarget, seconds);
            socket.setTimeoutNs(timeout);
            try {
                posixLib.setBlocking(context.getPosixSupport(), socket.getFd(), timeout < 0L);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="setblocking", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "blocking"})
    @ArgumentClinic(name="blocking", conversion=ArgumentClinic.ClinicConversion.Boolean)
    @GenerateNodeFactory
    public static abstract class SetBlockingNode
    extends PythonBinaryClinicBuiltinNode {
        @Specialization
        static PNone doBoolean(VirtualFrame frame, PSocket socket, boolean blocking, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixLib.setBlocking(context.getPosixSupport(), socket.getFd(), blocking);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            socket.setTimeoutNs(blocking ? -1L : 0L);
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SocketBuiltinsClinicProviders.SetBlockingNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="sendto", minNumOfPositionalArgs=3, maxNumOfPositionalArgs=4)
    @GenerateNodeFactory
    static abstract class SendToNode
    extends PythonBuiltinNode {
        SendToNode() {
        }

        @Specialization(limit="3")
        static Object sendTo(VirtualFrame frame, PSocket socket, Object bufferObj, Object flagsOrAddress, Object maybeAddress, @Bind Node inliningTarget, @Bind PythonContext context, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="bufferObj") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached InlinedConditionProfile hasFlagsProfile, @Cached PyLongAsIntNode asIntNode, @Cached SocketNodes.GetSockAddrArgNode getSockAddrArgNode, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            int flags;
            Object address;
            if (hasFlagsProfile.profile(inliningTarget, maybeAddress == PNone.NO_VALUE)) {
                address = flagsOrAddress;
                flags = 0;
            } else {
                address = maybeAddress;
                flags = asIntNode.execute((Frame)frame, inliningTarget, flagsOrAddress);
            }
            Object buffer = bufferAcquireLib.acquireReadonly(bufferObj, frame, indirectCallData);
            try {
                SocketBuiltins.checkSelectable(inliningTarget, raiseNode, socket);
                PosixSupportLibrary.UniversalSockAddr addr = getSockAddrArgNode.execute(frame, socket, address, "sendto");
                auditNode.audit(inliningTarget, "socket.sendto", socket, address);
                int len = bufferLib.getBufferLength(buffer);
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                try {
                    Integer n = SocketUtils.callSocketFunctionWithRetry((Frame)frame, inliningTarget, constructAndRaiseNode, posixLib, context.getPosixSupport(), gil, socket, (p, s) -> p.sendto(s, socket.getFd(), bytes, 0, len, flags, addr), true, false);
                    return n;
                }
                catch (PosixSupportLibrary.PosixException e) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }
    }

    @Builtin(name="sendall", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=3, parameterNames={"$self", "buffer", "flags"})
    @ArgumentClinic(name="flags", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0")
    @GenerateNodeFactory
    static abstract class SendAllNode
    extends PythonTernaryClinicBuiltinNode {
        SendAllNode() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Specialization(limit="3")
        static Object sendAll(VirtualFrame frame, PSocket socket, Object bufferObj, int flags, @Bind Node inliningTarget, @Bind PythonContext context, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="bufferObj") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            Object buffer = bufferAcquireLib.acquireReadonly(bufferObj, frame, indirectCallData);
            try {
                SocketBuiltins.checkSelectable(inliningTarget, raiseNode, socket);
                int offset = 0;
                int len = bufferLib.getBufferLength(buffer);
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                long timeout = socket.getTimeoutNs();
                SocketUtils.TimeoutHelper timeoutHelper = null;
                if (timeout > 0L) {
                    timeoutHelper = new SocketUtils.TimeoutHelper(timeout);
                }
                while (true) {
                    try {
                        int offset1 = offset;
                        int len1 = len;
                        int outlen = SocketUtils.callSocketFunctionWithRetry((Frame)frame, inliningTarget, constructAndRaiseNode, posixLib, context.getPosixSupport(), gil, socket, (p, s) -> p.send(s, socket.getFd(), bytes, offset1, len1, flags), true, false, timeoutHelper);
                        offset += outlen;
                        if ((len -= outlen) <= 0) {
                            PNone pNone = PNone.NONE;
                            return pNone;
                        }
                    }
                    catch (PosixSupportLibrary.PosixException e) {
                        throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                    }
                    {
                        PythonContext.triggerAsyncActions(inliningTarget);
                        continue;
                    }
                    break;
                }
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SocketBuiltinsClinicProviders.SendAllNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="send", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "buffer", "flags"})
    @ArgumentClinic(name="flags", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0")
    @GenerateNodeFactory
    static abstract class SendNode
    extends PythonTernaryClinicBuiltinNode {
        SendNode() {
        }

        @Specialization(limit="3")
        static int send(VirtualFrame frame, PSocket socket, Object bufferObj, int flags, @Bind Node inliningTarget, @Bind PythonContext context, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="bufferObj") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            Object buffer = bufferAcquireLib.acquireReadonly(bufferObj, frame, indirectCallData);
            try {
                SocketBuiltins.checkSelectable(inliningTarget, raiseNode, socket);
                int len = bufferLib.getBufferLength(buffer);
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                try {
                    int n = SocketUtils.callSocketFunctionWithRetry((Frame)frame, inliningTarget, constructAndRaiseNode, posixLib, context.getPosixSupport(), gil, socket, (p, s) -> p.send(s, socket.getFd(), bytes, 0, len, flags), true, false);
                    return n;
                }
                catch (PosixSupportLibrary.PosixException e) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SocketBuiltinsClinicProviders.SendNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="recvfrom_into", minNumOfPositionalArgs=2, parameterNames={"$self", "buffer", "nbytes", "flags"})
    @ArgumentsClinic(value={@ArgumentClinic(name="nbytes", conversion=ArgumentClinic.ClinicConversion.Index, defaultValue="0"), @ArgumentClinic(name="flags", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0")})
    @GenerateNodeFactory
    static abstract class RecvFromIntoNode
    extends PythonQuaternaryClinicBuiltinNode {
        RecvFromIntoNode() {
        }

        @Specialization(limit="3")
        static Object recvFromInto(VirtualFrame frame, PSocket socket, Object bufferObj, int recvlenIn, int flags, @Bind Node inliningTarget, @Bind PythonContext context, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="bufferObj") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached GilNode gil, @Cached SocketNodes.MakeSockAddrNode makeSockAddrNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            Object buffer = bufferAcquireLib.acquireWritable(bufferObj, frame, indirectCallData);
            try {
                byte[] bytes;
                if (recvlenIn < 0) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.NEG_BUFF_SIZE_IN_RECVFROM_INTO);
                }
                int buflen = bufferLib.getBufferLength(buffer);
                int recvlen = recvlenIn;
                if (recvlen == 0) {
                    recvlen = buflen;
                }
                if (buflen < recvlen) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.NBYTES_GREATER_THAT_BUFF);
                }
                SocketBuiltins.checkSelectable(inliningTarget, raiseNode, socket);
                boolean directWrite = bufferLib.hasInternalByteArray(buffer);
                if (directWrite) {
                    bytes = bufferLib.getInternalByteArray(buffer);
                } else {
                    try {
                        bytes = new byte[recvlen];
                    }
                    catch (OutOfMemoryError error) {
                        throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.MemoryError);
                    }
                }
                try {
                    PosixSupportLibrary.RecvfromResult result = SocketUtils.callSocketFunctionWithRetry((Frame)frame, inliningTarget, constructAndRaiseNode, posixLib, context.getPosixSupport(), gil, socket, (p, s) -> p.recvfrom(s, socket.getFd(), bytes, 0, bytes.length, flags), false, false);
                    if (!directWrite) {
                        bufferLib.writeFromByteArray(buffer, 0, bytes, 0, result.readBytes);
                    }
                    PTuple pTuple = PFactory.createTuple(context.getLanguage(inliningTarget), new Object[]{result.readBytes, makeSockAddrNode.execute(frame, inliningTarget, result.sockAddr)});
                    return pTuple;
                }
                catch (PosixSupportLibrary.PosixException e) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SocketBuiltinsClinicProviders.RecvFromIntoNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="recv_into", minNumOfPositionalArgs=2, parameterNames={"$self", "buffer", "nbytes", "flags"})
    @ArgumentsClinic(value={@ArgumentClinic(name="nbytes", conversion=ArgumentClinic.ClinicConversion.Index, defaultValue="0"), @ArgumentClinic(name="flags", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0")})
    @GenerateNodeFactory
    static abstract class RecvIntoNode
    extends PythonQuaternaryClinicBuiltinNode {
        RecvIntoNode() {
        }

        @Specialization(limit="3")
        static Object recvInto(VirtualFrame frame, PSocket socket, Object bufferObj, int recvlenIn, int flags, @Bind Node inliningTarget, @Bind PythonContext context, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(value="bufferObj") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            Object buffer = bufferAcquireLib.acquireWritable(bufferObj, frame, indirectCallData);
            try {
                byte[] bytes;
                if (recvlenIn < 0) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.NEG_BUFF_SIZE_IN_RECV_INTO);
                }
                int buflen = bufferLib.getBufferLength(buffer);
                int recvlen = recvlenIn;
                if (recvlen == 0) {
                    recvlen = buflen;
                }
                if (buflen < recvlen) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.BUFF_TOO_SMALL);
                }
                SocketBuiltins.checkSelectable(inliningTarget, raiseNode, socket);
                boolean directWrite = bufferLib.hasInternalByteArray(buffer);
                if (directWrite) {
                    bytes = bufferLib.getInternalByteArray(buffer);
                } else {
                    try {
                        bytes = new byte[recvlen];
                    }
                    catch (OutOfMemoryError error) {
                        throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.MemoryError);
                    }
                }
                int len = recvlen;
                try {
                    int outlen = SocketUtils.callSocketFunctionWithRetry((Frame)frame, inliningTarget, constructAndRaiseNode, posixLib, context.getPosixSupport(), gil, socket, (p, s) -> p.recv(s, socket.getFd(), bytes, 0, len, flags), false, false);
                    if (!directWrite) {
                        bufferLib.writeFromByteArray(buffer, 0, bytes, 0, outlen);
                    }
                    Integer n = outlen;
                    return n;
                }
                catch (PosixSupportLibrary.PosixException e) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
            }
            finally {
                bufferLib.release(bufferObj, frame, indirectCallData);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SocketBuiltinsClinicProviders.RecvIntoNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="recvfrom", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=3, parameterNames={"$self", "nbytes", "flags"})
    @ArgumentsClinic(value={@ArgumentClinic(name="nbytes", conversion=ArgumentClinic.ClinicConversion.Index), @ArgumentClinic(name="flags", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0")})
    @GenerateNodeFactory
    static abstract class RecvFromNode
    extends PythonTernaryClinicBuiltinNode {
        RecvFromNode() {
        }

        @Specialization
        static Object recvFrom(VirtualFrame frame, PSocket socket, int recvlen, int flags, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached GilNode gil, @Cached SocketNodes.MakeSockAddrNode makeSockAddrNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            byte[] bytes;
            if (recvlen < 0) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.NEG_BUFF_SIZE_IN_RECVFROM);
            }
            SocketBuiltins.checkSelectable(inliningTarget, raiseNode, socket);
            try {
                bytes = new byte[recvlen];
            }
            catch (OutOfMemoryError error) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.MemoryError);
            }
            try {
                PosixSupportLibrary.RecvfromResult result = SocketUtils.callSocketFunctionWithRetry((Frame)frame, inliningTarget, constructAndRaiseNode, posixLib, context.getPosixSupport(), gil, socket, (p, s) -> p.recvfrom(s, socket.getFd(), bytes, 0, bytes.length, flags), false, false);
                PythonLanguage language = context.getLanguage(inliningTarget);
                PBytes resultBytes = result.readBytes == 0 ? PFactory.createEmptyBytes(language) : PFactory.createBytes(language, bytes, result.readBytes);
                return PFactory.createTuple(language, new Object[]{resultBytes, makeSockAddrNode.execute(frame, inliningTarget, result.sockAddr)});
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SocketBuiltinsClinicProviders.RecvFromNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="recv", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=3, parameterNames={"$self", "nbytes", "flags"})
    @ArgumentsClinic(value={@ArgumentClinic(name="nbytes", conversion=ArgumentClinic.ClinicConversion.Index), @ArgumentClinic(name="flags", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0")})
    @GenerateNodeFactory
    static abstract class RecvNode
    extends PythonTernaryClinicBuiltinNode {
        RecvNode() {
        }

        @Specialization
        static Object recv(VirtualFrame frame, PSocket socket, int recvlen, int flags, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            byte[] bytes;
            if (recvlen < 0) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.NEG_BUFF_SIZE_IN_RECV);
            }
            SocketBuiltins.checkSelectable(inliningTarget, raiseNode, socket);
            PythonLanguage language = context.getLanguage(inliningTarget);
            if (recvlen == 0) {
                return PFactory.createEmptyBytes(language);
            }
            try {
                bytes = new byte[recvlen];
            }
            catch (OutOfMemoryError error) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.MemoryError);
            }
            try {
                int outlen = SocketUtils.callSocketFunctionWithRetry((Frame)frame, inliningTarget, constructAndRaiseNode, posixLib, context.getPosixSupport(), gil, socket, (p, s) -> p.recv(s, socket.getFd(), bytes, 0, bytes.length, flags), false, false);
                if (outlen == 0) {
                    return PFactory.createEmptyBytes(language);
                }
                return PFactory.createBytes(language, bytes, outlen);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SocketBuiltinsClinicProviders.RecvNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="listen", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=2, parameterNames={"$self", "backlog"})
    @ArgumentClinic(name="backlog", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="128")
    @GenerateNodeFactory
    static abstract class ListenNode
    extends PythonBinaryClinicBuiltinNode {
        ListenNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object listen(VirtualFrame frame, PSocket self, int backlogIn, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            int backlog = backlogIn;
            if (backlog < 0) {
                backlog = 0;
            }
            try {
                gil.release(true);
                try {
                    posixLib.listen(context.getPosixSupport(), self.getFd(), backlog);
                }
                finally {
                    gil.acquire();
                }
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SocketBuiltinsClinicProviders.ListenNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="gettimeout", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetTimeoutNode
    extends PythonUnaryBuiltinNode {
        GetTimeoutNode() {
        }

        @Specialization
        static Object get(PSocket socket) {
            if (socket.getTimeoutNs() < 0L) {
                return PNone.NONE;
            }
            return TimeUtils.pyTimeAsSecondsDouble(socket.getTimeoutNs());
        }
    }

    @Builtin(name="getblocking", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetBlockingNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static boolean get(PSocket socket) {
            return socket.getTimeoutNs() != 0L;
        }
    }

    @Builtin(name="getsockname", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetSockNameNode
    extends PythonUnaryBuiltinNode {
        GetSockNameNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object get(VirtualFrame frame, PSocket socket, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached SocketNodes.MakeSockAddrNode makeSockAddrNode, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                PosixSupportLibrary.UniversalSockAddr addr;
                gil.release(true);
                try {
                    addr = posixLib.getsockname(context.getPosixSupport(), socket.getFd());
                }
                finally {
                    gil.acquire();
                }
                return makeSockAddrNode.execute(frame, inliningTarget, addr);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="getpeername", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetPeerNameNode
    extends PythonUnaryBuiltinNode {
        GetPeerNameNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object get(VirtualFrame frame, PSocket socket, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached SocketNodes.MakeSockAddrNode makeSockAddrNode, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                PosixSupportLibrary.UniversalSockAddr addr;
                gil.release(true);
                try {
                    addr = posixLib.getpeername(context.getPosixSupport(), socket.getFd());
                }
                finally {
                    gil.acquire();
                }
                return makeSockAddrNode.execute(frame, inliningTarget, addr);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="connect_ex", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class ConnectExNode
    extends PythonBinaryBuiltinNode {
        ConnectExNode() {
        }

        @Specialization
        static Object connectEx(VirtualFrame frame, PSocket self, Object address, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Bind Node inliningTarget, @Cached SocketNodes.GetSockAddrArgNode getSockAddrArgNode, @Cached GilNode gil, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            PosixSupportLibrary.UniversalSockAddr connectAddr = getSockAddrArgNode.execute(frame, self, address, "connect_ex");
            auditNode.audit(inliningTarget, "socket.connect", self, address);
            try {
                ConnectNode.doConnect((Frame)frame, inliningTarget, constructAndRaiseNode, posixLib, context.getPosixSupport(), gil, self, connectAddr);
            }
            catch (PosixSupportLibrary.PosixException e) {
                return e.getErrorCode();
            }
            return 0;
        }
    }

    @Builtin(name="connect", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class ConnectNode
    extends PythonBinaryBuiltinNode {
        ConnectNode() {
        }

        @Specialization
        static Object connect(VirtualFrame frame, PSocket self, Object address, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Bind Node inliningTarget, @Cached SocketNodes.GetSockAddrArgNode getSockAddrArgNode, @Cached GilNode gil, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            PosixSupportLibrary.UniversalSockAddr connectAddr = getSockAddrArgNode.execute(frame, self, address, "connect");
            auditNode.audit(inliningTarget, "socket.connect", self, address);
            try {
                ConnectNode.doConnect((Frame)frame, inliningTarget, constructAndRaiseNode, posixLib, context.getPosixSupport(), gil, self, connectAddr);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void doConnect(Frame frame, Node inliningTarget, PConstructAndRaiseNode.Lazy constructAndRaiseNode, PosixSupportLibrary posixLib, Object posixSupport, GilNode gil, PSocket self, PosixSupportLibrary.UniversalSockAddr connectAddr) throws PosixSupportLibrary.PosixException {
            try {
                gil.release(true);
                try {
                    posixLib.connect(posixSupport, self.getFd(), connectAddr);
                }
                finally {
                    gil.acquire();
                }
            }
            catch (PosixSupportLibrary.PosixException e) {
                boolean waitConnect;
                if (e.getErrorCode() == OSErrorEnum.EINTR.getNumber()) {
                    PythonContext.triggerAsyncActions(constructAndRaiseNode);
                    waitConnect = self.getTimeoutNs() != 0L && SocketBuiltins.isSelectable(self);
                } else {
                    boolean bl = waitConnect = self.getTimeoutNs() > 0L && e.getErrorCode() == OSErrorEnum.EINPROGRESS.getNumber() && SocketBuiltins.isSelectable(self);
                }
                if (waitConnect) {
                    SocketUtils.callSocketFunctionWithRetry(frame, inliningTarget, constructAndRaiseNode, posixLib, posixSupport, gil, self, (p, s) -> {
                        byte[] tmp = new byte[4];
                        p.getsockopt(s, self.getFd(), PosixConstants.SOL_SOCKET.value, PosixConstants.SO_ERROR.value, tmp, tmp.length);
                        int err = PythonUtils.ARRAY_ACCESSOR.getInt(tmp, 0);
                        if (err != 0 && err != OSErrorEnum.EISCONN.getNumber()) {
                            throw new PosixSupportLibrary.PosixException(err, p.strerror(s, err));
                        }
                        return null;
                    }, true, true);
                }
                throw e;
            }
        }
    }

    @Builtin(name="close", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CloseNode
    extends PythonUnaryBuiltinNode {
        CloseNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object close(VirtualFrame frame, PSocket socket, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            block6: {
                int fd = socket.getFd();
                if (fd != -1) {
                    try {
                        socket.setFd(-1);
                        gil.release(true);
                        try {
                            posixLib.close(context.getPosixSupport(), fd);
                        }
                        finally {
                            gil.acquire();
                        }
                    }
                    catch (PosixSupportLibrary.PosixException e) {
                        if (e.getErrorCode() == OSErrorEnum.ECONNRESET.getNumber()) break block6;
                        throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                    }
                }
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="bind", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class BindNode
    extends PythonBinaryBuiltinNode {
        BindNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object bind(VirtualFrame frame, PSocket self, Object address, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLibrary, @Cached SocketNodes.GetSockAddrArgNode getSockAddrArgNode, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            PosixSupportLibrary.UniversalSockAddr addr = getSockAddrArgNode.execute(frame, self, address, "bind");
            auditNode.audit(inliningTarget, "socket.bind", self, address);
            try {
                gil.release(true);
                try {
                    posixLibrary.bind(context.getPosixSupport(), self.getFd(), addr);
                }
                finally {
                    gil.acquire();
                }
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="_accept", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class AcceptNode
    extends PythonUnaryBuiltinNode {
        AcceptNode() {
        }

        @Specialization
        static Object accept(VirtualFrame frame, PSocket self, @Bind Node inliningTarget, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Cached SocketNodes.MakeSockAddrNode makeSockAddrNode, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            SocketBuiltins.checkSelectable(inliningTarget, raiseNode, self);
            try {
                PosixSupport posixSupport = context.getPosixSupport();
                PosixSupportLibrary.AcceptResult acceptResult = SocketUtils.callSocketFunctionWithRetry((Frame)frame, inliningTarget, constructAndRaiseNode, posixLib, posixSupport, gil, self, (p, s) -> p.accept(s, self.getFd()), false, false);
                try {
                    Object pythonAddr = makeSockAddrNode.execute(frame, inliningTarget, acceptResult.sockAddr);
                    posixLib.setInheritable(posixSupport, acceptResult.socketFd, false);
                    return PFactory.createTuple(context.getLanguage(inliningTarget), new Object[]{acceptResult.socketFd, pythonAddr});
                }
                catch (Exception e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    try {
                        posixLib.close(posixSupport, acceptResult.socketFd);
                    }
                    catch (PosixSupportLibrary.PosixException posixException) {
                        // empty catch block
                    }
                    throw e;
                }
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        TruffleString repr(PSocket self, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("<socket object, fd=%d, family=%d, type=%d, proto=%d>", self.getFd(), self.getFamily(), self.getType(), self.getProto());
        }
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(name="socket", minNumOfPositionalArgs=1, parameterNames={"$self", "family", "type", "proto", "fileno"})
    @ArgumentsClinic(value={@ArgumentClinic(name="family", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1"), @ArgumentClinic(name="type", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1"), @ArgumentClinic(name="proto", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1")})
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonClinicBuiltinNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object init(VirtualFrame frame, PSocket self, int familyIn, int typeIn, int protoIn, PNone fileno, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @Bind Node inliningTarget, @Cached.Exclusive @Cached SysModuleBuiltins.AuditNode auditNode, @Cached GilNode gil, @Cached.Exclusive @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            int proto;
            int type;
            auditNode.audit(inliningTarget, "socket.__new__", self, familyIn, typeIn, protoIn);
            int family = familyIn;
            if (family == -1) {
                family = PosixConstants.AF_INET.value;
            }
            if ((type = typeIn) == -1) {
                type = PosixConstants.SOCK_STREAM.value;
            }
            if ((proto = protoIn) == -1) {
                proto = 0;
            }
            try {
                int fd;
                gil.release(true);
                try {
                    fd = posixLib.socket(context.getPosixSupport(), family, type, proto);
                }
                finally {
                    gil.acquire();
                }
                try {
                    posixLib.setInheritable(context.getPosixSupport(), fd, false);
                    InitNode.sockInit(context, posixLib, self, fd, family, type, proto);
                }
                catch (Exception e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    try {
                        posixLib.close(context.getPosixSupport(), fd);
                    }
                    catch (PosixSupportLibrary.PosixException posixException) {
                        // empty catch block
                    }
                    throw e;
                }
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }

        @Specialization(guards={"!isPNone(fileno)"})
        static Object init(VirtualFrame frame, PSocket self, int familyIn, int typeIn, int protoIn, Object fileno, @Bind PythonContext context, @CachedLibrary(value="context.getPosixSupport()") PosixSupportLibrary posixLib, @CachedLibrary(limit="1") PosixSupportLibrary.UniversalSockAddrLibrary addrLib, @Bind Node inliningTarget, @Cached.Exclusive @Cached SysModuleBuiltins.AuditNode auditNode, @Cached PyLongAsIntNode asIntNode, @Cached.Exclusive @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode raiseNode) {
            int family;
            int fd;
            block10: {
                auditNode.audit(inliningTarget, "socket.__new__", self, familyIn, typeIn, protoIn);
                fd = asIntNode.execute((Frame)frame, inliningTarget, fileno);
                if (fd < 0) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.NEG_FILE_DESC);
                }
                family = familyIn;
                try {
                    PosixSupportLibrary.UniversalSockAddr addr = posixLib.getsockname(context.getPosixSupport(), fd);
                    if (family == -1) {
                        family = addrLib.getFamily(addr);
                    }
                }
                catch (PosixSupportLibrary.PosixException e) {
                    if (family != -1 && e.getErrorCode() != OSErrorEnum.EBADF.getNumber() && e.getErrorCode() != OSErrorEnum.ENOTSOCK.getNumber()) break block10;
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
            }
            try {
                int type = typeIn;
                if (type == -1) {
                    type = InitNode.getIntSockopt(context.getPosixSupport(), posixLib, fd, PosixConstants.SOL_SOCKET.value, PosixConstants.SO_TYPE.value);
                }
                int proto = protoIn;
                if (PosixConstants.SO_PROTOCOL.defined) {
                    if (proto == -1) {
                        proto = InitNode.getIntSockopt(context.getPosixSupport(), posixLib, fd, PosixConstants.SOL_SOCKET.value, PosixConstants.SO_PROTOCOL.getValueIfDefined());
                    }
                } else {
                    proto = 0;
                }
                InitNode.sockInit(context, posixLib, self, fd, family, type, proto);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }

        private static void sockInit(PythonContext context, PosixSupportLibrary posixLib, PSocket self, int fd, int family, int type, int proto) throws PosixSupportLibrary.PosixException {
            self.setFd(fd);
            self.setFamily(family);
            self.setType(type);
            self.setProto(proto);
            long defaultTimeout = context.lookupBuiltinModule(BuiltinNames.T__SOCKET).getModuleState(Long.class);
            self.setTimeoutNs(defaultTimeout);
            if (defaultTimeout >= 0L) {
                posixLib.setBlocking(context.getPosixSupport(), fd, false);
            }
        }

        private static int getIntSockopt(PosixSupport posixSupport, PosixSupportLibrary posixLib, int fd, int level, int option) throws PosixSupportLibrary.PosixException {
            byte[] tmp = new byte[4];
            int len = posixLib.getsockopt(posixSupport, fd, level, option, tmp, tmp.length);
            assert (len == tmp.length);
            return PythonUtils.ARRAY_ACCESSOR.getInt(tmp, 0);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SocketBuiltinsClinicProviders.InitNodeClinicProviderGen.INSTANCE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="socket", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class SocketNode
    extends PythonVarargsBuiltinNode {
        @Specialization
        Object socket(Object cls, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createSocket(language, cls, getInstanceShape.execute(cls));
        }
    }
}

