/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.datasource;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import us.fatehi.utility.Builder;
import us.fatehi.utility.TemplatingUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.datasource.DatabaseConnectionSources;
import us.fatehi.utility.datasource.MultiUseUserCredentials;
import us.fatehi.utility.datasource.UserCredentials;

public class DatabaseConnectionSourceBuilder
implements Builder<DatabaseConnectionSource> {
    private final String connectionUrlTemplate;
    private String defaultDatabase;
    private String defaultHost;
    private int defaultPort;
    private Map<String, String> defaultUrlx;
    private UserCredentials userCredentials;
    private Consumer<Connection> connectionInitializer;
    private String providedDatabase;
    private String providedHost;
    private Integer providedPort;
    private Map<String, String> providedUrlx;

    public static DatabaseConnectionSourceBuilder builder(String connectionUrlTemplate) {
        return new DatabaseConnectionSourceBuilder(connectionUrlTemplate);
    }

    private DatabaseConnectionSourceBuilder(String connectionUrlTemplate) {
        this.connectionUrlTemplate = connectionUrlTemplate;
        this.defaultHost = "localhost";
        this.defaultDatabase = "";
        this.userCredentials = new MultiUseUserCredentials();
        this.connectionInitializer = connection -> {};
    }

    @Override
    public DatabaseConnectionSource build() {
        String connectionUrl = this.toURL();
        Map<String, String> connectionUrlx = this.toUrlx();
        DatabaseConnectionSource databaseConnectionSource = DatabaseConnectionSources.newDatabaseConnectionSource(connectionUrl, connectionUrlx, this.userCredentials, this.connectionInitializer);
        return databaseConnectionSource;
    }

    public Consumer<Connection> getConnectionInitializer() {
        return this.connectionInitializer;
    }

    public DatabaseConnectionSourceBuilder withConnectionInitializer(Consumer<Connection> connectionInitializer) {
        this.connectionInitializer = connectionInitializer == null ? connection -> {} : connectionInitializer;
        return this;
    }

    public DatabaseConnectionSourceBuilder withDatabase(String database) {
        this.providedDatabase = database;
        return this;
    }

    public DatabaseConnectionSourceBuilder withDefaultDatabase(String defaultDatabase) {
        this.defaultDatabase = defaultDatabase;
        return this;
    }

    public DatabaseConnectionSourceBuilder withDefaultHost(String defaultHost) {
        this.defaultHost = defaultHost;
        return this;
    }

    public DatabaseConnectionSourceBuilder withDefaultPort(int defaultPort) {
        this.defaultPort = defaultPort;
        return this;
    }

    public DatabaseConnectionSourceBuilder withDefaultUrlx(Map<String, String> defaultUrlx) {
        this.defaultUrlx = defaultUrlx;
        return this;
    }

    public DatabaseConnectionSourceBuilder withDefaultUrlx(String property, boolean value) {
        return this.withDefaultUrlx(property, String.valueOf(value));
    }

    public DatabaseConnectionSourceBuilder withDefaultUrlx(String property, String value) {
        if (this.defaultUrlx == null) {
            this.defaultUrlx = new HashMap<String, String>();
        }
        this.defaultUrlx.put(property, value);
        return this;
    }

    public DatabaseConnectionSourceBuilder withHost(String host) {
        this.providedHost = host;
        return this;
    }

    public DatabaseConnectionSourceBuilder withPort(Integer port) {
        this.providedPort = port != null && (port < 1024 || port > 65535) ? null : port;
        return this;
    }

    public DatabaseConnectionSourceBuilder withUrlx(Map<String, String> urlx) {
        this.providedUrlx = urlx;
        return this;
    }

    public DatabaseConnectionSourceBuilder withUserCredentials(UserCredentials userCredentials) {
        this.userCredentials = userCredentials == null ? new MultiUseUserCredentials() : userCredentials;
        return this;
    }

    String toURL() {
        Utility.requireNotBlank(this.connectionUrlTemplate, "No database connection URL template provided");
        String host = Utility.isBlank(this.providedHost) ? this.defaultHost : this.providedHost;
        int port = this.providedPort == null || this.providedPort < 0 || this.providedPort > 65535 ? this.defaultPort : this.providedPort;
        String database = Utility.isBlank(this.providedDatabase) ? this.defaultDatabase : this.providedDatabase;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("host", host);
        map.put("port", String.valueOf(port));
        map.put("database", database);
        String url = TemplatingUtility.expandTemplate(this.connectionUrlTemplate, map);
        return url;
    }

    Map<String, String> toUrlx() {
        HashMap<String, String> urlx = new HashMap<String, String>();
        if (this.defaultUrlx != null) {
            urlx.putAll(this.defaultUrlx);
        }
        if (this.providedUrlx != null) {
            urlx.putAll(this.providedUrlx);
        }
        return urlx;
    }
}

