/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.object;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.NonIdempotent;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Layout;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.PropertyGetter;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.Pair;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Shape {
    static final int OBJECT_FLAGS_MASK = 65535;
    static final int OBJECT_FLAGS_SHIFT = 0;
    static final int OBJECT_SHARED = 65536;
    static final int OBJECT_PROPERTY_ASSUMPTIONS = 131072;
    static final int PUT_CONSTANT = 32;

    public static Builder newBuilder() {
        CompilerAsserts.neverPartOfCompilation();
        return new Builder();
    }

    public static DerivedBuilder newBuilder(Shape baseShape) {
        CompilerAsserts.neverPartOfCompilation();
        return new DerivedBuilder(baseShape);
    }

    protected Shape() {
    }

    public abstract Property getProperty(Object var1);

    protected abstract Shape addProperty(Property var1);

    @Deprecated(since="22.2")
    public abstract Shape defineProperty(Object var1, Object var2, int var3);

    protected abstract Shape defineProperty(Object var1, Object var2, int var3, int var4);

    final Shape defineConstantProperty(Object key, Object value, int propertyFlags) {
        return this.defineProperty(key, value, propertyFlags, 32);
    }

    public abstract Iterable<Property> getProperties();

    public abstract List<Property> getPropertyList();

    public abstract List<Property> getPropertyListInternal(boolean var1);

    public abstract List<Object> getKeyList();

    public abstract Iterable<Object> getKeys();

    @Idempotent
    public abstract Assumption getValidAssumption();

    @NonIdempotent
    public abstract boolean isValid();

    @NonIdempotent
    public abstract Assumption getLeafAssumption();

    @NonIdempotent
    public abstract boolean isLeaf();

    public abstract boolean hasProperty(Object var1);

    protected abstract Shape removeProperty(Property var1);

    protected abstract Shape replaceProperty(Property var1, Property var2);

    public abstract Property getLastProperty();

    @Idempotent
    public int getFlags() {
        CompilerAsserts.neverPartOfCompilation();
        throw CompilerDirectives.shouldNotReachHere();
    }

    protected Shape setFlags(int newFlags) {
        CompilerAsserts.neverPartOfCompilation();
        throw CompilerDirectives.shouldNotReachHere();
    }

    public abstract int getPropertyCount();

    public Object getDynamicType() {
        CompilerAsserts.neverPartOfCompilation();
        throw CompilerDirectives.shouldNotReachHere();
    }

    protected Shape setDynamicType(Object dynamicType) {
        CompilerAsserts.neverPartOfCompilation();
        Objects.requireNonNull(dynamicType);
        throw CompilerDirectives.shouldNotReachHere();
    }

    public abstract Shape getRoot();

    public abstract boolean check(DynamicObject var1);

    public Class<? extends DynamicObject> getLayoutClass() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    public abstract Object getSharedData();

    public abstract Shape tryMerge(Shape var1);

    @Idempotent
    public boolean isShared() {
        return false;
    }

    public Shape makeSharedShape() {
        CompilerAsserts.neverPartOfCompilation();
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Idempotent
    protected boolean hasInstanceProperties() {
        return true;
    }

    public Assumption getPropertyAssumption(Object key) {
        return Assumption.NEVER_VALID;
    }

    public boolean allPropertiesMatch(Predicate<Property> predicate) {
        CompilerAsserts.neverPartOfCompilation();
        throw CompilerDirectives.shouldNotReachHere();
    }

    @CompilerDirectives.TruffleBoundary
    public PropertyGetter makePropertyGetter(Object key) {
        Property property = this.getProperty(key);
        if (property == null) {
            return null;
        }
        return new PropertyGetter(this, property);
    }

    public static final class Builder
    extends AbstractBuilder<Builder> {
        private Class<? extends DynamicObject> layoutClass = DynamicObject.class;
        private MethodHandles.Lookup layoutLookup = DynamicObject.internalLookup();
        private Object dynamicType = ObjectType.DEFAULT;
        private int shapeFlags;
        private boolean allowImplicitCastIntToDouble;
        private boolean allowImplicitCastIntToLong;
        private boolean shared;
        private boolean propertyAssumptions;
        private Object sharedData;
        private Assumption singleContextAssumption;
        private EconomicMap<Object, Pair<Object, Integer>> properties;

        Builder() {
        }

        @Deprecated(since="24.2")
        public Builder layout(Class<? extends DynamicObject> layoutClass) {
            CompilerAsserts.neverPartOfCompilation();
            if (!DynamicObject.class.isAssignableFrom(layoutClass)) {
                throw new IllegalArgumentException(String.format("Expected a subclass of %s but got: %s", DynamicObject.class.getName(), layoutClass.getTypeName()));
            }
            this.layoutClass = layoutClass;
            this.layoutLookup = null;
            return this;
        }

        public Builder layout(Class<? extends DynamicObject> layoutClass, MethodHandles.Lookup layoutClassLookup) {
            CompilerAsserts.neverPartOfCompilation();
            if (!DynamicObject.class.isAssignableFrom(layoutClass)) {
                throw new IllegalArgumentException(String.format("Expected a subclass of %s but got: %s", DynamicObject.class.getName(), layoutClass.getTypeName()));
            }
            if (layoutClass == DynamicObject.class) {
                this.layoutClass = DynamicObject.class;
                this.layoutLookup = DynamicObject.internalLookup();
                return this;
            }
            if (!layoutClassLookup.hasFullPrivilegeAccess()) {
                throw new IllegalArgumentException("Lookup must have full privilege access");
            }
            if (layoutClassLookup.lookupClass().getModule() != layoutClass.getModule()) {
                throw new IllegalArgumentException("Lookup must be from the same module as the layout class");
            }
            this.layoutClass = layoutClass;
            this.layoutLookup = layoutClassLookup;
            return this;
        }

        @Override
        public Builder dynamicType(Object dynamicType) {
            CompilerAsserts.neverPartOfCompilation();
            this.dynamicType = Builder.checkDynamicType(dynamicType);
            return this;
        }

        @Override
        public Builder shapeFlags(int flags) {
            CompilerAsserts.neverPartOfCompilation();
            this.shapeFlags = Builder.checkShapeFlags(flags);
            return this;
        }

        public Builder shared(boolean isShared) {
            CompilerAsserts.neverPartOfCompilation();
            this.shared = isShared;
            return this;
        }

        public Builder propertyAssumptions(boolean enable) {
            CompilerAsserts.neverPartOfCompilation();
            this.propertyAssumptions = enable;
            return this;
        }

        public Builder sharedData(Object sharedData) {
            CompilerAsserts.neverPartOfCompilation();
            this.sharedData = sharedData;
            return this;
        }

        public Builder singleContextAssumption(Assumption assumption) {
            CompilerAsserts.neverPartOfCompilation();
            this.singleContextAssumption = assumption;
            return this;
        }

        @Override
        public Builder addConstantProperty(Object key, Object value, int flags) {
            CompilerAsserts.neverPartOfCompilation();
            Objects.requireNonNull(key, "key");
            if (this.properties == null) {
                this.properties = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
            }
            if (this.properties.containsKey(key)) {
                throw new IllegalArgumentException(String.format("Property already exists: %s.", key));
            }
            this.properties.put(key, (Object)Pair.create((Object)value, (Object)flags));
            return this;
        }

        public Builder allowImplicitCastIntToLong(boolean allow) {
            this.allowImplicitCastIntToLong = allow;
            return this;
        }

        public Builder allowImplicitCastIntToDouble(boolean allow) {
            this.allowImplicitCastIntToDouble = allow;
            return this;
        }

        public Shape build() {
            CompilerAsserts.neverPartOfCompilation();
            int flags = this.shapeFlags;
            if (this.shared) {
                flags = this.shapeFlags | 0x10000;
            }
            if (this.propertyAssumptions) {
                flags = this.shapeFlags | 0x20000;
            }
            int implicitCastFlags = (this.allowImplicitCastIntToDouble ? 1 : 0) | (this.allowImplicitCastIntToLong ? 2 : 0);
            Shape shape = Layout.getFactory().createShape(this.layoutClass, implicitCastFlags, this.dynamicType, this.sharedData, flags, this.properties, this.singleContextAssumption, this.layoutLookup);
            assert (shape.isShared() == this.shared && shape.getFlags() == this.shapeFlags && shape.getDynamicType() == this.dynamicType);
            return shape;
        }
    }

    public static final class DerivedBuilder
    extends AbstractBuilder<DerivedBuilder> {
        private final Shape baseShape;
        private Object dynamicType;
        private int shapeFlags;
        private EconomicMap<Object, Pair<Object, Integer>> properties;

        DerivedBuilder(Shape baseShape) {
            this.baseShape = baseShape;
            this.dynamicType = baseShape.getDynamicType();
            this.shapeFlags = baseShape.getFlags();
        }

        @Override
        public DerivedBuilder dynamicType(Object dynamicType) {
            CompilerAsserts.neverPartOfCompilation();
            this.dynamicType = DerivedBuilder.checkDynamicType(dynamicType);
            return this;
        }

        @Override
        public DerivedBuilder shapeFlags(int flags) {
            CompilerAsserts.neverPartOfCompilation();
            this.shapeFlags = DerivedBuilder.checkShapeFlags(flags);
            return this;
        }

        @Override
        public DerivedBuilder addConstantProperty(Object key, Object value, int flags) {
            CompilerAsserts.neverPartOfCompilation();
            Objects.requireNonNull(key, "key");
            if (this.properties == null) {
                this.properties = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
            }
            if (this.baseShape.getProperty(key) != null || this.properties.containsKey(key)) {
                throw new IllegalArgumentException(String.format("Property already exists: %s.", key));
            }
            this.properties.put(key, (Object)Pair.create((Object)value, (Object)flags));
            return this;
        }

        public Shape build() {
            CompilerAsserts.neverPartOfCompilation();
            Shape derivedShape = this.baseShape;
            if (this.dynamicType != derivedShape.getDynamicType()) {
                derivedShape = derivedShape.setDynamicType(this.dynamicType);
            }
            if (this.shapeFlags != derivedShape.getFlags()) {
                derivedShape = derivedShape.setFlags(this.shapeFlags);
            }
            if (this.properties != null) {
                MapCursor cursor = this.properties.getEntries();
                while (cursor.advance()) {
                    derivedShape = derivedShape.defineConstantProperty(cursor.getKey(), ((Pair)cursor.getValue()).getLeft(), (Integer)((Pair)cursor.getValue()).getRight());
                }
            }
            return derivedShape;
        }
    }

    static abstract class AbstractBuilder<T extends AbstractBuilder<T>> {
        AbstractBuilder() {
        }

        public abstract T dynamicType(Object var1);

        public abstract T shapeFlags(int var1);

        public abstract T addConstantProperty(Object var1, Object var2, int var3);

        static Object checkDynamicType(Object dynamicType) {
            Objects.requireNonNull(dynamicType, "dynamicType");
            return dynamicType;
        }

        static int checkShapeFlags(int flags) {
            if ((flags & 0xFFFF0000) != 0) {
                throw new IllegalArgumentException("flags must be in the range [0, 0xffff]");
            }
            return flags;
        }
    }
}

