/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.Objects;
import org.jspecify.annotations.NonNull;
import schemacrawler.schemacrawler.FilterOptions;
import schemacrawler.schemacrawler.GrepOptions;
import schemacrawler.schemacrawler.LimitOptions;
import schemacrawler.schemacrawler.LoadOptions;
import schemacrawler.schemacrawler.Options;

public record SchemaCrawlerOptions(@NonNull LimitOptions limitOptions, @NonNull FilterOptions filterOptions, @NonNull GrepOptions grepOptions, @NonNull LoadOptions loadOptions) implements Options
{
    public SchemaCrawlerOptions(@NonNull LimitOptions limitOptions, @NonNull FilterOptions filterOptions, @NonNull GrepOptions grepOptions, @NonNull LoadOptions loadOptions) {
        Objects.requireNonNull(limitOptions, "No limit options provided");
        Objects.requireNonNull(filterOptions, "No filter options provided");
        Objects.requireNonNull(grepOptions, "No grep options provided");
        Objects.requireNonNull(loadOptions, "No load options provided");
    }

    public SchemaCrawlerOptions withFilterOptions(FilterOptions filterOptions) {
        if (filterOptions == null) {
            return this;
        }
        return new SchemaCrawlerOptions(this.limitOptions, filterOptions, this.grepOptions, this.loadOptions);
    }

    public SchemaCrawlerOptions withGrepOptions(GrepOptions grepOptions) {
        if (grepOptions == null) {
            return this;
        }
        return new SchemaCrawlerOptions(this.limitOptions, this.filterOptions, grepOptions, this.loadOptions);
    }

    public SchemaCrawlerOptions withLimitOptions(LimitOptions limitOptions) {
        if (limitOptions == null) {
            return this;
        }
        return new SchemaCrawlerOptions(limitOptions, this.filterOptions, this.grepOptions, this.loadOptions);
    }

    public SchemaCrawlerOptions withLoadOptions(LoadOptions loadOptions) {
        if (loadOptions == null) {
            return this;
        }
        return new SchemaCrawlerOptions(this.limitOptions, this.filterOptions, this.grepOptions, loadOptions);
    }
}

