/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.babelfish;

import java.io.File;
import java.lang.reflect.Executable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.babelfish.TranslatedErrorInfo;
import oracle.jdbc.babelfish.TranslationCache;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.SQL_TRANSLATION})
@DefaultLevel(value=Logging.FINEST)
public class Translator {
    private final File localErrorTranslationFile;
    private final String translationProfile;
    private Connection conn;
    private CallableStatement queryTranslationStatement;
    private CallableStatement errorTranslationStatement;
    private final Map<String, String> queryCache;
    private final Map<Integer, TranslatedErrorInfo> errorCache;
    private final Map<Integer, TranslatedErrorInfo> localErrorCache;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    Translator(String translationProfile, File localErrorTranslationFile, TranslationCache translationCache) throws SQLException {
        boolean bl = (0x10000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, Translator.class, $$$methodRef$$$7, null, translationProfile, localErrorTranslationFile, translationCache);
            }
            this.translationProfile = translationProfile;
            this.localErrorTranslationFile = localErrorTranslationFile;
            this.queryCache = translationCache.getQueryCache();
            this.errorCache = translationCache.getErrorCache();
            this.localErrorCache = translationCache.getLocalErrorCache();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, Translator.class, $$$methodRef$$$7, null);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, Translator.class, $$$methodRef$$$7, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, Translator.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public SQLException translateError(SQLException sQLException) throws SQLException {
        boolean bl = (0x10000L & TraceControllerImpl.feature) != 0L;
        try {
            void ex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, Translator.class, $$$methodRef$$$0, this, sQLException);
            }
            if (this.conn == null) {
                SQLException sQLException2 = this.translateErrorLocal((SQLException)ex);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, Translator.class, $$$methodRef$$$0, this, sQLException2);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, Translator.class, $$$methodRef$$$0, this, null);
                }
                return sQLException2;
            }
            TranslatedErrorInfo translatedErrorInfo = this.errorCache.get(ex.getErrorCode());
            if (translatedErrorInfo != null) {
                SQLException newex = new SQLException("[Translated Error Codes] " + ex.getMessage(), translatedErrorInfo.getSqlState(), translatedErrorInfo.getErrorCode(), (Throwable)ex);
                newex.setStackTrace(ex.getStackTrace());
                SQLException sQLException3 = newex;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, Translator.class, $$$methodRef$$$0, this, sQLException3);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, Translator.class, $$$methodRef$$$0, this, null);
                }
                return sQLException3;
            }
            try {
                String tmpSqlState;
                this.errorTranslationStatement.clearParameters();
                this.errorTranslationStatement.setInt(1, ex.getErrorCode());
                this.errorTranslationStatement.registerOutParameter(2, 4);
                this.errorTranslationStatement.registerOutParameter(3, 12);
                this.errorTranslationStatement.execute();
                int tmpErrorCode = this.errorTranslationStatement.getInt(2);
                if (this.errorTranslationStatement.wasNull()) {
                    tmpErrorCode = ex.getErrorCode();
                }
                if ((tmpSqlState = this.errorTranslationStatement.getString(3)) == null) {
                    tmpSqlState = ex.getSQLState();
                }
                translatedErrorInfo = new TranslatedErrorInfo(tmpErrorCode, tmpSqlState);
            }
            catch (SQLException e2) {
                SQLException sQLException4 = (SQLException)DatabaseError.createSqlException(null, 280, null, (Throwable)e2).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, Translator.class, $$$methodRef$$$0, this, sQLException4);
                }
                throw sQLException4;
            }
            this.errorCache.put(ex.getErrorCode(), translatedErrorInfo);
            SQLException newex = new SQLException("[Translated Error Codes] " + ex.getMessage(), translatedErrorInfo.getSqlState(), translatedErrorInfo.getErrorCode(), (Throwable)ex);
            newex.setStackTrace(ex.getStackTrace());
            SQLException sQLException5 = newex;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, Translator.class, $$$methodRef$$$0, this, sQLException5);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, Translator.class, $$$methodRef$$$0, this, null);
            }
            return sQLException5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, Translator.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    SQLException translateErrorLocal(SQLException sQLException) throws SQLException {
        boolean bl = (0x10000L & TraceControllerImpl.feature) != 0L;
        try {
            void ex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, Translator.class, $$$methodRef$$$1, this, sQLException);
            }
            if (this.localErrorCache == null) {
                void var6_3 = ex;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, Translator.class, $$$methodRef$$$1, this, var6_3);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, Translator.class, $$$methodRef$$$1, this, null);
                }
                return var6_3;
            }
            TranslatedErrorInfo translatedErrorInfo = this.localErrorCache.get(ex.getErrorCode());
            if (translatedErrorInfo != null) {
                String message = "[Translated Error Codes] " + ex.getMessage();
                SQLException exep = new SQLException(message, translatedErrorInfo.getSqlState(), translatedErrorInfo.getErrorCode(), (Throwable)ex);
                exep.setStackTrace(ex.getStackTrace());
                SQLException sQLException2 = exep;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, Translator.class, $$$methodRef$$$1, this, sQLException2);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, Translator.class, $$$methodRef$$$1, this, null);
                }
                return sQLException2;
            }
            SQLException newex = new SQLException("[Error Translation Not Available] " + ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), (Throwable)ex);
            newex.setStackTrace(ex.getStackTrace());
            SQLException sQLException3 = newex;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, Translator.class, $$$methodRef$$$1, this, sQLException3);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, Translator.class, $$$methodRef$$$1, this, null);
            }
            return sQLException3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, Translator.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    String translateQuery(String string) throws SQLException {
        boolean bl = (0x10000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, Translator.class, $$$methodRef$$$2, this, string);
            }
            if (this.conn != null) {
                void sql;
                String translatedSql = this.queryCache.get(sql);
                if (translatedSql != null) {
                    String string2 = translatedSql;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, Translator.class, $$$methodRef$$$2, this, string2);
                        ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, Translator.class, $$$methodRef$$$2, this, null);
                    }
                    return string2;
                }
                String jdbcMarkerConvertedSql = this.convertParameterMarkersToOracleStyle((String)sql);
                try {
                    this.queryTranslationStatement.clearParameters();
                    this.queryTranslationStatement.setString(1, jdbcMarkerConvertedSql);
                    this.queryTranslationStatement.registerOutParameter(2, 12);
                    this.queryTranslationStatement.execute();
                    translatedSql = this.queryTranslationStatement.getString(2);
                }
                catch (SQLException ex) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, 280, null, (Throwable)ex).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, Translator.class, $$$methodRef$$$2, this, sQLException);
                    }
                    throw sQLException;
                }
                if (translatedSql == null) {
                    translatedSql = jdbcMarkerConvertedSql;
                }
                this.queryCache.put((String)sql, translatedSql);
                String string3 = translatedSql;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, Translator.class, $$$methodRef$$$2, this, string3);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, Translator.class, $$$methodRef$$$2, this, null);
                }
                return string3;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(279).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, Translator.class, $$$methodRef$$$2, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, Translator.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void activateServerTranslation(Connection connection) throws SQLException {
        boolean bl = (0x10000L & TraceControllerImpl.feature) != 0L;
        try {
            void babelfishConnection;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, Translator.class, $$$methodRef$$$3, this, connection);
            }
            CallableStatement sessionstmt = babelfishConnection.prepareCall("begin execute immediate 'alter session set sql_translation_profile = ' || sys.dbms_assert.qualified_sql_name(?); end;");
            sessionstmt.setString(1, this.translationProfile);
            sessionstmt.execute();
            this.queryTranslationStatement = babelfishConnection.prepareCall("begin sys.dbms_sql_translator.translate_sql(?, ? ); end;");
            this.errorTranslationStatement = babelfishConnection.prepareCall("begin sys.dbms_sql_translator.translate_error(?, ?, ? ); end;");
            this.conn = babelfishConnection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, Translator.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, Translator.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, Translator.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    void deactivateServerTranslation() throws SQLException {
        boolean bl = (0x10000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, Translator.class, $$$methodRef$$$4, this, new Object[0]);
            }
            this.queryTranslationStatement.close();
            this.errorTranslationStatement.close();
            this.conn = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, Translator.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, Translator.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, Translator.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    String convertParameterMarkersToOracleStyle(String string) {
        boolean bl = (0x10000L & TraceControllerImpl.feature) != 0L;
        try {
            void sql;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, Translator.class, $$$methodRef$$$5, this, string);
            }
            StringBuilder retStr = new StringBuilder();
            boolean inQuotesFlag = false;
            boolean inSingleLineComment = false;
            boolean inMultiLineComment = false;
            int parameterCount = 1;
            block10: for (int i2 = 0; i2 < sql.length(); ++i2) {
                char c2 = sql.charAt(i2);
                if (inSingleLineComment) {
                    retStr.append(c2);
                    continue;
                }
                switch (c2) {
                    case '\\': {
                        retStr.append(c2);
                        if (i2 >= sql.length() - 1) continue block10;
                        retStr.append(sql.charAt(++i2));
                        continue block10;
                    }
                    case '?': {
                        if (!inQuotesFlag && !inMultiLineComment) {
                            retStr.append(":").append(parameterCount++);
                            continue block10;
                        }
                        retStr.append(c2);
                        continue block10;
                    }
                    case '\'': {
                        if (!inMultiLineComment) {
                            inQuotesFlag = !inQuotesFlag;
                        }
                        retStr.append(c2);
                        continue block10;
                    }
                    case '-': {
                        retStr.append(c2);
                        if (i2 >= sql.length() - 1 || sql.charAt(i2 + 1) != '-') continue block10;
                        retStr.append(sql.charAt(++i2));
                        inSingleLineComment = true;
                        continue block10;
                    }
                    case '/': {
                        retStr.append(c2);
                        if (inQuotesFlag || i2 >= sql.length() - 1 || sql.charAt(i2 + 1) != '*') continue block10;
                        retStr.append(sql.charAt(++i2));
                        inMultiLineComment = true;
                        continue block10;
                    }
                    case '*': {
                        retStr.append(c2);
                        if (inQuotesFlag || !inMultiLineComment || i2 >= sql.length() - 1 || sql.charAt(i2 + 1) != '/') continue block10;
                        retStr.append(sql.charAt(++i2));
                        inMultiLineComment = false;
                        continue block10;
                    }
                    default: {
                        retStr.append(c2);
                    }
                }
            }
            String string2 = retStr.toString();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, Translator.class, $$$methodRef$$$5, this, string2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, Translator.class, $$$methodRef$$$5, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, Translator.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x10000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, Translator.class, $$$methodRef$$$6, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, Translator.class, $$$methodRef$$$6, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, Translator.class, $$$methodRef$$$6, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, Translator.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$7 = Translator.class.getDeclaredConstructor(String.class, File.class, TranslationCache.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = Translator.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = Translator.class.getDeclaredMethod("convertParameterMarkersToOracleStyle", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = Translator.class.getDeclaredMethod("deactivateServerTranslation", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = Translator.class.getDeclaredMethod("activateServerTranslation", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = Translator.class.getDeclaredMethod("translateQuery", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = Translator.class.getDeclaredMethod("translateErrorLocal", SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = Translator.class.getDeclaredMethod("translateError", SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

