/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind;

public enum MapperFeature {
    USE_ANNOTATIONS(true),
    USE_GETTERS_AS_SETTERS(false),
    PROPAGATE_TRANSIENT_MARKER(false),
    REQUIRE_SETTERS_FOR_GETTERS(false),
    ALLOW_FINAL_FIELDS_AS_MUTATORS(false),
    INFER_PROPERTY_MUTATORS(true),
    INFER_CREATOR_FROM_CONSTRUCTOR_PROPERTIES(true),
    ALLOW_IS_GETTERS_FOR_NON_BOOLEAN(false),
    ALLOW_VOID_VALUED_PROPERTIES(true),
    DETECT_PARAMETER_NAMES(true),
    CAN_OVERRIDE_ACCESS_MODIFIERS(true),
    OVERRIDE_PUBLIC_ACCESS_MODIFIERS(true),
    INVERSE_READ_WRITE_ACCESS(false),
    USE_STATIC_TYPING(false),
    USE_BASE_TYPE_AS_DEFAULT_IMPL(false),
    INFER_BUILDER_TYPE_BINDINGS(true),
    REQUIRE_TYPE_ID_FOR_SUBTYPES(true),
    DEFAULT_VIEW_INCLUSION(false),
    SORT_PROPERTIES_ALPHABETICALLY(true),
    SORT_CREATOR_PROPERTIES_FIRST(true),
    ACCEPT_CASE_INSENSITIVE_PROPERTIES(false),
    ACCEPT_CASE_INSENSITIVE_ENUMS(false),
    ACCEPT_CASE_INSENSITIVE_VALUES(false),
    USE_WRAPPER_NAME_AS_PROPERTY_NAME(false),
    ALLOW_EXPLICIT_PROPERTY_RENAMING(false),
    FIX_FIELD_NAME_UPPER_CASE_PREFIX(true),
    ALLOW_COERCION_OF_SCALARS(true),
    IGNORE_MERGE_FOR_UNMERGEABLE(true),
    APPLY_DEFAULT_VALUES(true);

    private final boolean _defaultState;
    private final long _mask;

    public static long collectLongDefaults() {
        long flags = 0L;
        for (MapperFeature value : MapperFeature.values()) {
            if (!value.enabledByDefault()) continue;
            flags |= value.getLongMask();
        }
        return flags;
    }

    private MapperFeature(boolean defaultState) {
        this._defaultState = defaultState;
        this._mask = 1L << this.ordinal();
    }

    public boolean enabledByDefault() {
        return this._defaultState;
    }

    public long getLongMask() {
        return this._mask;
    }

    public boolean enabledIn(long flags) {
        return (flags & this._mask) != 0L;
    }
}

