/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.lang.reflect.Executable;
import java.time.Duration;
import java.util.Arrays;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.Jsonp;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.jdbc.driver.json.tree.JakartaPrimitive;
import oracle.jdbc.driver.json.tree.JsonpPrimitive;
import oracle.sql.INTERVALDS;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonValue;

public class OracleJsonIntervalDSImpl
implements OracleJsonIntervalDS {
    public static final int INTERVALDS_LEN = 11;
    byte[] raw;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    public OracleJsonIntervalDSImpl(byte[] raw) {
        this.raw = raw;
    }

    public OracleJsonIntervalDSImpl(Duration d2) {
        this.raw = OsonPrimitiveConversions.durationToIntervalDS(d2);
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.INTERVALDS;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof OracleJsonIntervalDS)) {
            return false;
        }
        if (!(other instanceof OracleJsonIntervalDSImpl)) {
            throw new UnsupportedOperationException();
        }
        OracleJsonIntervalDSImpl otheri = (OracleJsonIntervalDSImpl)other;
        return Arrays.equals(otheri.raw, this.raw);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.raw);
    }

    @Override
    public String toString() {
        return JsonSerializerImpl.serializeString(this.getString());
    }

    @Override
    public String getString() {
        return OsonPrimitiveConversions.serializeIntervalDS(OracleJsonExceptions.ORACLE_FACTORY, this.raw());
    }

    public byte[] raw() {
        return this.raw;
    }

    @Override
    public Duration getDuration() {
        return OsonPrimitiveConversions.intervalDSToDuration(this.raw());
    }

    public static String serializeDuration(Duration d2, OracleJsonExceptions.ExceptionFactory f2) {
        byte[] raw = OsonPrimitiveConversions.durationToIntervalDS(d2);
        return OsonPrimitiveConversions.serializeIntervalDS(f2, raw);
    }

    @Override
    public INTERVALDS getINTERVALDS() {
        return new INTERVALDS(this.raw());
    }

    @Override
    public <T> T wrap(Class<T> c2) {
        if (Jsonp.isJakartaJson(c2)) {
            return c2.cast(new JakartaPrimitive.JakartaIntervalDSImpl(this.raw));
        }
        return c2.cast(new JsonpPrimitive.JsonpIntervalDSImpl(this.raw));
    }

    static {
        try {
            $$$methodRef$$$11 = OracleJsonIntervalDSImpl.class.getDeclaredConstructor(Duration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleJsonIntervalDSImpl.class.getDeclaredConstructor(byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleJsonIntervalDSImpl.class.getDeclaredMethod("wrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleJsonIntervalDSImpl.class.getDeclaredMethod("getINTERVALDS", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleJsonIntervalDSImpl.class.getDeclaredMethod("serializeDuration", Duration.class, OracleJsonExceptions.ExceptionFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleJsonIntervalDSImpl.class.getDeclaredMethod("getDuration", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleJsonIntervalDSImpl.class.getDeclaredMethod("raw", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleJsonIntervalDSImpl.class.getDeclaredMethod("getString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleJsonIntervalDSImpl.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleJsonIntervalDSImpl.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleJsonIntervalDSImpl.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleJsonIntervalDSImpl.class.getDeclaredMethod("getOracleJsonType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

