/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.binary.OsonHeader;
import oracle.jdbc.driver.json.binary.OsonStructureImpl;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.sql.json.OracleJsonValue;

public abstract class OsonAbstractArray
extends OsonStructureImpl {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;

    public OsonAbstractArray(OsonContext ctx, int pos) {
        super(ctx);
        this.init(pos);
    }

    protected OsonAbstractArray(OsonContext ctx) {
        super(ctx);
    }

    public String getString(int i2) {
        int childOffset = this.getOffsetWithError(i2);
        String result = this.getStringInternal(childOffset);
        if (result == null) {
            throw new ClassCastException();
        }
        return result;
    }

    public boolean getBoolean(int i2) {
        int childOffset = this.getOffsetWithError(i2);
        Boolean result = this.getBooleanInternal(childOffset);
        if (result == null) {
            throw new ClassCastException();
        }
        return result;
    }

    public boolean getBoolean(int i2, boolean d2) {
        int childOffset = this.getChildOffset(i2);
        if (childOffset == -1) {
            return d2;
        }
        Boolean result = this.getBooleanInternal(childOffset);
        if (result == null) {
            return d2;
        }
        return result;
    }

    public int getInt(int i2) {
        int childOffset = this.getOffsetWithError(i2);
        return ((OracleJsonNumberImpl)this.getValueInternal(childOffset)).intValue();
    }

    public int getInt(int i2, int d2) {
        int childOffset = this.getChildOffset(i2);
        if (childOffset == -1) {
            return d2;
        }
        Object o2 = this.getValueInternal(childOffset);
        if (!(o2 instanceof OracleJsonNumberImpl)) {
            return d2;
        }
        OracleJsonNumberImpl n2 = (OracleJsonNumberImpl)o2;
        return n2.intValue();
    }

    public boolean isNull(int i2) {
        int childOffset = this.getOffsetWithError(i2);
        return this.isNullInternal(childOffset);
    }

    public boolean contains(Object value) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            Object c2 = this.getValueInternal(this.getChildOffset(i2));
            if (!c2.equals(value)) continue;
            return true;
        }
        return false;
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size];
        this.copyToArray(result);
        return result;
    }

    public <T> T[] toArray(T[] a2) {
        Object[] r2 = a2.length >= this.size ? a2 : (Object[])Array.newInstance(a2.getClass().getComponentType(), this.size);
        this.copyToArray(r2);
        if (r2.length >= this.size + 1) {
            r2[this.size] = null;
        }
        return r2;
    }

    public boolean remove(Object o2) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection<?> c2) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection<?> c2) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection<?> c2) {
        for (Object o2 : c2) {
            if (this.contains(o2)) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof List)) {
            return false;
        }
        List otherList = (List)o2;
        if (otherList.size() != this.size) {
            return false;
        }
        for (int i2 = 0; i2 < this.size; ++i2) {
            Object value = this.getValueInternal(this.getChildOffset(i2));
            if (value.equals(otherList.get(i2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            Object value = this.getValueInternal(this.getChildOffset(i2));
            hashCode = 31 * hashCode + value.hashCode();
        }
        return hashCode;
    }

    public Object getInternal(int i2) {
        return this.getValueInternal(this.getOffsetWithError(i2));
    }

    public int indexOf(Object o2) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!this.getInternal(i2).equals(o2)) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(Object o2) {
        int result = -1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!this.getInternal(i2).equals(o2)) continue;
            result = i2;
        }
        return result;
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.ARRAY;
    }

    @Override
    protected void init(int pos) {
        super.init(pos);
        int op = this.ctx.b.getUB1(pos);
        this.initChildOffseUb(op);
        int childSizeBits = op & 0x18;
        this.childArrayOffset = pos + 1;
        if (childSizeBits == 0) {
            ++this.childArrayOffset;
            this.size = this.ctx.b.getUB1(pos + 1);
        } else if (childSizeBits == 8) {
            this.childArrayOffset += 2;
            this.size = this.ctx.b.getUB2(pos + 1);
        } else if (childSizeBits == 16) {
            this.childArrayOffset += 4;
            this.size = this.ctx.b.getUB4int(pos + 1);
        }
    }

    @Override
    protected int getChildOffset(int i2) {
        if (i2 < 0 || i2 >= this.size) {
            return -1;
        }
        OsonHeader header = this.ctx.getHeader();
        if (header.relativeOffsets()) {
            if (this.childOffsetUb == 2) {
                short relative = this.ctx.b.getShort(this.childArrayOffset + i2 * 2);
                relative = (short)(relative + (this.pos - header.getTreeSegmentOffset()));
                return (relative & 0xFFFF) + header.getTreeSegmentOffset();
            }
            int relative = this.ctx.b.getInt(this.childArrayOffset + i2 * 4);
            return ((relative += this.pos - header.getTreeSegmentOffset()) & 0xFFFFFFFF) + header.getTreeSegmentOffset();
        }
        if (this.childOffsetUb == 2) {
            return this.ctx.b.getUB2(this.childArrayOffset + i2 * 2) + header.getTreeSegmentOffset();
        }
        return this.ctx.b.getUB4int(this.childArrayOffset + i2 * 4) + header.getTreeSegmentOffset();
    }

    private void copyToArray(Object[] result) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            result[i2] = this.getValueInternal(this.getChildOffset(i2));
        }
    }

    protected int getOffsetWithError(int i2) {
        int childOffset = this.getChildOffset(i2);
        if (childOffset == -1) {
            throw new IndexOutOfBoundsException();
        }
        return childOffset;
    }

    protected <T> AbstractList<T> sublist(final int fromIndex, final int toIndex) {
        if (fromIndex < 0 || toIndex > this.size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        return new AbstractList<T>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            public T get(int index) {
                return OsonAbstractArray.this.getValueInternal(OsonAbstractArray.this.getOffsetWithError(index + fromIndex));
            }

            @Override
            public int size() {
                return toIndex - fromIndex;
            }

            static {
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredConstructor(OsonAbstractArray.class, Integer.TYPE, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("size", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("get", Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        };
    }

    static {
        try {
            $$$methodRef$$$26 = OsonAbstractArray.class.getDeclaredConstructor(OsonContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OsonAbstractArray.class.getDeclaredConstructor(OsonContext.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OsonAbstractArray.class.getDeclaredMethod("sublist", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OsonAbstractArray.class.getDeclaredMethod("getOffsetWithError", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OsonAbstractArray.class.getDeclaredMethod("copyToArray", Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OsonAbstractArray.class.getDeclaredMethod("getChildOffset", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OsonAbstractArray.class.getDeclaredMethod("init", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OsonAbstractArray.class.getDeclaredMethod("getOracleJsonType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OsonAbstractArray.class.getDeclaredMethod("lastIndexOf", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OsonAbstractArray.class.getDeclaredMethod("indexOf", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OsonAbstractArray.class.getDeclaredMethod("getInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OsonAbstractArray.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OsonAbstractArray.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OsonAbstractArray.class.getDeclaredMethod("clear", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OsonAbstractArray.class.getDeclaredMethod("containsAll", Collection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OsonAbstractArray.class.getDeclaredMethod("retainAll", Collection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OsonAbstractArray.class.getDeclaredMethod("removeAll", Collection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OsonAbstractArray.class.getDeclaredMethod("remove", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OsonAbstractArray.class.getDeclaredMethod("toArray", Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OsonAbstractArray.class.getDeclaredMethod("toArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OsonAbstractArray.class.getDeclaredMethod("contains", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OsonAbstractArray.class.getDeclaredMethod("isNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OsonAbstractArray.class.getDeclaredMethod("getInt", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OsonAbstractArray.class.getDeclaredMethod("getInt", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OsonAbstractArray.class.getDeclaredMethod("getBoolean", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OsonAbstractArray.class.getDeclaredMethod("getBoolean", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OsonAbstractArray.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    public class ListIter<T>
    extends ValueIter<T>
    implements ListIterator<T> {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;

        public ListIter(int i2) {
            this.ipos = i2;
        }

        @Override
        public boolean hasPrevious() {
            return this.ipos != 0;
        }

        @Override
        public T previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return (T)OsonAbstractArray.this.getInternal(--this.ipos);
        }

        @Override
        public int nextIndex() {
            return this.ipos;
        }

        @Override
        public int previousIndex() {
            return this.ipos - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(T e2) {
            throw new UnsupportedOperationException();
        }

        static {
            try {
                $$$methodRef$$$8 = ListIter.class.getDeclaredConstructor(OsonAbstractArray.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = ListIter.class.getDeclaredMethod("getValue", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = ListIter.class.getDeclaredMethod("add", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = ListIter.class.getDeclaredMethod("set", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = ListIter.class.getDeclaredMethod("remove", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = ListIter.class.getDeclaredMethod("previousIndex", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = ListIter.class.getDeclaredMethod("nextIndex", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = ListIter.class.getDeclaredMethod("previous", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ListIter.class.getDeclaredMethod("hasPrevious", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    protected class ValueIter<V>
    extends OsonStructureImpl.PositionIter<V> {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;

        protected ValueIter() {
            super(OsonAbstractArray.this);
        }

        @Override
        public V getValue(int pos) {
            return (V)OsonAbstractArray.this.getValueInternal(OsonAbstractArray.this.getChildOffset(pos++));
        }

        static {
            try {
                $$$methodRef$$$1 = ValueIter.class.getDeclaredConstructor(OsonAbstractArray.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ValueIter.class.getDeclaredMethod("getValue", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

