/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIdcb;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CResultSetAccessor
extends ResultSetAccessor {
    T4CMAREngine mare;
    OracleStatement[] newstmt;
    byte[] empty;
    boolean underlyingLongRaw;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;

    T4CResultSetAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, form, external_type, forBind);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$14, null, stmt, max_len, form, external_type, forBind, _mare);
            }
            this.newstmt = null;
            this.empty = new byte[]{0};
            this.underlyingLongRaw = false;
            this.mare = _mare;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$14, null);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$14, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    T4CResultSetAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len == -1 ? _definedColumnSize : max_len, nullable, flags, precision, scale, contflag, total_elems, form);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$15, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form, _definedColumnType, _definedColumnSize, _mare);
            }
            this.newstmt = null;
            this.empty = new byte[]{0};
            this.underlyingLongRaw = false;
            this.mare = _mare;
            if (stmt != null && stmt.implicitDefineForLobPrefetchDone) {
                this.definedColumnType = 0;
                this.definedColumnSize = 0;
            } else {
                this.definedColumnType = _definedColumnType;
                this.definedColumnSize = _definedColumnSize;
            }
            if (max_len == -1) {
                this.underlyingLongRaw = true;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$15, null);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$15, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    public T4CMAREngine getMAREngine() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$0, this, new Object[0]);
            }
            T4CMAREngine t4CMAREngine = this.mare;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$0, this, t4CMAREngine);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$0, this, null);
            }
            return t4CMAREngine;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    public void unmarshalColumnMetadata() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$1, this, new Object[0]);
            }
            if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
                this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void processIndicator(int n2) throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$2, this, n2);
            }
            if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
                this.mare.unmarshalSB2();
                this.mare.unmarshalUB2();
            } else if (this.statement.connection.versionNumber < 9200) {
                this.mare.unmarshalSB2();
                if (!this.statement.sqlKind.isPlsqlOrCall()) {
                    this.mare.unmarshalSB2();
                }
            } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
                void size;
                this.mare.processIndicator(size <= 0, (int)size);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    int getPreviousRowProcessed() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$3, this, new Object[0]);
            }
            if (this.previousRowProcessed == -1) {
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            }
            int n2 = this.previousRowProcessed;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$3, this, n2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$3, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void reinitForResultSetCache(ByteArray byteArray, OracleStatement oracleStatement) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void stmt;
            void dba;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$4, this, byteArray, oracleStatement);
            }
            this.rowData = dba;
            this.mare = ((T4CConnection)stmt.connection).mare;
            this.rowNull = null;
            this.setCapacity(stmt.getFetchSize());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$5, this, new Object[0]);
            }
            boolean isStream = false;
            if (!this.isUseless()) {
                if (this.isUnexpected()) {
                    long pos = this.rowData.getPosition();
                    this.unmarshalColumnMetadata();
                    this.unmarshalBytes();
                    this.rowData.setPosition(pos);
                    this.setNull(this.lastRowProcessed, true);
                } else if (this.isNullByDescribe()) {
                    this.setNull(this.lastRowProcessed, true);
                    this.unmarshalColumnMetadata();
                    if (this.statement.connection.versionNumber < 9200) {
                        this.processIndicator(0);
                    }
                } else {
                    this.unmarshalColumnMetadata();
                    isStream = this.unmarshalBytes();
                }
            }
            this.previousRowProcessed = this.lastRowProcessed++;
            boolean bl2 = isStream;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$5, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$5, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void copyRow() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$6, this, new Object[0]);
            }
            if (this.isNullByDescribe || this.previousRowProcessed == -1) {
                this.setNull(this.lastRowProcessed, true);
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            } else if (this.lastRowProcessed == 0) {
                if (this.previousRowProcessed == -1) {
                    this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
                }
                long previousOffset = this.getOffset(this.previousRowProcessed);
                this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
                this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
                if (!this.isNull(this.previousRowProcessed)) {
                    this.setOffset(this.lastRowProcessed);
                    ((DynamicByteArray)this.rowData).copyLeft(previousOffset, this.getLength(this.previousRowProcessed));
                    this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
                }
            } else if (this.lastCopyRow == this.previousRowProcessed) {
                this.setNull(this.lastRowProcessed, this.lastCopyRowIsNull);
                this.rowMetadata[this.lastRowProcessed] = this.lastCopyRowMetaData;
                this.setOffset(this.lastRowProcessed, this.lastCopyRowOffset);
                this.setLength(this.lastRowProcessed, this.lastCopyRowLength);
            } else {
                this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
                this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
                this.setOffset(this.lastRowProcessed, this.getOffset(this.previousRowProcessed));
                this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
            }
            this.previousRowProcessed = this.lastRowProcessed++;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void setCapacity(int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void capacity;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$7, this, n2);
            }
            super.setCapacity((int)capacity);
            if (this.newstmt == null || this.newstmt.length < capacity) {
                OracleStatement[] tmp = new OracleStatement[capacity];
                if (this.newstmt != null) {
                    System.arraycopy(this.newstmt, 0, tmp, 0, this.newstmt.length);
                }
                this.newstmt = tmp;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void insertNull(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void rowIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$8, this, n2);
            }
            System.arraycopy(this.newstmt, (int)rowIndex, this.newstmt, (int)(rowIndex + true), this.newstmt.length - rowIndex - 1);
            super.insertNull((int)rowIndex);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Accessor copyForDefine(OracleStatement oracleStatement) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void dest;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$9, this, oracleStatement);
            }
            T4CResultSetAccessor acc = (T4CResultSetAccessor)super.copyForDefine((OracleStatement)dest);
            acc.newstmt = null;
            T4CResultSetAccessor t4CResultSetAccessor = acc;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$9, this, t4CResultSetAccessor);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$9, this, null);
            }
            return t4CResultSetAccessor;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void copyFromInternal(Accessor accessor, int n2, int n3) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void destRow;
            void srcRow;
            void srcAcc;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$10, this, accessor, n2, n3);
            }
            super.copyFromInternal((Accessor)srcAcc, (int)srcRow, (int)destRow);
            this.newstmt[destRow] = ((T4CResultSetAccessor)srcAcc).newstmt[srcRow];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void deleteRow(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void row;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$11, this, n2);
            }
            super.deleteRow((int)row);
            if (this.newstmt[row] != null) {
                this.newstmt[row].close();
            }
            this.delete(this.newstmt, (int)row);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean unmarshalBytes() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$12, this, new Object[0]);
            }
            this.newstmt[this.lastRowProcessed] = this.statement.connection.RefCursorBytesToStatement(this.empty, this.statement);
            this.newstmt[this.lastRowProcessed].needToSendOalToFetch = true;
            T4CTTIdcb dcb = new T4CTTIdcb((T4CConnection)this.statement.connection);
            dcb.init(this.newstmt[this.lastRowProcessed], 0);
            this.newstmt[this.lastRowProcessed].accessors = dcb.receiveFromRefCursor(this.newstmt[this.lastRowProcessed].accessors);
            this.newstmt[this.lastRowProcessed].numberOfDefinePositions = this.newstmt[this.lastRowProcessed].accessors.length;
            this.newstmt[this.lastRowProcessed].describedWithNames = true;
            this.newstmt[this.lastRowProcessed].described = true;
            int cursorId = (int)this.mare.unmarshalUB4();
            this.newstmt[this.lastRowProcessed].setCursorId(cursorId);
            if (cursorId > 0) {
                this.rowData.putShort((short)cursorId);
                this.setLength(this.lastRowProcessed, 2);
                this.processIndicator(2);
            } else {
                this.newstmt[this.lastRowProcessed].close();
                this.newstmt[this.lastRowProcessed] = null;
                this.setNull(this.lastRowProcessed, true);
                this.processIndicator(0);
            }
            boolean bl2 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$12, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$12, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    ResultSet getCursor(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$13, this, n2);
            }
            OracleResultSet rset = null;
            if (this.newstmt[currentRow] != null) {
                OracleResultSet rsetimpl;
                for (int i2 = 0; i2 < this.newstmt[currentRow].numberOfDefinePositions; ++i2) {
                    this.newstmt[currentRow].accessors[i2].initMetadata();
                }
                this.newstmt[currentRow].prepareAccessors();
                this.newstmt[currentRow].setPrefetchInternal(this.statement.getFetchSize(), false, false);
                this.newstmt[currentRow].closeOnCompletion();
                this.newstmt[currentRow].currentResultSet = rsetimpl = this.newstmt[currentRow].createResultSet();
                rset = rsetimpl;
            }
            OracleResultSet oracleResultSet = rset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$13, this, oracleResultSet);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$13, this, null);
            }
            return oracleResultSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CResultSetAccessor.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$15 = T4CResultSetAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, Integer.TYPE, Integer.TYPE, T4CMAREngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4CResultSetAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE, T4CMAREngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4CResultSetAccessor.class.getDeclaredMethod("getCursor", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4CResultSetAccessor.class.getDeclaredMethod("unmarshalBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CResultSetAccessor.class.getDeclaredMethod("deleteRow", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CResultSetAccessor.class.getDeclaredMethod("copyFromInternal", Accessor.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CResultSetAccessor.class.getDeclaredMethod("copyForDefine", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CResultSetAccessor.class.getDeclaredMethod("insertNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CResultSetAccessor.class.getDeclaredMethod("setCapacity", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CResultSetAccessor.class.getDeclaredMethod("copyRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CResultSetAccessor.class.getDeclaredMethod("unmarshalOneRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CResultSetAccessor.class.getDeclaredMethod("reinitForResultSetCache", ByteArray.class, OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CResultSetAccessor.class.getDeclaredMethod("getPreviousRowProcessed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CResultSetAccessor.class.getDeclaredMethod("processIndicator", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CResultSetAccessor.class.getDeclaredMethod("unmarshalColumnMetadata", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CResultSetAccessor.class.getDeclaredMethod("getMAREngine", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

