/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.engine.AbstractProcessableElementTag;
import org.thymeleaf.engine.AttributeDefinition;
import org.thymeleaf.engine.AttributeDefinitions;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.TemplateData;
import org.thymeleaf.inline.IInliner;
import org.thymeleaf.model.AttributeValueQuotes;
import org.thymeleaf.model.IModel;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.util.Validate;

public final class ElementTagStructureHandler
implements IElementTagStructureHandler {
    boolean setBodyText;
    CharSequence setBodyTextValue;
    boolean setBodyTextProcessable;
    boolean setBodyModel;
    IModel setBodyModelValue;
    boolean setBodyModelProcessable;
    boolean insertBeforeModel;
    IModel insertBeforeModelValue;
    boolean insertImmediatelyAfterModel;
    IModel insertImmediatelyAfterModelValue;
    boolean insertImmediatelyAfterModelProcessable;
    boolean replaceWithText;
    CharSequence replaceWithTextValue;
    boolean replaceWithTextProcessable;
    boolean replaceWithModel;
    IModel replaceWithModelValue;
    boolean replaceWithModelProcessable;
    boolean removeElement;
    boolean removeTags;
    boolean removeBody;
    boolean removeAllButFirstChild;
    boolean setLocalVariable;
    Map<String, Object> addedLocalVariables;
    boolean removeLocalVariable;
    Set<String> removedLocalVariableNames;
    boolean setAttribute;
    Object[][] setAttributeValues;
    int setAttributeValuesSize;
    boolean replaceAttribute;
    Object[][] replaceAttributeValues;
    int replaceAttributeValuesSize;
    boolean removeAttribute;
    Object[][] removeAttributeValues;
    int removeAttributeValuesSize;
    boolean setSelectionTarget;
    Object selectionTargetObject;
    boolean setInliner;
    IInliner setInlinerValue;
    boolean setTemplateData;
    TemplateData setTemplateDataValue;
    boolean iterateElement;
    String iterVariableName;
    String iterStatusVariableName;
    Object iteratedObject;

    ElementTagStructureHandler() {
        this.reset();
    }

    @Override
    public void setBody(CharSequence text, boolean processable) {
        this.resetAllButVariablesOrAttributes();
        Validate.notNull(text, "Text cannot be null");
        this.setBodyText = true;
        this.setBodyTextValue = text;
        this.setBodyTextProcessable = processable;
    }

    @Override
    public void setBody(IModel model, boolean processable) {
        this.resetAllButVariablesOrAttributes();
        Validate.notNull(model, "Model cannot be null");
        this.setBodyModel = true;
        this.setBodyModelValue = model;
        this.setBodyModelProcessable = processable;
    }

    @Override
    public void insertBefore(IModel model) {
        this.resetAllButVariablesOrAttributes();
        Validate.notNull(model, "Model cannot be null");
        this.insertBeforeModel = true;
        this.insertBeforeModelValue = model;
    }

    @Override
    public void insertImmediatelyAfter(IModel model, boolean processable) {
        this.resetAllButVariablesOrAttributes();
        Validate.notNull(model, "Model cannot be null");
        this.insertImmediatelyAfterModel = true;
        this.insertImmediatelyAfterModelValue = model;
        this.insertImmediatelyAfterModelProcessable = processable;
    }

    @Override
    public void replaceWith(CharSequence text, boolean processable) {
        this.resetAllButVariablesOrAttributes();
        Validate.notNull(text, "Text cannot be null");
        this.replaceWithText = true;
        this.replaceWithTextValue = text;
        this.replaceWithTextProcessable = processable;
    }

    @Override
    public void replaceWith(IModel model, boolean processable) {
        this.resetAllButVariablesOrAttributes();
        Validate.notNull(model, "Model cannot be null");
        this.replaceWithModel = true;
        this.replaceWithModelValue = model;
        this.replaceWithModelProcessable = processable;
    }

    @Override
    public void removeElement() {
        this.resetAllButVariablesOrAttributes();
        this.removeElement = true;
    }

    @Override
    public void removeTags() {
        this.resetAllButVariablesOrAttributes();
        this.removeTags = true;
    }

    @Override
    public void removeBody() {
        this.resetAllButVariablesOrAttributes();
        this.removeBody = true;
    }

    @Override
    public void removeAllButFirstChild() {
        this.resetAllButVariablesOrAttributes();
        this.removeAllButFirstChild = true;
    }

    @Override
    public void removeLocalVariable(String name) {
        Validate.notNull(name, "Variable name cannot be null");
        this.removeLocalVariable = true;
        if (this.removedLocalVariableNames == null) {
            this.removedLocalVariableNames = new HashSet<String>(3);
        }
        this.removedLocalVariableNames.add(name);
    }

    @Override
    public void setLocalVariable(String name, Object value) {
        Validate.notNull(name, "Variable name cannot be null");
        this.setLocalVariable = true;
        if (this.addedLocalVariables == null) {
            this.addedLocalVariables = new HashMap<String, Object>(3);
        }
        this.addedLocalVariables.put(name, value);
    }

    @Override
    public void setAttribute(String attributeName, String attributeValue) {
        Validate.notNull(attributeName, "Attribute name cannot be null");
        this.ensureSetAttributeSize();
        this.setAttribute = true;
        Object[] values = this.setAttributeValues[this.setAttributeValuesSize];
        values[0] = null;
        values[1] = attributeName;
        values[2] = attributeValue;
        values[3] = null;
        ++this.setAttributeValuesSize;
    }

    @Override
    public void setAttribute(String attributeName, String attributeValue, AttributeValueQuotes attributeValueQuotes) {
        Validate.notNull(attributeName, "Attribute name cannot be null");
        this.ensureSetAttributeSize();
        this.setAttribute = true;
        Object[] values = this.setAttributeValues[this.setAttributeValuesSize];
        values[0] = null;
        values[1] = attributeName;
        values[2] = attributeValue;
        values[3] = attributeValueQuotes;
        ++this.setAttributeValuesSize;
    }

    public void setAttribute(AttributeDefinition attributeDefinition, String attributeName, String attributeValue, AttributeValueQuotes attributeValueQuotes) {
        Validate.notNull(attributeDefinition, "Attribute definition cannot be null");
        Validate.notNull(attributeName, "Attribute name cannot be null");
        this.ensureSetAttributeSize();
        this.setAttribute = true;
        Object[] values = this.setAttributeValues[this.setAttributeValuesSize];
        values[0] = attributeDefinition;
        values[1] = attributeName;
        values[2] = attributeValue;
        values[3] = attributeValueQuotes;
        ++this.setAttributeValuesSize;
    }

    private void ensureSetAttributeSize() {
        if (this.setAttributeValues == null) {
            this.setAttributeValues = new Object[3][];
        }
        if (this.setAttributeValues.length == this.setAttributeValuesSize) {
            this.setAttributeValues = (Object[][])Arrays.copyOf(this.setAttributeValues, this.setAttributeValues.length + 3);
        }
        if (this.setAttributeValues[this.setAttributeValuesSize] == null) {
            this.setAttributeValues[this.setAttributeValuesSize] = new Object[4];
        }
    }

    @Override
    public void replaceAttribute(AttributeName oldAttributeName, String attributeName, String attributeValue) {
        Validate.notNull(oldAttributeName, "Old attribute name cannot be null");
        Validate.notNull(attributeName, "Attribute name cannot be null");
        this.ensureReplaceAttributeSize();
        this.replaceAttribute = true;
        Object[] values = this.replaceAttributeValues[this.replaceAttributeValuesSize];
        values[0] = oldAttributeName;
        values[1] = null;
        values[2] = attributeName;
        values[3] = attributeValue;
        values[4] = null;
        ++this.replaceAttributeValuesSize;
    }

    @Override
    public void replaceAttribute(AttributeName oldAttributeName, String attributeName, String attributeValue, AttributeValueQuotes attributeValueQuotes) {
        Validate.notNull(oldAttributeName, "Old attribute name cannot be null");
        Validate.notNull(attributeName, "Attribute name cannot be null");
        this.ensureReplaceAttributeSize();
        this.replaceAttribute = true;
        Object[] values = this.replaceAttributeValues[this.replaceAttributeValuesSize];
        values[0] = oldAttributeName;
        values[1] = null;
        values[2] = attributeName;
        values[3] = attributeValue;
        values[4] = attributeValueQuotes;
        ++this.replaceAttributeValuesSize;
    }

    public void replaceAttribute(AttributeName oldAttributeName, AttributeDefinition attributeDefinition, String attributeName, String attributeValue, AttributeValueQuotes attributeValueQuotes) {
        Validate.notNull(oldAttributeName, "Old attribute name cannot be null");
        Validate.notNull(attributeDefinition, "Attribute definition cannot be null");
        Validate.notNull(attributeName, "Attribute name cannot be null");
        this.ensureReplaceAttributeSize();
        this.replaceAttribute = true;
        Object[] values = this.replaceAttributeValues[this.replaceAttributeValuesSize];
        values[0] = oldAttributeName;
        values[1] = attributeDefinition;
        values[2] = attributeName;
        values[3] = attributeValue;
        values[4] = attributeValueQuotes;
        ++this.replaceAttributeValuesSize;
    }

    private void ensureReplaceAttributeSize() {
        if (this.replaceAttributeValues == null) {
            this.replaceAttributeValues = new Object[3][];
        }
        if (this.replaceAttributeValues.length == this.replaceAttributeValuesSize) {
            this.replaceAttributeValues = (Object[][])Arrays.copyOf(this.replaceAttributeValues, this.replaceAttributeValues.length + 3);
        }
        if (this.replaceAttributeValues[this.replaceAttributeValuesSize] == null) {
            this.replaceAttributeValues[this.replaceAttributeValuesSize] = new Object[5];
        }
    }

    @Override
    public void removeAttribute(String attributeName) {
        Validate.notNull(attributeName, "Attribute name cannot be null");
        this.ensureRemoveAttributeSize();
        this.removeAttribute = true;
        Object[] values = this.removeAttributeValues[this.removeAttributeValuesSize];
        values[0] = attributeName;
        values[1] = null;
        ++this.removeAttributeValuesSize;
    }

    @Override
    public void removeAttribute(String prefix, String name) {
        Validate.notNull(name, "Attribute name cannot be null");
        this.ensureRemoveAttributeSize();
        this.removeAttribute = true;
        Object[] values = this.removeAttributeValues[this.removeAttributeValuesSize];
        values[0] = prefix;
        values[1] = name;
        ++this.removeAttributeValuesSize;
    }

    @Override
    public void removeAttribute(AttributeName attributeName) {
        Validate.notNull(attributeName, "Attribute name cannot be null");
        this.ensureRemoveAttributeSize();
        this.removeAttribute = true;
        Object[] values = this.removeAttributeValues[this.removeAttributeValuesSize];
        values[0] = attributeName;
        values[1] = null;
        ++this.removeAttributeValuesSize;
    }

    private void ensureRemoveAttributeSize() {
        if (this.removeAttributeValues == null) {
            this.removeAttributeValues = new Object[3][];
        }
        if (this.removeAttributeValues.length == this.removeAttributeValuesSize) {
            this.removeAttributeValues = (Object[][])Arrays.copyOf(this.removeAttributeValues, this.removeAttributeValues.length + 3);
        }
        if (this.removeAttributeValues[this.removeAttributeValuesSize] == null) {
            this.removeAttributeValues[this.removeAttributeValuesSize] = new Object[2];
        }
    }

    @Override
    public void setSelectionTarget(Object selectionTarget) {
        this.setSelectionTarget = true;
        this.selectionTargetObject = selectionTarget;
    }

    @Override
    public void setInliner(IInliner inliner) {
        this.setInliner = true;
        this.setInlinerValue = inliner;
    }

    @Override
    public void setTemplateData(TemplateData templateData) {
        this.setTemplateData = true;
        this.setTemplateDataValue = templateData;
    }

    @Override
    public void iterateElement(String iterVariableName, String iterStatusVariableName, Object iteratedObject) {
        Validate.notEmpty(iterVariableName, "Iteration variable name cannot be null");
        this.resetAllButVariablesOrAttributes();
        this.iterateElement = true;
        this.iterVariableName = iterVariableName;
        this.iterStatusVariableName = iterStatusVariableName;
        this.iteratedObject = iteratedObject;
    }

    @Override
    public void reset() {
        this.resetAllButVariablesOrAttributes();
        this.setLocalVariable = false;
        if (this.addedLocalVariables != null && this.addedLocalVariables.size() > 0) {
            this.addedLocalVariables.clear();
        }
        this.removeLocalVariable = false;
        if (this.removedLocalVariableNames != null && this.removedLocalVariableNames.size() > 0) {
            this.removedLocalVariableNames.clear();
        }
        this.setSelectionTarget = false;
        this.selectionTargetObject = null;
        this.setInliner = false;
        this.setInlinerValue = null;
        this.setTemplateData = false;
        this.setTemplateDataValue = null;
        this.setAttribute = false;
        this.setAttributeValuesSize = 0;
        this.replaceAttribute = false;
        this.replaceAttributeValuesSize = 0;
        this.removeAttribute = false;
        this.removeAttributeValuesSize = 0;
    }

    private void resetAllButVariablesOrAttributes() {
        this.setBodyText = false;
        this.setBodyTextValue = null;
        this.setBodyTextProcessable = false;
        this.setBodyModel = false;
        this.setBodyModelValue = null;
        this.setBodyModelProcessable = false;
        this.insertBeforeModel = false;
        this.insertBeforeModelValue = null;
        this.insertImmediatelyAfterModel = false;
        this.insertImmediatelyAfterModelValue = null;
        this.insertImmediatelyAfterModelProcessable = false;
        this.replaceWithText = false;
        this.replaceWithTextValue = null;
        this.replaceWithTextProcessable = false;
        this.replaceWithModel = false;
        this.replaceWithModelValue = null;
        this.replaceWithModelProcessable = false;
        this.removeElement = false;
        this.removeTags = false;
        this.removeBody = false;
        this.removeAllButFirstChild = false;
        this.iterateElement = false;
        this.iterVariableName = null;
        this.iterStatusVariableName = null;
        this.iteratedObject = null;
    }

    void applyContextModifications(IEngineContext engineContext) {
        if (engineContext == null) {
            return;
        }
        if (this.setLocalVariable) {
            engineContext.setVariables(this.addedLocalVariables);
        }
        if (this.removeLocalVariable) {
            for (String variableName : this.removedLocalVariableNames) {
                engineContext.removeVariable(variableName);
            }
        }
        if (this.setSelectionTarget) {
            engineContext.setSelectionTarget(this.selectionTargetObject);
        }
        if (this.setInliner) {
            engineContext.setInliner(this.setInlinerValue);
        }
        if (this.setTemplateData) {
            engineContext.setTemplateData(this.setTemplateDataValue);
        }
    }

    <T extends AbstractProcessableElementTag> T applyAttributes(AttributeDefinitions attributeDefinitions, T tag) {
        Object[] values;
        int i;
        Object ttag = tag;
        if (this.removeAttribute) {
            for (i = 0; i < this.removeAttributeValuesSize; ++i) {
                values = this.removeAttributeValues[i];
                ttag = values[1] != null ? ttag.removeAttribute((String)values[0], (String)values[1]) : (values[0] instanceof AttributeName ? ttag.removeAttribute((AttributeName)values[0]) : ttag.removeAttribute((String)values[0]));
            }
        }
        if (this.replaceAttribute) {
            for (i = 0; i < this.replaceAttributeValuesSize; ++i) {
                values = this.replaceAttributeValues[i];
                ttag = ttag.replaceAttribute(attributeDefinitions, (AttributeName)values[0], (AttributeDefinition)values[1], (String)values[2], (String)values[3], (AttributeValueQuotes)((Object)values[4]));
            }
        }
        if (this.setAttribute) {
            for (i = 0; i < this.setAttributeValuesSize; ++i) {
                values = this.setAttributeValues[i];
                ttag = ttag.setAttribute(attributeDefinitions, (AttributeDefinition)values[0], (String)values[1], (String)values[2], (AttributeValueQuotes)((Object)values[3]));
            }
        }
        return ttag;
    }
}

