#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 what4
version:              1.6
visibility:           public
id:                   what4-1.6-Ja8ZHoJ4GndDzdEYr254Hx
key:                  what4-1.6-Ja8ZHoJ4GndDzdEYr254Hx
license:              BSD-3-Clause
copyright:            (c) Galois, Inc 2014-2023
maintainer:           rscott@galois.com, kquick@galois.com
author:               Galois Inc.
homepage:             https://github.com/GaloisInc/what4
synopsis:             Solver-agnostic symbolic values support for issuing queries
description:
    What4 is a generic library for representing values as symbolic formulae which may
    contain references to symbolic values, representing unknown variables.
    It provides support for communicating with a variety of SAT and SMT solvers,
    including Z3, CVC4, CVC5, Yices, Bitwuzla, Boolector, STP, and dReal.
    The data representation types make heavy use of GADT-style type indices
    to ensure type-correct manipulation of symbolic values.

category:             Formal Methods, Theorem Provers, Symbolic Computation, SMT
abi:                  0a0d9c523b85ca2977abaac1188f6c1c
exposed:              True
exposed-modules:
    Test.Verification What4.BaseTypes What4.Concrete What4.Config
    What4.Expr What4.Expr.Allocator What4.Expr.App What4.Expr.AppTheory
    What4.Expr.ArrayUpdateMap What4.Expr.BoolMap What4.Expr.Builder
    What4.Expr.GroundEval What4.Expr.MATLAB What4.Expr.Simplify
    What4.Expr.StringSeq What4.Expr.UnaryBV
    What4.Expr.VarIdentification What4.Expr.WeightedSum What4.FloatMode
    What4.FunctionName What4.IndexLit What4.Interface
    What4.InterpretedFloatingPoint What4.LabeledPred What4.Panic
    What4.Partial What4.ProblemFeatures What4.ProgramLoc
    What4.Protocol.Online What4.Protocol.PolyRoot
    What4.Protocol.ReadDecimal What4.Protocol.SExp
    What4.Protocol.SMTLib2 What4.Protocol.SMTLib2.Parse
    What4.Protocol.SMTLib2.Response What4.Protocol.SMTLib2.Syntax
    What4.Protocol.SMTWriter What4.Protocol.VerilogWriter
    What4.Protocol.VerilogWriter.ABCVerilog
    What4.Protocol.VerilogWriter.AST
    What4.Protocol.VerilogWriter.Backend What4.SFloat What4.SWord
    What4.SatResult What4.SemiRing What4.Serialize.FastSExpr
    What4.Serialize.Log What4.Serialize.Normalize
    What4.Serialize.Parser What4.Serialize.Printer
    What4.Serialize.SETokens What4.Solver What4.Solver.Adapter
    What4.Solver.Bitwuzla What4.Solver.Boolector What4.Solver.CVC4
    What4.Solver.CVC5 What4.Solver.DReal What4.Solver.ExternalABC
    What4.Solver.STP What4.Solver.Yices What4.Solver.Z3
    What4.SpecialFunctions What4.Symbol What4.Utils.AbstractDomains
    What4.Utils.AnnotatedMap What4.Utils.Arithmetic
    What4.Utils.BVDomain What4.Utils.BVDomain.Arith
    What4.Utils.BVDomain.Bitwise What4.Utils.BVDomain.XOR
    What4.Utils.Complex What4.Utils.Endian What4.Utils.Environment
    What4.Utils.FloatHelpers What4.Utils.HandleReader
    What4.Utils.IncrHash What4.Utils.LeqMap What4.Utils.MonadST
    What4.Utils.OnlyIntRepr What4.Utils.Process
    What4.Utils.ResolveBounds.BV What4.Utils.Serialize
    What4.Utils.Streams What4.Utils.StringLiteral What4.Utils.Versions
    What4.Utils.Word16String What4.WordMap

import-dirs:          /usr/lib/ghc-9.4.8/site-local/what4-1.6
library-dirs:         /usr/lib/ghc-9.4.8/site-local/what4-1.6
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/what4-1.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-what4
hs-libraries:         HSwhat4-1.6-Ja8ZHoJ4GndDzdEYr254Hx
depends:
    BoundedChan-1.0.3.0-LpypBc0eid95svZdMy7DB6
    async-2.2.5-HN0qvlEHg8UJWHhrUVAn33
    attoparsec-0.14.4-LQtEgQtiyVz1VW0BNcPBCE base-4.17.2.1
    bifunctors-5.6.2-8xUOLzX1S3EDLz7f7fpjrz
    bimap-0.5.0-GIWcKRVLcge1RwFm4mA2Qm
    bv-sized-1.0.6-CTNgVS0bSi0Cal0NzASxaY bytestring-0.11.5.3
    concurrent-extra-0.7.0.12-5mm5mZPnYcY9wADLPDqaWX
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    deepseq-1.4.8.0 deriving-compat-0.6.7-20e2QnLW3Op4hvE6TPaTiR
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    fingertree-0.1.6.2-b7l7uhU2fS5DfNsWN1mGi ghc-prim-0.9.1
    hashable-1.4.7.0-5RC0vb199EtDGUMphsJuko
    hashtables-1.4.2-AVMtYfb3G9aA7VBJwfyUN3
    io-streams-1.5.2.2-K3ZQmONHmVa7oeadrtOqSo
    lens-5.3.3-JbVUFNwOeNUGLciYleU4If
    libBF-0.6.6-6FS5hRAeX70H3B4lZJU5ij
    megaparsec-9.7.0-1JRkSOE0CLKI56z4E4coO3 mtl-2.2.2
    ordered-containers-0.2.4-5kPssUtGfbk3KH405kLpj1
    panic-0.4.0.1-3QvhbYIlGoL4pBeY3qhGHr
    parameterized-utils-2.1.10.0-JyLCrRSfQAsJTehHrqVew3 parsec-3.1.16.1
    prettyprinter-1.7.1-158pI0o122BKJZoFMaU38n process-1.6.18.0
    s-cargot-0.1.6.0-G4L1NPBEf3x6ZrVw3t3qU2
    scientific-0.3.8.0-9gOL1qaAy2CzOZP0iULD0 stm-2.5.1.0
    template-haskell-2.19.0.0 temporary-1.3-Jo3GPHqXt7U7op7E9Rmxl4
    text-2.0.2 th-lift-0.8.6-HRVeiGNnDxNElRy2LmdExl
    th-lift-instances-0.1.20-BZNecExsDyd4oABspqf33r time-1.12.2
    transformers-0.5.6.2 unliftio-0.2.25.1-JjQQww1AUCb2qXd5w6TvbD
    unordered-containers-0.2.20.1-IBPGLFAI2UT5SDMJrMkgk8
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    vector-0.13.2.0-JUxTFkVHiOCDvdzFqkdqvm
    versions-6.0.8-8xFtRmrAO5gHflIfohMX7Q
    zenc-0.1.2-6Zx89PXlxQvJFxB1XSpuZS

haddock-interfaces:   /usr/share/doc/haskell-what4/html/what4.haddock
haddock-html:         /usr/share/doc/haskell-what4/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

