#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tamarin-prover-accountability
version:              1.10.0
visibility:           public
id:                   tamarin-prover-accountability-1.10.0-5c8pLz5UYR6CprmpHMpsa0
key:                  tamarin-prover-accountability-1.10.0-5c8pLz5UYR6CprmpHMpsa0
license:              LicenseRef-GPL
copyright:            (c) 2019-2021 Robert Künnemann, Kevin Morio & Yavor Ivanov
maintainer:           Robert Künnemann <robert@kunnemann.de>
author:
    Robert Künnemann <robert@kunnemann.de>,
    Kevin Morio <kevin.morio@cispa.de>,
    Yavor Ivanov <yavor.ivanov@cispa.de>

homepage:             https://tamarin-prover.github.io/
synopsis:             Library for accountability for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides support for accountability verification.

category:             Theorem Provers
abi:                  ff5d752a0f2162d80ad24615d3277701
exposed:              True
exposed-modules:      Accountability Accountability.Generation
import-dirs:
    /usr/lib/ghc-9.4.8/site-local/tamarin-prover-accountability-1.10.0

library-dirs:
    /usr/lib/ghc-9.4.8/site-local/tamarin-prover-accountability-1.10.0

library-dirs-static:
    /usr/lib/ghc-9.4.8/site-local/tamarin-prover-accountability-1.10.0

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-accountability
hs-libraries:
    HStamarin-prover-accountability-1.10.0-5c8pLz5UYR6CprmpHMpsa0

depends:
    aeson-2.1.2.1-LEWFZomfRabp1ORmI1Rne
    aeson-pretty-0.8.10-3EriKxX8fC4C6Y9DlTYVfw base-4.17.2.1
    binary-0.8.9.1 bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.0
    dlist-1.0-E99MqJW5mmB4kr4PCgIESI exceptions-0.10.5
    fclabels-2.0.5.1-8aSj00cdkidKy84gZGG2oZ mtl-2.2.2
    parallel-3.2.2.0-KJ5o3ImR3G8wdLWLqGjpy parsec-3.1.16.1
    process-1.6.18.0 raw-strings-qq-1.1-73kb7SizjX3bDDbE8dc5y
    safe-0.3.21-Bbk2Vieba7fJdNA7Fx2QS4
    tamarin-prover-term-1.10.0-CFGiX5aAfQd9z67DvAqdxc
    tamarin-prover-theory-1.10.0-1fBKUtfp2bJJnTZjEbKD8V
    tamarin-prover-utils-1.10.0-DuVCxqfnl32H27d367RMPh text-2.0.2
    transformers-0.5.6.2 uniplate-1.6.13-CSMcjXYrQL32P6m8xDD9BB

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-accountability/html/tamarin-prover-accountability.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-accountability/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

