#!/usr/bin/perl

package eBay::API::XML::DataType::AccountEntryType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. AccountEntryType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::AccountEntryType

=head1 DESCRIPTION

Contains the data for a single account detail entry. Each detail entry is a
transaction posted to the account and may be: a credit, a debit, or an
administrative action (such as an update putting a credit card on file for
the account). You can uniquely identify
the entries that the GetAccount call returns within the AccountEntries tag.
Specifically, the following fields, returned within the AccountEntries tag,
can be used in combination as a unique key: AccountEntry.Date, AccountEntry.AccountDetailsEntryType,
AccountEntry.ItemID, and AccountEntry.RefNumber.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::AccountEntryType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::Enum::AccountDetailEntryCodeType;


my @gaProperties = ( [ 'AccountDetailsEntryType', 'ns:AccountDetailEntryCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::AccountDetailEntryCodeType', '' ]
	, [ 'Balance', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'Date', 'xs:dateTime', '', '', '' ]
	, [ 'Description', 'xs:string', '', '', '' ]
	, [ 'GrossDetailAmount', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'ItemID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'Memo', 'xs:string', '', '', '' ]
	, [ 'NetDetailAmount', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'RefNumber', 'xs:string', '', '', '' ]
	, [ 'Title', 'xs:string', '', '', '' ]
	, [ 'VATPercent', 'xs:decimal', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAccountDetailsEntryType()

Indicates the type of transaction or reason for the transaction. For example,
a value of FeeGallery indicates a debit for listing an item in the Gallery.
Possible values are enumerated in the AccountDetailEntryCodeType code list.

#    Argument: 'ns:AccountDetailEntryCodeType'

=cut

sub setAccountDetailsEntryType {
  my $self = shift;
  $self->{'AccountDetailsEntryType'} = shift
}

=head2 getAccountDetailsEntryType()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'ns:AccountDetailEntryCodeType'

=cut

sub getAccountDetailsEntryType {
  my $self = shift;
  return $self->{'AccountDetailsEntryType'};
}


=head2 setBalance()

Balance after the account entry's credit or debit amount has been applied.
Can be 0.00. The value is positive for debits
and negative for credits.

#    Argument: 'ns:AmountType'

=cut

sub setBalance {
  my $self = shift;
  $self->{'Balance'} = shift
}

=head2 getBalance()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'ns:AmountType'

=cut

sub getBalance {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Balance'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setDate()

Date entry was posted to the account, in GMT. (Also see the Data Types
appendix for more information on how GMT dates are handled in SOAP.)

#    Argument: 'xs:dateTime'

=cut

sub setDate {
  my $self = shift;
  $self->{'Date'} = shift
}

=head2 getDate()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'xs:dateTime'

=cut

sub getDate {
  my $self = shift;
  return $self->{'Date'};
}


=head2 setDescription()

A description of the transaction.

#    Argument: 'xs:string'

=cut

sub setDescription {
  my $self = shift;
  $self->{'Description'} = shift
}

=head2 getDescription()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getDescription {
  my $self = shift;
  return $self->{'Description'};
}


=head2 setGrossDetailAmount()

Gross fees that are assessed by eBay (net fees plus VAT, if any).
Returned even if VAT does not apply.
The value is positive for debits and negative for credits.

#    Argument: 'ns:AmountType'

=cut

sub setGrossDetailAmount {
  my $self = shift;
  $self->{'GrossDetailAmount'} = shift
}

=head2 getGrossDetailAmount()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'ns:AmountType'

=cut

sub getGrossDetailAmount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'GrossDetailAmount'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setItemID()

Item ID (if the account detail entry is associated with an item listing)
or 0 (if no item listing is associated with the account entry).

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

#    Argument: 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = shift
}

=head2 getItemID()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemID'
		,'eBay::API::XML::DataType::ItemIDType');
}


=head2 setMemo()

Memo line for the account entry, can be an empty string.

#    Argument: 'xs:string'

=cut

sub setMemo {
  my $self = shift;
  $self->{'Memo'} = shift
}

=head2 getMemo()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getMemo {
  my $self = shift;
  return $self->{'Memo'};
}


=head2 setNetDetailAmount()

Net fees that are assessed by eBay, excluding additional surchargesand VAT (if
any). Returned even if VAT does not apply. The value is positive for debits (user pays eBay) and negative for
credits (eBay pays user).

#    Argument: 'ns:AmountType'

=cut

sub setNetDetailAmount {
  my $self = shift;
  $self->{'NetDetailAmount'} = shift
}

=head2 getNetDetailAmount()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'ns:AmountType'

=cut

sub getNetDetailAmount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'NetDetailAmount'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setRefNumber()

eBay reference number for the account entry. May return no value for some
account transactions, such as an administrative action like placing the
user's credit card on file.  You can uniquely identify
the entries that the GetAccount call returns within the AccountEntries tag.
Specifically, the following fields, returned within the AccountEntries tag,
can be used in combination as a unique key: AccountEntry.Date, AccountEntry.AccountDetailsEntryType,
AccountEntry.ItemID, and AccountEntry.RefNumber.

#    Argument: 'xs:string'

=cut

sub setRefNumber {
  my $self = shift;
  $self->{'RefNumber'} = shift
}

=head2 getRefNumber()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getRefNumber {
  my $self = shift;
  return $self->{'RefNumber'};
}


=head2 setTitle()

Title of the entry.

#    Argument: 'xs:string'

=cut

sub setTitle {
  my $self = shift;
  $self->{'Title'} = shift
}

=head2 getTitle()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getTitle {
  my $self = shift;
  return $self->{'Title'};
}


=head2 setVATPercent()

VAT rate for the item. When the VATPercent is specified, the
item's VAT information appears on the item's listing page. In
addition, the seller can choose to print an invoice that
includes the item's net price, VAT percent, VAT amount, and
total price. Since VAT rates vary
depending on the item and on the user's country of residence, a
seller is responsible for entering the correct VAT rate; it is
not calculated by eBay. To specify a VATPercent, a seller must
have a VAT-ID registered with eBay and must be listing the item
on a VAT-enabled site. Max precision 3
decimal places. Max length 5 characters. Note: The View Item
page displays the precision to 2 decimal places with no
trailing zeros. However, the full value you send in is stored.
Returned for all users, not just VAT users, with GetAccountResponse.

#    Argument: 'xs:decimal'

=cut

sub setVATPercent {
  my $self = shift;
  $self->{'VATPercent'} = shift
}

=head2 getVATPercent()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'xs:decimal'

=cut

sub getVATPercent {
  my $self = shift;
  return $self->{'VATPercent'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
